/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.common;

import com.namelessmc.plugin.common.NamelessPlugin;
import com.namelessmc.plugin.common.Reloadable;
import com.namelessmc.plugin.common.event.NamelessPlayerBanEvent;
import com.namelessmc.plugin.lib.configurate.CommentedConfigurationNode;
import com.namelessmc.plugin.lib.event.EventSubscription;
import com.namelessmc.plugin.lib.nameless-api.NamelessAPI;
import com.namelessmc.plugin.lib.nameless-api.NamelessUser;
import com.namelessmc.plugin.lib.nameless-api.exception.NamelessException;
import java.util.UUID;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nonempty.qual.UnknownNonEmpty;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;

public class SyncBanToWebsite
implements Reloadable {
    private final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin;
    private @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat EventSubscription subscription;

    SyncBanToWebsite(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void unload() {
        if (this.subscription != null) {
            this.subscription.unsubscribe();
            this.subscription = null;
        }
    }

    @Override
    public void load() {
        if (!((CommentedConfigurationNode)this.plugin.config().main().node(new Object[]{"sync-ban-to-website"})).getBoolean()) {
            return;
        }
        this.plugin.events().subscribe(NamelessPlayerBanEvent.class, event -> {
            UUID uuid = event.uuid();
            this.plugin.scheduler().runAsync(() -> {
                NamelessAPI api = this.plugin.apiProvider().api();
                if (api == null) {
                    this.plugin.logger().warning("Skipped trying to ban user, website connection is not working properly.");
                    return;
                }
                try {
                    NamelessUser user = api.userByMinecraftUuid(uuid);
                    if (user != null) {
                        if (user.isBanned()) {
                            this.plugin.logger().info("User " + user.username() + " is already banned");
                        } else {
                            user.banUser();
                            this.plugin.logger().info("Banned user on website");
                        }
                    }
                }
                catch (NamelessException e) {
                    this.plugin.logger().warning("Failed to ban player on website");
                    this.plugin.logger().logException(e);
                }
            });
        });
    }
}

