/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.common;

import com.namelessmc.plugin.common.ConfigurationHandler;
import com.namelessmc.plugin.common.NamelessPlugin;
import com.namelessmc.plugin.common.Reloadable;
import com.namelessmc.plugin.common.audiences.NamelessConsole;
import com.namelessmc.plugin.common.command.AbstractScheduledTask;
import com.namelessmc.plugin.lib.configurate.CommentedConfigurationNode;
import com.namelessmc.plugin.lib.configurate.ConfigurationNode;
import com.namelessmc.plugin.lib.nameless-api.NamelessAPI;
import com.namelessmc.plugin.lib.nameless-api.exception.NamelessException;
import com.namelessmc.plugin.lib.nameless-api.modules.websend.WebsendCommand;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nonempty.qual.UnknownNonEmpty;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;

public class Websend
implements Reloadable {
    private static final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat int SEND_LOG_MAX_BYTES = 50000;
    private final @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin;
    private final @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Path logPath;
    private @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat AbstractScheduledTask commandTask;
    private final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Object commandLock = new Object();
    private @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat AbstractScheduledTask logTask;
    private final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Object logLock = new Object();
    private @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat int previousLogSize = 0;
    private @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat boolean clearPrevious = true;

    Websend(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin, @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Path logPath) {
        this.plugin = plugin;
        this.logPath = logPath;
    }

    @Override
    public void unload() {
        if (this.logTask != null) {
            this.logTask.cancel();
            this.logTask = null;
        }
        if (this.commandTask != null) {
            this.commandTask.cancel();
            this.commandTask = null;
        }
    }

    @Override
    public void load() {
        Duration interval;
        ConfigurationNode config = this.plugin.config().modules().node(new Object[]{"websend"});
        if (config.node("command-executor", "enabled").getBoolean()) {
            interval = ConfigurationHandler.getDuration(config.node("command-executor", "interval"));
            if (interval == null) {
                this.plugin.logger().warning("Websend command executor interval invalid");
                return;
            }
            this.commandTask = this.plugin.scheduler().runTimer(this::executeCommands, interval);
        }
        if (config.node("send-logs", "enabled").getBoolean()) {
            interval = ConfigurationHandler.getDuration(config.node("send-logs", "interval"));
            if (interval == null) {
                this.plugin.logger().warning("Websend send-logs interval invalid");
                return;
            }
            this.logTask = this.plugin.scheduler().runTimer(this::sendLogLines, interval);
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String readToString(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Path path, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat int start, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat int length) throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat IOException {
        try (FileChannel channel = FileChannel.open(path, new OpenOption[0]);){
            channel.position(start);
            ByteBuffer buffer = ByteBuffer.allocate(length);
            while (buffer.hasRemaining()) {
                channel.read(buffer);
            }
            buffer.position(0);
            String string = StandardCharsets.UTF_8.decode(buffer).toString();
            return string;
        }
    }

    void sendLogLines() {
        this.plugin.scheduler().runAsync(() -> {
            Object object = this.logLock;
            synchronized (object) {
                try {
                    int readStart;
                    int newSize;
                    int diff;
                    Path log = this.logPath;
                    if (log == null) {
                        this.plugin.logger().warning("Not sending logs, capturing logs not supported on your platform.");
                        return;
                    }
                    if (!Files.isRegularFile(log, new LinkOption[0])) {
                        this.plugin.logger().warning("Log file does not exist or is not a regular file: " + String.valueOf(log.toAbsolutePath()));
                        return;
                    }
                    long newSizeLong = Files.size(log);
                    if (newSizeLong > Integer.MAX_VALUE) {
                        this.plugin.logger().warning("Log file is too large to read");
                    }
                    if ((diff = (newSize = (int)newSizeLong) - this.previousLogSize) == 0) {
                        return;
                    }
                    if (diff > 50000) {
                        readStart = newSize - 50000;
                    } else if (diff > 0) {
                        readStart = this.previousLogSize;
                    } else {
                        this.plugin.logger().info("Log file was rotated or deleted, Websend may have missed some lines written to the old log.");
                        readStart = Math.max(0, newSize - 50000);
                    }
                    int readSize = newSize - readStart;
                    String logString = Websend.readToString(log, readStart, readSize);
                    if (!logString.endsWith("\n")) {
                        this.plugin.logger().info("Server is busy writing to the log file, trying again later");
                        return;
                    }
                    String[] split = logString.split("\n");
                    ArrayList<String> lines = new ArrayList<String>(split.length);
                    if (readSize == 50000) {
                        lines.add(0, "[websend: skipped lines]");
                        lines.addAll(Arrays.asList(split).subList(1, split.length));
                    } else {
                        lines.addAll(Arrays.asList(split));
                    }
                    NamelessAPI api = this.plugin.apiProvider().api();
                    if (api == null) {
                        return;
                    }
                    int serverId = ((CommentedConfigurationNode)this.plugin.config().main().node(new Object[]{"api", "server-id"})).getInt(0);
                    if (serverId <= 0) {
                        this.plugin.logger().warning("server-id is not configured");
                        return;
                    }
                    api.websend().sendConsoleLog(serverId, lines, this.clearPrevious);
                    this.clearPrevious = false;
                    this.previousLogSize = newSize;
                }
                catch (IOException e) {
                    this.plugin.logger().warning("Encountered an exception while trying to read the log file");
                    this.plugin.logger().logException(e);
                }
                catch (NamelessException e) {
                    this.plugin.logger().warning("Encountered an exception while sending server logs to website");
                    this.plugin.logger().logException(e);
                }
            }
        });
    }

    private void executeCommands() {
        int serverId = ((CommentedConfigurationNode)this.plugin.config().main().node(new Object[]{"api", "server-id"})).getInt(0);
        if (serverId <= 0) {
            this.plugin.logger().warning("Websend is enabled but 'api.server-id' in main.yaml is not set properly.");
            return;
        }
        this.plugin.scheduler().runAsync(() -> {
            NamelessAPI api = this.plugin.apiProvider().api();
            if (api == null) {
                return;
            }
            Object object = this.commandLock;
            synchronized (object) {
                try {
                    List<WebsendCommand> commands = api.websend().commands(serverId);
                    if (commands.isEmpty()) {
                        return;
                    }
                    this.plugin.scheduler().runSync(() -> {
                        NamelessConsole console = this.plugin.audiences().console();
                        for (WebsendCommand command : commands) {
                            try {
                                console.dispatchCommand(command.command());
                            }
                            catch (Exception e) {
                                this.plugin.logger().logException(e);
                            }
                        }
                    });
                }
                catch (NamelessException e) {
                    this.plugin.logger().severe("Error retrieving websend commands");
                    this.plugin.logger().logException(e);
                }
            }
        });
    }
}

