/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.common.command;

import com.namelessmc.plugin.common.LanguageHandler;
import com.namelessmc.plugin.common.NamelessPlugin;
import com.namelessmc.plugin.common.Permission;
import com.namelessmc.plugin.common.audiences.NamelessCommandSender;
import com.namelessmc.plugin.common.audiences.NamelessPlayer;
import com.namelessmc.plugin.common.command.CommonCommand;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nonempty.qual.UnknownNonEmpty;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;

public class NamelessPluginCommand
extends CommonCommand {
    public NamelessPluginCommand(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin) {
        super(plugin, "plugin", LanguageHandler.Term.COMMAND_PLUGIN_USAGE, LanguageHandler.Term.COMMAND_PLUGIN_DESCRIPTION, Permission.COMMAND_PLUGIN);
        if (this.actualName() == null) {
            plugin.logger().warning("The commands config file is missing the plugin command");
        }
    }

    @Override
    public void execute(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessCommandSender sender, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat [] args) {
        if (args.length == 1) {
            switch (args[0]) {
                case "reload": 
                case "rl": {
                    this.plugin().unload();
                    this.plugin().load();
                    sender.sendMessage(this.language().get(LanguageHandler.Term.COMMAND_PLUGIN_OUTPUT_RELOAD_SUCCESSFUL));
                    return;
                }
                case "last_error": {
                    String stackTrace = this.plugin().logger().getLastExceptionStackTrace();
                    if (stackTrace == null) {
                        sender.sendMessage((Component)Component.text((String)"No error since last plugin reload."));
                        return;
                    }
                    this.plugin().logger().warning(stackTrace);
                    if (sender instanceof NamelessPlayer) {
                        sender.sendMessage((Component)Component.text((String)"Last error has been printed to the console"));
                    }
                    return;
                }
            }
        }
        sender.sendMessage(this.usage());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat List<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String> complete(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessCommandSender sender, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat [] args) {
        if (args.length == 1) {
            return Arrays.stream(new String[]{"reload", "rl", "last_api_error"}).filter(s -> s.startsWith(args[0])).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

