/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.common.command;

import com.namelessmc.plugin.common.LanguageHandler;
import com.namelessmc.plugin.common.NamelessPlugin;
import com.namelessmc.plugin.common.Permission;
import com.namelessmc.plugin.common.audiences.NamelessCommandSender;
import com.namelessmc.plugin.common.audiences.NamelessPlayer;
import com.namelessmc.plugin.common.command.CommonCommand;
import com.namelessmc.plugin.lib.configurate.CommentedConfigurationNode;
import com.namelessmc.plugin.lib.nameless-api.NamelessAPI;
import com.namelessmc.plugin.lib.nameless-api.exception.ApiException;
import com.namelessmc.plugin.lib.nameless-api.exception.NamelessException;
import com.namelessmc.plugin.lib.nameless-api.integrations.IntegrationData;
import com.namelessmc.plugin.lib.nameless-api.integrations.MinecraftIntegrationData;
import java.util.Optional;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nonempty.qual.UnknownNonEmpty;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;

public class RegisterCommand
extends CommonCommand {
    public RegisterCommand(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin) {
        super(plugin, "register", LanguageHandler.Term.COMMAND_REGISTER_USAGE, LanguageHandler.Term.COMMAND_REGISTER_DESCRIPTION, Permission.COMMAND_REGISTER);
    }

    @Override
    public void execute(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessCommandSender sender, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat [] args) {
        String username;
        if (args.length != 1 && args.length != 2) {
            sender.sendMessage(this.usage());
            return;
        }
        String email = args[0];
        if (args.length == 2) {
            username = args[1];
        } else if (sender instanceof NamelessPlayer) {
            username = ((NamelessPlayer)sender).username();
        } else {
            sender.sendMessage(this.language().get(LanguageHandler.Term.COMMAND_REGISTER_OUTPUT_FAIL_CONSOLE_MUST_SPECIFY_USERNAME));
            return;
        }
        if (!((CommentedConfigurationNode)this.plugin().config().main().node(new Object[]{"register-custom-username"})).getBoolean(true) && sender instanceof NamelessPlayer && !username.equalsIgnoreCase(((NamelessPlayer)sender).username())) {
            sender.sendMessage(this.language().get(LanguageHandler.Term.COMMAND_REGISTER_OUTPUT_FAIL_CUSTOM_USERNAME_DISABLED));
            return;
        }
        this.scheduler().runAsync(() -> {
            NamelessAPI api = this.apiProvider().api();
            if (api == null) {
                sender.sendMessage(this.language().get(LanguageHandler.Term.ERROR_WEBSITE_CONNECTION));
                return;
            }
            try {
                Optional<String> link;
                if (sender instanceof NamelessPlayer) {
                    NamelessPlayer player = (NamelessPlayer)sender;
                    MinecraftIntegrationData integrationData = new MinecraftIntegrationData(player.uuid(), player.username());
                    link = api.registerUser(username, email, integrationData);
                    this.plugin().groupSync().resetGroups(player);
                } else {
                    link = api.registerUser(username, email, new IntegrationData[0]);
                }
                if (link.isPresent()) {
                    sender.sendMessage(this.language().get(LanguageHandler.Term.COMMAND_REGISTER_OUTPUT_SUCCESS_LINK, "url", link.get()));
                } else {
                    sender.sendMessage(this.language().get(LanguageHandler.Term.COMMAND_REGISTER_OUTPUT_SUCCESS_EMAIL));
                }
            }
            catch (NamelessException e) {
                if (e instanceof ApiException) {
                    switch (((ApiException)e).apiError()) {
                        case CORE_INVALID_USERNAME: {
                            sender.sendMessage(this.language().get(LanguageHandler.Term.COMMAND_REGISTER_OUTPUT_FAIL_USERNAME_INVALID));
                            return;
                        }
                        case CORE_UNABLE_TO_SEND_REGISTRATION_EMAIL: {
                            sender.sendMessage(this.language().get(LanguageHandler.Term.COMMAND_REGISTER_OUTPUT_FAIL_CANNOT_SEND_EMAIL));
                            return;
                        }
                        case CORE_USERNAME_ALREADY_EXISTS: {
                            sender.sendMessage(this.language().get(LanguageHandler.Term.COMMAND_REGISTER_OUTPUT_FAIL_USERNAME_USED));
                            return;
                        }
                        case CORE_INVALID_EMAIL_ADDRESS: {
                            sender.sendMessage(this.language().get(LanguageHandler.Term.COMMAND_REGISTER_OUTPUT_FAIL_EMAIL_INVALID));
                            return;
                        }
                        case CORE_EMAIL_ALREADY_EXISTS: {
                            sender.sendMessage(this.language().get(LanguageHandler.Term.COMMAND_REGISTER_OUTPUT_FAIL_EMAIL_USED));
                            return;
                        }
                        case CORE_INTEGRATION_IDENTIFIER_ERROR: 
                        case CORE_INTEGRATION_USERNAME_ERROR: {
                            sender.sendMessage(this.language().get(LanguageHandler.Term.COMMAND_REGISTER_OUTPUT_FAIL_MINECRAFT_USED));
                            return;
                        }
                    }
                }
                sender.sendMessage(this.language().get(LanguageHandler.Term.ERROR_WEBSITE_CONNECTION));
                this.logger().logException(e);
            }
        });
    }
}

