/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.common.logger;

import com.google.gson.JsonSyntaxException;
import com.namelessmc.plugin.common.ConfigurationHandler;
import com.namelessmc.plugin.common.Reloadable;
import com.namelessmc.plugin.lib.configurate.CommentedConfigurationNode;
import com.namelessmc.plugin.lib.nameless-api.exception.ApiError;
import com.namelessmc.plugin.lib.nameless-api.exception.ApiException;
import com.namelessmc.plugin.lib.nameless-api.logger.ApiLogger;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.function.Supplier;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nonempty.qual.UnknownNonEmpty;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;

public abstract class AbstractLogger
implements Reloadable {
    private final @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat ApiLogger apiLogger = new ApiLoggerImpl();
    private final @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat ConfigurationHandler config;
    private @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat boolean verbose;
    private @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Throwable lastException;

    protected AbstractLogger(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat ConfigurationHandler config) {
        this.config = config;
    }

    public @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat ApiLogger getApiLogger() {
        return this.apiLogger;
    }

    public abstract void info(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String var1);

    public abstract void warning(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String var1);

    public abstract void severe(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String var1);

    public void fine(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String string) {
        if (this.verbose) {
            this.info(string);
        }
    }

    public abstract void info(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Supplier<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String> var1);

    public abstract void warning(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Supplier<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String> var1);

    public abstract void severe(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Supplier<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String> var1);

    public void fine(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Supplier<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String> stringSupplier) {
        if (this.verbose) {
            this.info(stringSupplier);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat boolean isVerbose() {
        return this.verbose;
    }

    public void logException(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Throwable t) {
        this.lastException = t;
        String pluginCommand = null;
        try {
            pluginCommand = ((CommentedConfigurationNode)this.config.commands().node(new Object[]{"plugin"})).getString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String lastErrorCommand = "Run /" + (pluginCommand != null ? pluginCommand : "CONFIG_ERROR") + " last_error to retrieve the full stack trace.";
        if (!this.printReducedException(t, lastErrorCommand)) {
            this.severe("Unexpected error: " + t.getMessage());
            this.severe(AbstractLogger.stackTraceAsString(t));
        }
    }

    private @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat boolean printReducedException(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Throwable t, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String lastErrorCommand) {
        if (t instanceof ApiException) {
            ApiError apiError = ((ApiException)t).apiError();
            switch (apiError) {
                case NAMELESS_API_IS_DISABLED: {
                    this.severe("Cannot connect to your website, the API is disabled. " + lastErrorCommand);
                    break;
                }
                case NAMELESS_NOT_AUTHORIZED: {
                    this.severe("Cannot connect to your website, the API key is invalid. Please get an up-to-date API URL from StaffCP > Configuration > API and reload the plugin. " + lastErrorCommand);
                    break;
                }
                default: {
                    this.severe("Cannot connect to your website, got an unexpected API error: " + t.getMessage() + ". " + lastErrorCommand);
                }
            }
            return true;
        }
        if (t instanceof JsonSyntaxException) {
            this.warning("The website didn't return a valid json response. " + lastErrorCommand);
            return true;
        }
        if (t.getCause() != null) {
            return this.printReducedException(t.getCause(), lastErrorCommand);
        }
        if (t instanceof IOException) {
            this.warning("Could not connect to your website due to a network connection error ('" + t.getClass().getSimpleName() + ": " + t.getMessage() + "'). " + lastErrorCommand);
            return true;
        }
        return false;
    }

    public @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String getLastExceptionStackTrace() {
        return this.lastException != null ? AbstractLogger.stackTraceAsString(this.lastException) : null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String stackTraceAsString(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Throwable t) {
        try (StringWriter out = new StringWriter();){
            PrintWriter writer = new PrintWriter(out);
            try {
                t.printStackTrace(writer);
                String string = out.toString();
                writer.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void unload() {
        this.lastException = null;
    }

    @Override
    public void load() {
        this.verbose = ((CommentedConfigurationNode)this.config.main().node(new Object[]{"logging", "verbose"})).getBoolean();
    }

    private class ApiLoggerImpl
    extends ApiLogger {
        private ApiLoggerImpl() {
        }

        @Override
        public void log(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String string) {
            AbstractLogger.this.info("[Nameless-Java-API Debug] " + string);
        }
    }
}

