/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.configurate.serialize;

import com.namelessmc.plugin.lib.configurate.ConfigurationNode;
import com.namelessmc.plugin.lib.configurate.serialize.SerializationException;
import com.namelessmc.plugin.lib.configurate.serialize.TypeSerializer;
import java.io.File;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

final class FileSerializer
implements TypeSerializer<File> {
    static final FileSerializer INSTANCE = new FileSerializer();
    static final Class<File> TYPE = File.class;

    private FileSerializer() {
    }

    @Override
    public File deserialize(Type type, ConfigurationNode node) throws SerializationException {
        return Objects.requireNonNull(node.get(Path.class), "node did not contain a valid path").toFile();
    }

    @Override
    public void serialize(Type type, @Nullable File obj, ConfigurationNode node) throws SerializationException {
        if (obj == null) {
            node.set(null);
        } else {
            node.set(Path.class, obj.toPath());
        }
    }
}

