/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.derkutils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import org.checkerframework.checker.formatter.qual.FormatBottom;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.checker.optional.qual.Present;
import org.checkerframework.checker.regex.qual.RegexBottom;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.aliasing.qual.NonLeaked;

public class FileUtils {
    public static @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String getFileName(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat File file) {
        String name = file.getName();
        int pos = name.lastIndexOf(".");
        if (pos > 0) {
            name = name.substring(0, pos);
        }
        return name;
    }

    public static void copyOutOfJar(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @NonLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present @UnknownRegex @RegexBottom @UnknownFormat @FormatBottom ?> clazz, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String pathToFileInJar, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat File outputFile) throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat IOException {
        Objects.requireNonNull(clazz, "Class is null");
        Objects.requireNonNull(pathToFileInJar, "File path is null");
        Objects.requireNonNull(outputFile, "Output file is null");
        if (!outputFile.exists()) {
            URL inputUrl = clazz.getResource(pathToFileInJar);
            try (InputStream in = inputUrl.openStream();){
                Files.copy(in, outputFile.toPath(), new CopyOption[0]);
            }
        }
    }

    public static void copyOutOfJar(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @NonLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present @UnknownRegex @RegexBottom @UnknownFormat @FormatBottom ?> clazz, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String pathToFileInJar, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Path outputFile) throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat IOException {
        Objects.requireNonNull(clazz, "Class is null");
        Objects.requireNonNull(pathToFileInJar, "File path is null");
        Objects.requireNonNull(outputFile, "Output file is null");
        if (!Files.exists(outputFile, new LinkOption[0])) {
            try (InputStream in = Objects.requireNonNull(clazz.getClassLoader().getResourceAsStream(pathToFileInJar), "path does not exist in jar: " + pathToFileInJar);){
                Files.copy(in, outputFile, new CopyOption[0]);
            }
        }
    }
}

