/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.methanol;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.namelessmc.plugin.lib.methanol.BodyAdapter;
import com.namelessmc.plugin.lib.methanol.TypeRef;
import com.namelessmc.plugin.lib.methanol.internal.Utils;
import com.namelessmc.plugin.lib.methanol.internal.Validate;
import com.namelessmc.plugin.lib.methanol.internal.spi.ServiceProviders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class AdapterCodec {
    private static final ServiceProviders<BodyAdapter.Encoder> installedEncoders = new ServiceProviders<BodyAdapter.Encoder>(BodyAdapter.Encoder.class);
    private static final ServiceProviders<BodyAdapter.Decoder> installedDecoders = new ServiceProviders<BodyAdapter.Decoder>(BodyAdapter.Decoder.class);
    private static @MonotonicNonNull AdapterCodec lazyInstalledCodec;
    private final List<BodyAdapter.Encoder> encoders;
    private final List<BodyAdapter.Decoder> decoders;

    private AdapterCodec(List<BodyAdapter.Encoder> encoders, List<BodyAdapter.Decoder> decoders) {
        this.encoders = List.copyOf(encoders);
        this.decoders = List.copyOf(decoders);
    }

    public List<BodyAdapter.Encoder> encoders() {
        return this.encoders;
    }

    public List<BodyAdapter.Decoder> decoders() {
        return this.decoders;
    }

    public <T> HttpRequest.BodyPublisher publisherOf(T value, BodyAdapter.Hints hints) {
        return this.publisherOf(value, TypeRef.ofRuntimeType(value), hints);
    }

    public <T> HttpRequest.BodyPublisher publisherOf(T value, TypeRef<T> typeRef, BodyAdapter.Hints hints) {
        Validate.requireArgument(typeRef.rawType().isInstance(Objects.requireNonNull(value)), "Expected %s to be an instance of %s", value, typeRef);
        return this.lookupEncoder(typeRef, hints).orElseThrow(() -> AdapterCodec.unsupportedConversion("from", typeRef, hints)).toBody(value, typeRef, hints);
    }

    public <T> HttpResponse.BodySubscriber<T> subscriberOf(TypeRef<T> typeRef, BodyAdapter.Hints hints) {
        return this.lookupDecoder(typeRef, hints).orElseThrow(() -> AdapterCodec.unsupportedConversion("to", typeRef, hints)).toObject(typeRef, hints);
    }

    public <T> HttpResponse.BodySubscriber<Supplier<T>> deferredSubscriberOf(TypeRef<T> typeRef, BodyAdapter.Hints hints) {
        return this.lookupDecoder(typeRef, hints).orElseThrow(() -> AdapterCodec.unsupportedConversion("to", typeRef, hints)).toDeferredObject(typeRef, hints);
    }

    public <T> HttpResponse.BodyHandler<T> handlerOf(TypeRef<T> typeRef, BodyAdapter.Hints hints) {
        AdapterCodec.requireDecoderSupport(this.decoders, typeRef);
        return responseInfo -> this.subscriberOf(typeRef, hints.mutate().forDecoder(responseInfo).build());
    }

    public <T> HttpResponse.BodyHandler<Supplier<T>> deferredHandlerOf(TypeRef<T> typeRef, BodyAdapter.Hints hints) {
        AdapterCodec.requireDecoderSupport(this.decoders, typeRef);
        return responseInfo -> this.deferredSubscriberOf(typeRef, hints.mutate().forDecoder(responseInfo).build());
    }

    Optional<BodyAdapter.Encoder> lookupEncoder(TypeRef<?> typeRef, BodyAdapter.Hints hints) {
        return AdapterCodec.lookup(this.encoders, typeRef, hints);
    }

    Optional<BodyAdapter.Decoder> lookupDecoder(TypeRef<?> typeRef, BodyAdapter.Hints hints) {
        return AdapterCodec.lookup(this.decoders, typeRef, hints);
    }

    public String toString() {
        return Utils.toStringIdentityPrefix(this) + "[encoders=" + this.encoders + ", decoders=" + this.decoders + "]";
    }

    private static <T extends BodyAdapter> Optional<T> lookup(List<T> adapters, TypeRef<?> typeRef, BodyAdapter.Hints hints) {
        Objects.requireNonNull(typeRef);
        Objects.requireNonNull(hints);
        return adapters.stream().filter(encoder -> encoder.supportsType(typeRef) && encoder.isCompatibleWith(hints.mediaTypeOrAny())).findFirst();
    }

    private static void requireDecoderSupport(List<BodyAdapter.Decoder> decoders, TypeRef<?> typeRef) {
        Objects.requireNonNull(typeRef);
        if (decoders.stream().noneMatch(decoder -> decoder.supportsType(typeRef))) {
            throw AdapterCodec.unsupportedConversion("to", typeRef, BodyAdapter.Hints.empty());
        }
    }

    private static UnsupportedOperationException unsupportedConversion(String preposition, TypeRef<?> typeRef, BodyAdapter.Hints hints) {
        return new UnsupportedOperationException("Unsupported conversion " + preposition + " an object of type <" + typeRef + "> with <" + hints + ">");
    }

    public static AdapterCodec installed() {
        AdapterCodec installedCodec = lazyInstalledCodec;
        if (installedCodec == null) {
            lazyInstalledCodec = installedCodec = new AdapterCodec(installedEncoders.get(), installedDecoders.get());
        }
        return installedCodec;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private final List<BodyAdapter.Encoder> encoders = new ArrayList<BodyAdapter.Encoder>();
        private final List<BodyAdapter.Decoder> decoders = new ArrayList<BodyAdapter.Decoder>();

        Builder() {
        }

        @CanIgnoreReturnValue
        public Builder encoder(BodyAdapter.Encoder encoder) {
            this.encoders.add(Objects.requireNonNull(encoder));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder decoder(BodyAdapter.Decoder decoder) {
            this.decoders.add(Objects.requireNonNull(decoder));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder basicEncoder() {
            return this.encoder(BodyAdapter.Encoder.basic());
        }

        @CanIgnoreReturnValue
        public Builder basicDecoder() {
            return this.decoder(BodyAdapter.Decoder.basic());
        }

        @CanIgnoreReturnValue
        public Builder basic() {
            return this.basicEncoder().basicDecoder();
        }

        public AdapterCodec build() {
            return new AdapterCodec(this.encoders, this.decoders);
        }
    }
}

