/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.methanol;

import java.net.http.HttpResponse;

public class HttpStatus {
    private HttpStatus() {
    }

    public static boolean isInformational(int statusCode) {
        return StatusKind.INFORMATIONAL.includes(statusCode);
    }

    public static boolean isInformational(HttpResponse<?> response) {
        return HttpStatus.isInformational(response.statusCode());
    }

    public static boolean isSuccessful(int statusCode) {
        return StatusKind.SUCCESSFUL.includes(statusCode);
    }

    public static boolean isSuccessful(HttpResponse<?> response) {
        return HttpStatus.isSuccessful(response.statusCode());
    }

    public static boolean isRedirection(int statusCode) {
        return StatusKind.REDIRECTION.includes(statusCode);
    }

    public static boolean isRedirection(HttpResponse<?> response) {
        return HttpStatus.isRedirection(response.statusCode());
    }

    public static boolean isClientError(int statusCode) {
        return StatusKind.CLIENT_ERROR.includes(statusCode);
    }

    public static boolean isClientError(HttpResponse<?> response) {
        return HttpStatus.isClientError(response.statusCode());
    }

    public static boolean isServerError(int statusCode) {
        return StatusKind.SERVER_ERROR.includes(statusCode);
    }

    public static boolean isServerError(HttpResponse<?> response) {
        return HttpStatus.isServerError(response.statusCode());
    }

    static enum StatusKind {
        INFORMATIONAL(100),
        SUCCESSFUL(200),
        REDIRECTION(300),
        CLIENT_ERROR(400),
        SERVER_ERROR(500);

        private final int from;
        private final int to;

        private StatusKind(int from) {
            this(from, from + 99);
        }

        private StatusKind(int from, int to) {
            this.from = from;
            this.to = to;
        }

        boolean includes(int statusCode) {
            return statusCode >= this.from && statusCode <= this.to;
        }
    }
}

