/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.methanol;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.namelessmc.plugin.lib.methanol.CacheAwareResponse;
import com.namelessmc.plugin.lib.methanol.HeadersAccumulator;
import com.namelessmc.plugin.lib.methanol.TrackedResponse;
import com.namelessmc.plugin.lib.methanol.internal.Validate;
import com.namelessmc.plugin.lib.methanol.internal.extensions.HeadersBuilder;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import javax.net.ssl.SSLSession;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ResponseBuilder<T>
implements HeadersAccumulator<ResponseBuilder<T>> {
    private static final @Nullable Class<?> jdkHttpResponseClass;
    private static final int UNSET_STATUS_CODE = -1;
    private final HeadersBuilder headersBuilder = new HeadersBuilder();
    private int statusCode = -1;
    private @MonotonicNonNull URI uri;
    private  @MonotonicNonNull HttpClient.Version version;
    private @MonotonicNonNull HttpRequest request;
    private @MonotonicNonNull Instant timeRequestSent;
    private @MonotonicNonNull Instant timeResponseReceived;
    private @Nullable Object body;
    private @Nullable SSLSession sslSession;
    private @Nullable HttpResponse<T> previousResponse;
    private @Nullable TrackedResponse<?> networkResponse;
    private @Nullable TrackedResponse<?> cacheResponse;
    private @MonotonicNonNull CacheAwareResponse.CacheStatus cacheStatus;

    private ResponseBuilder() {
    }

    @CanIgnoreReturnValue
    public ResponseBuilder<T> apply(Consumer<? super ResponseBuilder<T>> mutator) {
        mutator.accept(this);
        return this;
    }

    @CanIgnoreReturnValue
    public ResponseBuilder<T> statusCode(int statusCode) {
        Validate.requireArgument(statusCode >= 0, "Negative status code");
        this.statusCode = statusCode;
        return this;
    }

    @CanIgnoreReturnValue
    public ResponseBuilder<T> uri(URI uri) {
        this.uri = Objects.requireNonNull(uri);
        return this;
    }

    @CanIgnoreReturnValue
    public ResponseBuilder<T> uri(String uri) {
        return this.uri(URI.create(uri));
    }

    @CanIgnoreReturnValue
    public ResponseBuilder<T> version(HttpClient.Version version) {
        this.version = Objects.requireNonNull(version);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public ResponseBuilder<T> header(String name, String value) {
        this.headersBuilder.add(name, value);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public ResponseBuilder<T> headers(String ... headers) {
        this.headersBuilder.addAll(headers);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public ResponseBuilder<T> headers(HttpHeaders headers) {
        this.headersBuilder.addAll(headers);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public ResponseBuilder<T> setHeader(String name, String value) {
        this.headersBuilder.set(name, value);
        return this;
    }

    @Override
    public ResponseBuilder<T> setHeader(String name, List<String> values) {
        this.headersBuilder.set(name, values);
        return this;
    }

    @Override
    public ResponseBuilder<T> setHeaderIfAbsent(String name, String value) {
        this.headersBuilder.setIfAbsent(name, value);
        return this;
    }

    @Override
    public ResponseBuilder<T> setHeaderIfAbsent(String name, List<String> values) {
        this.headersBuilder.setIfAbsent(name, values);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public ResponseBuilder<T> removeHeaders() {
        this.headersBuilder.clear();
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public ResponseBuilder<T> removeHeader(String name) {
        this.headersBuilder.remove(name);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public ResponseBuilder<T> removeHeadersIf(BiPredicate<String, String> filter) {
        this.headersBuilder.removeIf(filter);
        return this;
    }

    @CanIgnoreReturnValue
    public ResponseBuilder<T> request(HttpRequest request) {
        this.request = Objects.requireNonNull(request);
        return this;
    }

    @CanIgnoreReturnValue
    public ResponseBuilder<T> timeRequestSent(Instant timeRequestSent) {
        this.timeRequestSent = Objects.requireNonNull(timeRequestSent);
        return this;
    }

    @CanIgnoreReturnValue
    public ResponseBuilder<T> timeResponseReceived(Instant timeResponseReceived) {
        this.timeResponseReceived = Objects.requireNonNull(timeResponseReceived);
        return this;
    }

    @CanIgnoreReturnValue
    public <U> ResponseBuilder<U> body(@Nullable U body) {
        this.body = body;
        return this;
    }

    @CanIgnoreReturnValue
    public ResponseBuilder<T> dropBody() {
        return this.body(null);
    }

    @CanIgnoreReturnValue
    public ResponseBuilder<T> sslSession(@Nullable SSLSession sslSession) {
        this.sslSession = sslSession;
        return this;
    }

    @CanIgnoreReturnValue
    public ResponseBuilder<T> previousResponse(@Nullable HttpResponse<T> previousResponse) {
        this.previousResponse = previousResponse;
        return this;
    }

    @CanIgnoreReturnValue
    public ResponseBuilder<T> networkResponse(@Nullable TrackedResponse<?> networkResponse) {
        this.networkResponse = networkResponse;
        return this;
    }

    @CanIgnoreReturnValue
    public ResponseBuilder<T> cacheResponse(@Nullable TrackedResponse<?> cacheResponse) {
        this.cacheResponse = cacheResponse;
        return this;
    }

    @CanIgnoreReturnValue
    public ResponseBuilder<T> cacheStatus(CacheAwareResponse.CacheStatus cacheStatus) {
        this.cacheStatus = Objects.requireNonNull(cacheStatus);
        return this;
    }

    public HttpResponse<T> build() {
        if (this.cacheStatus != null) {
            return this.buildCacheAwareResponse();
        }
        if (this.timeRequestSent != null || this.timeResponseReceived != null) {
            return this.buildTrackedResponse();
        }
        return new HttpResponseImpl<Object>(ResponseBuilder.ensureSet(this.statusCode, "statusCode"), ResponseBuilder.ensureSet(this.uri, "uri"), ResponseBuilder.ensureSet(this.version, "version"), this.headersBuilder.build(), ResponseBuilder.ensureSet(this.request, "request"), this.body, this.sslSession, this.previousResponse);
    }

    public TrackedResponse<T> buildTrackedResponse() {
        if (this.cacheStatus != null) {
            return this.buildCacheAwareResponse();
        }
        return new TrackedResponseImpl<Object>(ResponseBuilder.ensureSet(this.statusCode, "statusCode"), ResponseBuilder.ensureSet(this.uri, "uri"), ResponseBuilder.ensureSet(this.version, "version"), this.headersBuilder.build(), ResponseBuilder.ensureSet(this.request, "request"), this.body, this.sslSession, this.previousResponse, ResponseBuilder.ensureSet(this.timeRequestSent, "timeRequestSent"), ResponseBuilder.ensureSet(this.timeResponseReceived, "timeResponseReceived"));
    }

    public CacheAwareResponse<T> buildCacheAwareResponse() {
        return new CacheAwareResponseImpl<Object>(ResponseBuilder.ensureSet(this.statusCode, "statusCode"), ResponseBuilder.ensureSet(this.uri, "uri"), ResponseBuilder.ensureSet(this.version, "version"), this.headersBuilder.build(), ResponseBuilder.ensureSet(this.request, "request"), this.body, this.sslSession, this.previousResponse, ResponseBuilder.ensureSet(this.timeRequestSent, "timeRequestSent"), ResponseBuilder.ensureSet(this.timeResponseReceived, "timeResponseReceived"), this.networkResponse, this.cacheResponse, ResponseBuilder.ensureSet(this.cacheStatus, "cacheStatus"));
    }

    @CanIgnoreReturnValue
    private ResponseBuilder<T> headers(HttpHeaders headers, boolean bypassHeaderValidation) {
        if (bypassHeaderValidation) {
            this.headersBuilder.addAllLenient(headers);
        } else {
            this.headersBuilder.addAll(headers);
        }
        return this;
    }

    public static <T> ResponseBuilder<T> create() {
        return new ResponseBuilder<T>();
    }

    public static <T> ResponseBuilder<T> from(HttpResponse<T> response) {
        ResponseBuilder<T> builder = new ResponseBuilder<T>().statusCode(response.statusCode()).uri(response.uri()).version(response.version()).headers(response.headers(), ResponseBuilder.isTrusted(response)).request(response.request()).body(response.body());
        response.previousResponse().ifPresent(builder::previousResponse);
        response.sslSession().ifPresent(builder::sslSession);
        if (response instanceof TrackedResponse) {
            TrackedResponse trackedResponse = (TrackedResponse)response;
            builder.timeRequestSent(trackedResponse.timeRequestSent()).timeResponseReceived(trackedResponse.timeResponseReceived());
        }
        if (response instanceof CacheAwareResponse) {
            CacheAwareResponse cacheAwareResponse = (CacheAwareResponse)response;
            builder.networkResponse(cacheAwareResponse.networkResponse().orElse(null)).cacheResponse(cacheAwareResponse.cacheResponse().orElse(null)).cacheStatus(cacheAwareResponse.cacheStatus());
        }
        return builder;
    }

    private static boolean isTrusted(HttpResponse<?> response) {
        return response instanceof HttpResponseImpl || jdkHttpResponseClass != null && jdkHttpResponseClass.isInstance(response);
    }

    private static <T> @NonNull T ensureSet(@Nullable T property, String name) {
        Validate.requireState(property != null, "%s is required", name);
        return Validate.castNonNull(property);
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("jdk.internal.net.http.HttpResponseImpl");
        }
        catch (ClassNotFoundException e) {
            clazz = null;
        }
        jdkHttpResponseClass = clazz;
    }

    private static final class CacheAwareResponseImpl<T>
    extends TrackedResponseImpl<T>
    implements CacheAwareResponse<T> {
        private final @Nullable TrackedResponse<?> networkResponse;
        private final @Nullable TrackedResponse<?> cacheResponse;
        private final CacheAwareResponse.CacheStatus cacheStatus;

        CacheAwareResponseImpl(int statusCode, URI uri, HttpClient.Version version, HttpHeaders headers, HttpRequest request, @Nullable T body, @Nullable SSLSession sslSession, @Nullable HttpResponse<T> previousResponse, Instant timeRequestSent, Instant timeResponseReceived, @Nullable TrackedResponse<?> networkResponse, @Nullable TrackedResponse<?> cacheResponse, CacheAwareResponse.CacheStatus cacheStatus) {
            super(statusCode, uri, version, headers, request, body, sslSession, previousResponse, timeRequestSent, timeResponseReceived);
            this.networkResponse = networkResponse;
            this.cacheResponse = cacheResponse;
            this.cacheStatus = cacheStatus;
        }

        @Override
        public Optional<TrackedResponse<?>> networkResponse() {
            return Optional.ofNullable(this.networkResponse);
        }

        @Override
        public Optional<TrackedResponse<?>> cacheResponse() {
            return Optional.ofNullable(this.cacheResponse);
        }

        @Override
        public CacheAwareResponse.CacheStatus cacheStatus() {
            return this.cacheStatus;
        }
    }

    private static class TrackedResponseImpl<T>
    extends HttpResponseImpl<T>
    implements TrackedResponse<T> {
        private final Instant timeRequestSent;
        private final Instant timeResponseReceived;

        TrackedResponseImpl(int statusCode, URI uri, HttpClient.Version version, HttpHeaders headers, HttpRequest request, @Nullable T body, @Nullable SSLSession sslSession, @Nullable HttpResponse<T> previousResponse, Instant timeRequestSent, Instant timeResponseReceived) {
            super(statusCode, uri, version, headers, request, body, sslSession, previousResponse);
            this.timeRequestSent = timeRequestSent;
            this.timeResponseReceived = timeResponseReceived;
        }

        @Override
        public Instant timeRequestSent() {
            return this.timeRequestSent;
        }

        @Override
        public Instant timeResponseReceived() {
            return this.timeResponseReceived;
        }
    }

    private static class HttpResponseImpl<T>
    implements HttpResponse<T> {
        private final int statusCode;
        private final URI uri;
        private final HttpClient.Version version;
        private final HttpHeaders headers;
        private final HttpRequest request;
        private final @Nullable T body;
        private final @Nullable SSLSession sslSession;
        private final @Nullable HttpResponse<T> previousResponse;

        HttpResponseImpl(int statusCode, URI uri, HttpClient.Version version, HttpHeaders headers, HttpRequest request, @Nullable T body, @Nullable SSLSession sslSession, @Nullable HttpResponse<T> previousResponse) {
            this.statusCode = statusCode;
            this.uri = uri;
            this.version = version;
            this.headers = headers;
            this.request = request;
            this.body = body;
            this.sslSession = sslSession;
            this.previousResponse = previousResponse;
        }

        @Override
        public int statusCode() {
            return this.statusCode;
        }

        @Override
        public HttpRequest request() {
            return this.request;
        }

        @Override
        public Optional<HttpResponse<T>> previousResponse() {
            return Optional.ofNullable(this.previousResponse);
        }

        @Override
        public HttpHeaders headers() {
            return this.headers;
        }

        @Override
        public T body() {
            return this.body;
        }

        @Override
        public Optional<SSLSession> sslSession() {
            return Optional.ofNullable(this.sslSession);
        }

        @Override
        public URI uri() {
            return this.uri;
        }

        @Override
        public HttpClient.Version version() {
            return this.version;
        }

        public String toString() {
            return "(" + this.request.method() + " " + this.request.uri() + ") " + this.statusCode;
        }
    }
}

