/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.methanol.internal.cache;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.namelessmc.plugin.lib.methanol.internal.Utils;
import com.namelessmc.plugin.lib.methanol.internal.Validate;
import com.namelessmc.plugin.lib.methanol.internal.cache.Store;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class MemoryStore
implements Store {
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private final long maxSize;
    private final AtomicLong size = new AtomicLong();
    private final Map<String, Entry> entries = new LinkedHashMap<String, Entry>(16, 0.75f, true);

    public MemoryStore(long maxSize) {
        Validate.requireArgument(maxSize > 0L, "non-positive maxSize: %s", maxSize);
        this.maxSize = maxSize;
    }

    @Override
    public long maxSize() {
        return this.maxSize;
    }

    @Override
    public long size() {
        return this.size.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Store.Viewer> view(String key) {
        Objects.requireNonNull(key);
        Map<String, Entry> map = this.entries;
        synchronized (map) {
            return Optional.ofNullable(this.entries.get(key)).map(Entry::view);
        }
    }

    @Override
    public CompletableFuture<Optional<Store.Viewer>> view(String key, Executor executor) {
        return CompletableFuture.completedFuture(this.view(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Store.Editor> edit(String key) {
        Objects.requireNonNull(key);
        Map<String, Entry> map = this.entries;
        synchronized (map) {
            return Optional.ofNullable(this.entries.computeIfAbsent(key, x$0 -> new Entry((String)x$0)).edit(-1));
        }
    }

    @Override
    public CompletableFuture<Optional<Store.Editor>> edit(String key, Executor executor) {
        return CompletableFuture.completedFuture(this.edit(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Store.Viewer> iterator() {
        Map<String, Entry> map = this.entries;
        synchronized (map) {
            return new ViewerIterator(Set.copyOf(this.entries.keySet()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(String key) {
        Objects.requireNonNull(key);
        Map<String, Entry> map = this.entries;
        synchronized (map) {
            Entry entry = this.entries.get(key);
            if (entry != null) {
                this.evict(entry);
                this.entries.remove(key);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<String, Entry> map = this.entries;
        synchronized (map) {
            Iterator<Entry> iter = this.entries.values().iterator();
            while (iter.hasNext()) {
                this.evict(iter.next());
                iter.remove();
            }
        }
    }

    @Override
    public void dispose() {
        this.clear();
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    public String toString() {
        return Utils.toStringIdentityPrefix(this) + "[maxSize=" + this.maxSize + ", size=" + this.size + "]";
    }

    private long evict(Entry entry) {
        assert (Thread.holdsLock(this.entries));
        entry.markEvicted();
        MemoryViewer viewer = entry.view();
        return viewer != null ? this.size.addAndGet(-viewer.entrySize()) : this.size.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evictExcessiveEntries() {
        Map<String, Entry> map = this.entries;
        synchronized (map) {
            long currentSize = this.size.get();
            Iterator<Entry> iter = this.entries.values().iterator();
            while (currentSize > this.maxSize && iter.hasNext()) {
                currentSize = this.evict(iter.next());
                iter.remove();
            }
        }
    }

    private static final class MemoryEditor
    implements Store.Editor,
    Store.EntryWriter {
        private final Entry entry;
        private final Lock lock = new ReentrantLock();
        private final MemoryBuffer data = new MemoryBuffer();
        @GuardedBy(value="lock")
        private boolean isDataWritten;

        MemoryEditor(Entry entry) {
            this.entry = entry;
        }

        @Override
        public String key() {
            return this.entry.key;
        }

        @Override
        public Store.EntryWriter writer() {
            return this;
        }

        @Override
        public int write(ByteBuffer src) {
            Objects.requireNonNull(src);
            this.lock.lock();
            try {
                this.isDataWritten = true;
                int n = this.data.write(src);
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public CompletableFuture<Integer> write(ByteBuffer src, Executor ignored) {
            return CompletableFuture.completedFuture(this.write(src));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long write(List<ByteBuffer> srcs) {
            Objects.requireNonNull(srcs);
            this.lock.lock();
            try {
                this.isDataWritten = true;
                long l = this.data.write(srcs);
                return l;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public CompletableFuture<Long> write(List<ByteBuffer> srcs, Executor executor) {
            return CompletableFuture.completedFuture(this.write(srcs));
        }

        @Override
        public void commit(ByteBuffer metadata) {
            this.entry.commit(this, metadata, this.dataIfWritten());
        }

        @Override
        public CompletableFuture<Void> commit(ByteBuffer metadata, Executor executor) {
            this.entry.commit(this, metadata, this.dataIfWritten());
            return CompletableFuture.completedFuture(null);
        }

        private @Nullable ByteBuffer dataIfWritten() {
            this.lock.lock();
            try {
                ByteBuffer byteBuffer = this.isDataWritten ? ByteBuffer.wrap(this.data.toByteArray()) : null;
                return byteBuffer;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void close() {
            this.entry.commit(this, null, null);
        }

        private static final class MemoryBuffer
        extends ByteArrayOutputStream {
            MemoryBuffer() {
            }

            int write(ByteBuffer src) {
                int limit;
                int remaining;
                int position = src.position();
                int n = remaining = position <= (limit = src.limit()) ? limit - position : 0;
                if (remaining <= this.buf.length - this.count) {
                    src.get(this.buf, this.count, remaining);
                    this.count += remaining;
                } else {
                    byte[] srcCopy = new byte[remaining];
                    src.get(srcCopy);
                    super.write(srcCopy, 0, srcCopy.length);
                }
                return remaining;
            }

            int write(List<ByteBuffer> srcs) {
                int totalRemaining = Math.toIntExact(Utils.remaining(srcs));
                if (totalRemaining <= this.buf.length - this.count) {
                    for (ByteBuffer src : srcs) {
                        int remaining = src.remaining();
                        src.get(this.buf, this.count, remaining);
                        this.count += remaining;
                    }
                } else {
                    int i;
                    int size = srcs.size();
                    for (i = 0; i < size && totalRemaining > this.buf.length - this.count; totalRemaining -= this.write(srcs.get(i)), ++i) {
                    }
                    while (i < size) {
                        ByteBuffer src = srcs.get(i);
                        int remaining = src.remaining();
                        src.get(this.buf, this.count, remaining);
                        this.count += remaining;
                        ++i;
                    }
                }
                return totalRemaining;
            }
        }
    }

    private final class MemoryViewer
    implements Store.Viewer {
        final Entry entry;
        private final int entryVersion;
        private final ByteBuffer data;
        private final ByteBuffer metadata;

        MemoryViewer(Entry entry, int entryVersion, ByteBuffer metadata, ByteBuffer data) {
            this.entry = entry;
            this.entryVersion = entryVersion;
            this.data = data;
            this.metadata = metadata;
        }

        @Override
        public String key() {
            return this.entry.key;
        }

        @Override
        public ByteBuffer metadata() {
            return this.metadata.duplicate();
        }

        @Override
        public Store.EntryReader newReader() {
            return new Store.EntryReader(){
                private final ByteBuffer data;
                {
                    this.data = MemoryViewer.this.data.duplicate();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public int read(ByteBuffer dst) {
                    Objects.requireNonNull(dst);
                    ByteBuffer byteBuffer = this.data;
                    synchronized (byteBuffer) {
                        return this.data.hasRemaining() ? Utils.copyRemaining(this.data, dst) : -1;
                    }
                }

                @Override
                public CompletableFuture<Integer> read(ByteBuffer dst, Executor ignored) {
                    return CompletableFuture.completedFuture(this.read(dst));
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public long read(List<ByteBuffer> dsts) {
                    Objects.requireNonNull(dsts);
                    ByteBuffer byteBuffer = this.data;
                    synchronized (byteBuffer) {
                        ByteBuffer dst;
                        int read;
                        if (!this.data.hasRemaining()) {
                            return -1L;
                        }
                        int totalRead = 0;
                        Iterator<ByteBuffer> iterator = dsts.iterator();
                        while (iterator.hasNext() && (read = Utils.copyRemaining(this.data, dst = iterator.next())) != 0) {
                            totalRead += read;
                        }
                        return totalRead;
                    }
                }

                @Override
                public CompletableFuture<Long> read(List<ByteBuffer> dsts, Executor ignored) {
                    return CompletableFuture.completedFuture(this.read(dsts));
                }
            };
        }

        @Override
        public long dataSize() {
            return this.data.remaining();
        }

        @Override
        public long entrySize() {
            return (long)this.metadata.remaining() + (long)this.data.remaining();
        }

        @Override
        public Optional<Store.Editor> edit() {
            return Optional.ofNullable(this.entry.edit(this.entryVersion));
        }

        @Override
        public CompletableFuture<Optional<Store.Editor>> edit(Executor executor) {
            return CompletableFuture.completedFuture(this.edit());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeEntry() {
            Map<String, Entry> map = MemoryStore.this.entries;
            synchronized (map) {
                if (this.entry.versionEquals(this.entryVersion) && MemoryStore.this.entries.remove(this.entry.key, this.entry)) {
                    MemoryStore.this.evict(this.entry);
                    return true;
                }
            }
            return false;
        }

        @Override
        public void close() {
        }
    }

    private final class Entry {
        private static final int ANY_VERSION = -1;
        private final Lock lock = new ReentrantLock();
        final String key;
        private ByteBuffer metadata = EMPTY_BUFFER;
        private ByteBuffer data = EMPTY_BUFFER;
        private @Nullable MemoryEditor currentEditor;
        private boolean evicted;
        private int version;

        Entry(String key) {
            this.key = key;
        }

        @Nullable MemoryViewer view() {
            this.lock.lock();
            try {
                MemoryViewer memoryViewer = this.version > 0 ? new MemoryViewer(this, this.version, this.metadata, this.data) : null;
                return memoryViewer;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable MemoryEditor edit(int targetVersion) {
            this.lock.lock();
            try {
                MemoryEditor editor;
                if (this.currentEditor != null || targetVersion != -1 && targetVersion != this.version || this.evicted) {
                    MemoryEditor memoryEditor = null;
                    return memoryEditor;
                }
                this.currentEditor = editor = new MemoryEditor(this);
                MemoryEditor memoryEditor = editor;
                return memoryEditor;
            }
            finally {
                this.lock.unlock();
            }
        }

        void markEvicted() {
            this.lock.lock();
            try {
                this.evicted = true;
            }
            finally {
                this.lock.unlock();
            }
        }

        boolean versionEquals(int targetVersion) {
            this.lock.lock();
            try {
                boolean bl = this.version == targetVersion;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void commit(MemoryEditor editor, @Nullable ByteBuffer newMetadata, @Nullable ByteBuffer newData) {
            long entrySizeDifference;
            boolean evictAfterDiscardedFirstEdit = false;
            this.lock.lock();
            try {
                if (this.currentEditor == null) {
                    return;
                }
                assert (this.currentEditor == editor);
                this.currentEditor = null;
                if (newMetadata == null && newData == null || this.evicted) {
                    evictAfterDiscardedFirstEdit = this.version == 0 && !this.evicted;
                    return;
                }
                long oldEntrySize = (long)this.metadata.remaining() + (long)this.data.remaining();
                if (newMetadata != null) {
                    this.metadata = newMetadata.asReadOnlyBuffer();
                }
                if (newData != null) {
                    this.data = newData.asReadOnlyBuffer();
                }
                entrySizeDifference = (long)this.metadata.remaining() + (long)this.data.remaining() - oldEntrySize;
                ++this.version;
            }
            finally {
                this.lock.unlock();
                if (evictAfterDiscardedFirstEdit) {
                    Map<String, Entry> map = MemoryStore.this.entries;
                    synchronized (map) {
                        this.lock.lock();
                        try {
                            if (this.version == 0) {
                                MemoryStore.this.entries.remove(this.key, this);
                            }
                        }
                        finally {
                            this.lock.unlock();
                        }
                    }
                }
            }
            if (MemoryStore.this.size.addAndGet(entrySizeDifference) > MemoryStore.this.maxSize) {
                MemoryStore.this.evictExcessiveEntries();
            }
        }
    }

    private final class ViewerIterator
    implements Iterator<Store.Viewer> {
        private final Iterator<String> keysSnapshotIterator;
        private @Nullable MemoryViewer nextViewer;
        private @Nullable MemoryViewer currentViewer;

        ViewerIterator(Set<String> keysSnapshot) {
            this.keysSnapshotIterator = keysSnapshot.iterator();
        }

        @Override
        @EnsuresNonNullIf(expression={"nextViewer"}, result=true)
        public boolean hasNext() {
            return this.nextViewer != null || this.findNext();
        }

        @Override
        public Store.Viewer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            MemoryViewer viewer = Validate.castNonNull(this.nextViewer);
            this.nextViewer = null;
            this.currentViewer = viewer;
            return viewer;
        }

        @Override
        public void remove() {
            MemoryViewer viewer = this.currentViewer;
            Validate.requireState(viewer != null, "next() must be called before remove()");
            this.currentViewer = null;
            Validate.castNonNull(viewer).removeEntry();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @EnsuresNonNullIf(expression={"nextViewer"}, result=true)
        private boolean findNext() {
            assert (this.nextViewer == null);
            Map<String, Entry> map = MemoryStore.this.entries;
            synchronized (map) {
                while (this.keysSnapshotIterator.hasNext()) {
                    Entry entry = MemoryStore.this.entries.get(this.keysSnapshotIterator.next());
                    MemoryViewer viewer = entry != null ? entry.view() : null;
                    if (viewer == null) continue;
                    this.nextViewer = viewer;
                    return true;
                }
            }
            return false;
        }
    }
}

