/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.methanol.internal.concurrent;

import com.namelessmc.plugin.lib.methanol.internal.Validate;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class Lazy<T>
implements Supplier<T> {
    private final ReentrantLock lock = new ReentrantLock();
    private final Supplier<? extends T> factory;
    private volatile @MonotonicNonNull T lazyValue;

    private Lazy(Supplier<? extends T> factory) {
        this.factory = Objects.requireNonNull(factory);
    }

    @Override
    public T get() {
        T value = this.lazyValue;
        if (value == null) {
            Validate.requireState(!this.lock.isHeldByCurrentThread(), "Recursive initialization of a lazy value");
            this.lock.lock();
            try {
                value = this.lazyValue;
                if (value == null) {
                    this.lazyValue = value = Objects.requireNonNull(this.factory.get());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return value;
    }

    public static <T> Lazy<T> of(Supplier<T> factory) {
        return new Lazy<T>(factory);
    }
}

