/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.methanol.internal.decoder;

import com.namelessmc.plugin.lib.methanol.decoder.AsyncDecoder;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;

class InflaterUtils {
    private InflaterUtils() {
    }

    static void inflateSource(Inflater inflater, AsyncDecoder.ByteSource source, AsyncDecoder.ByteSink sink) throws ZipException {
        while (source.hasRemaining() && !inflater.finished()) {
            InflaterUtils.inflateBlock(inflater, source.currentSource(), sink.currentSink());
        }
    }

    static void inflateSourceWithChecksum(Inflater inflater, AsyncDecoder.ByteSource source, AsyncDecoder.ByteSink sink, CRC32 checksum) throws ZipException {
        while (source.hasRemaining() && !inflater.finished()) {
            InflaterUtils.inflateBlockWithChecksum(inflater, source.currentSource(), sink.currentSink(), checksum);
        }
    }

    private static void inflateBlock(Inflater inflater, ByteBuffer in, ByteBuffer out) throws ZipException {
        if (inflater.needsInput()) {
            inflater.setInput(in);
        } else if (inflater.needsDictionary()) {
            throw new ZipException("missing preset dictionary");
        }
        try {
            inflater.inflate(out);
        }
        catch (DataFormatException e) {
            throw new ZipException(Objects.requireNonNullElse(e.getMessage(), "wrong deflate format"));
        }
    }

    private static void inflateBlockWithChecksum(Inflater inflater, ByteBuffer in, ByteBuffer out, CRC32 checksum) throws ZipException {
        out.mark();
        InflaterUtils.inflateBlock(inflater, in, out);
        int originalLimit = out.limit();
        int writtenLimit = out.position();
        out.reset();
        checksum.update(out.limit(writtenLimit));
        out.limit(originalLimit);
    }
}

