/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.methanol.internal.flow;

import com.namelessmc.plugin.lib.methanol.internal.flow.AbstractPollableSubscription;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AbstractQueueSubscription<T>
extends AbstractPollableSubscription<T> {
    private static final Object DEFAULT_SENTINEL = new Object();
    private final Queue<T> queue;
    private final T sentinel;
    private boolean complete;

    protected AbstractQueueSubscription(Flow.Subscriber<? super T> downstream, Executor executor) {
        this(downstream, executor, new ConcurrentLinkedQueue());
    }

    protected AbstractQueueSubscription(Flow.Subscriber<? super T> downstream, Executor executor, Queue<T> queue) {
        this(downstream, executor, queue, DEFAULT_SENTINEL);
    }

    protected AbstractQueueSubscription(Flow.Subscriber<? super T> downstream, Executor executor, Queue<T> queue, T sentinel) {
        super(downstream, executor);
        this.queue = Objects.requireNonNull(queue);
        this.sentinel = Objects.requireNonNull(sentinel);
    }

    protected void submit(T item) {
        this.queue.add(item);
        this.fireOrKeepAliveOnNext();
    }

    protected void submitSilently(T item) {
        this.queue.add(item);
    }

    protected void submitAndComplete(T lastItem) {
        this.queue.add(lastItem);
        this.queue.add(this.sentinel);
        this.fireOrKeepAlive();
    }

    @Override
    protected @Nullable T poll() {
        T next = this.queue.poll();
        this.complete |= next == this.sentinel;
        return this.complete ? null : (T)next;
    }

    @Override
    protected boolean isComplete() {
        return this.complete || (this.complete = this.queue.peek() == this.sentinel);
    }

    @Override
    protected void abort(boolean flowInterrupted) {
        this.queue.clear();
    }

    protected void complete() {
        this.queue.add(this.sentinel);
        this.fireOrKeepAlive();
    }
}

