/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.nameless-api;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.namelessmc.plugin.lib.nameless-api.Announcement;
import com.namelessmc.plugin.lib.nameless-api.CustomProfileField;
import com.namelessmc.plugin.lib.nameless-api.CustomProfileFieldType;
import com.namelessmc.plugin.lib.nameless-api.CustomProfileFieldValue;
import com.namelessmc.plugin.lib.nameless-api.Group;
import com.namelessmc.plugin.lib.nameless-api.LanguageEntity;
import com.namelessmc.plugin.lib.nameless-api.NamelessAPI;
import com.namelessmc.plugin.lib.nameless-api.Notification;
import com.namelessmc.plugin.lib.nameless-api.RequestHandler;
import com.namelessmc.plugin.lib.nameless-api.VerificationInfo;
import com.namelessmc.plugin.lib.nameless-api.exception.ApiError;
import com.namelessmc.plugin.lib.nameless-api.exception.ApiException;
import com.namelessmc.plugin.lib.nameless-api.exception.NamelessException;
import com.namelessmc.plugin.lib.nameless-api.integrations.DetailedDiscordIntegrationData;
import com.namelessmc.plugin.lib.nameless-api.integrations.DetailedIntegrationData;
import com.namelessmc.plugin.lib.nameless-api.integrations.DetailedMinecraftIntegrationData;
import com.namelessmc.plugin.lib.nameless-api.integrations.IDiscordIntegrationData;
import com.namelessmc.plugin.lib.nameless-api.integrations.IMinecraftIntegrationData;
import com.namelessmc.plugin.lib.nameless-api.integrations.IntegrationData;
import com.namelessmc.plugin.lib.nameless-api.modules.discord.DiscordUser;
import com.namelessmc.plugin.lib.nameless-api.modules.store.StoreUser;
import com.namelessmc.plugin.lib.nameless-api.modules.suggestions.SuggestionsUser;
import com.namelessmc.plugin.lib.nameless-api.util.GsonHelper;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.index.qual.Positive;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nonempty.qual.UnknownNonEmpty;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;

public final class NamelessUser
implements LanguageEntity {
    private final @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessAPI api;
    private final @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat RequestHandler requests;
    private @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat int id;
    private @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String userTransformer;
    private @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat JsonObject _cachedUserInfo;
    private @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Map<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat DetailedIntegrationData> _cachedIntegrationData;

    NamelessUser(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessAPI api, @Positive @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat int id) {
        this.api = api;
        this.requests = api.requests();
        this.id = id;
        this.userTransformer = "id:" + id;
    }

    NamelessUser(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessAPI api, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String userTransformer) {
        this.api = api;
        this.requests = api.requests();
        this.id = -1;
        this.userTransformer = URLEncoder.encode(userTransformer, StandardCharsets.UTF_8);
    }

    NamelessUser(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessAPI api, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat JsonObject userInfo) {
        this(api, userInfo.get("id").getAsInt());
        this._cachedUserInfo = userInfo;
    }

    @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat JsonObject userInfo() throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        if (this._cachedUserInfo != null) {
            return this._cachedUserInfo;
        }
        JsonObject response = this.requests.get("users/" + this.userTransformer, new Object[0]);
        if (!response.get("exists").getAsBoolean()) {
            throw new IllegalStateException("User was returned by the API without an error code so it should exist");
        }
        this._cachedUserInfo = response;
        if (this.id < 0) {
            this.id = response.get("id").getAsInt();
            this.userTransformer = "id:" + this.id;
        }
        return response;
    }

    public @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessAPI api() {
        return this.api;
    }

    public void invalidateCache() {
        this._cachedUserInfo = null;
        this._cachedIntegrationData = null;
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String userTransformer() {
        return this.userTransformer;
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat int id() throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        if (this.id == -1) {
            this.id = this.userInfo().get("id").getAsInt();
        }
        return this.id;
    }

    public @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String username() throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        return this.userInfo().get("username").getAsString();
    }

    public void updateUsername(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String username) throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        JsonObject post = new JsonObject();
        post.addProperty("username", username);
        this.requests.post("users/" + this.userTransformer + "/update-username", post);
    }

    public @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String displayName() throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        return this.userInfo().get("displayname").getAsString();
    }

    public @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Date registeredDate() throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        return new Date(this.userInfo().get("registered_timestamp").getAsLong() * 1000L);
    }

    public @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Date lastOnline() throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        return new Date(this.userInfo().get("last_online_timestamp").getAsLong() * 1000L);
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat boolean isBanned() throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        return this.userInfo().get("banned").getAsBoolean();
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat boolean isVerified() throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        return this.userInfo().get("validated").getAsBoolean();
    }

    @Override
    public @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String rawLocale() throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        return this.userInfo().get("locale").getAsString();
    }

    public @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat VerificationInfo verificationInfo() throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        boolean verified = this.isVerified();
        JsonObject verification = this.userInfo().getAsJsonObject("verification");
        return new VerificationInfo(verified, verification);
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat boolean isStaff() throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        if (!this.userInfo().has("groups")) {
            throw new IllegalStateException("Groups array missing: https://github.com/NamelessMC/Nameless/issues/3052");
        }
        JsonArray groups = this.userInfo().getAsJsonArray("groups");
        for (JsonElement elem : groups) {
            JsonObject group = elem.getAsJsonObject();
            if (!group.has("staff") || !group.get("staff").getAsBoolean()) continue;
            return true;
        }
        return false;
    }

    public @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat List<@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Group> groups() throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        if (!this.userInfo().has("groups")) {
            throw new IllegalStateException("Groups array missing: https://github.com/NamelessMC/Nameless/issues/3052");
        }
        return GsonHelper.toObjectList(this.userInfo().getAsJsonArray("groups"), Group::new);
    }

    public @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Group primaryGroup() throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        if (!this.userInfo().has("groups")) {
            throw new IllegalStateException("Groups array missing: https://github.com/NamelessMC/Nameless/issues/3052");
        }
        JsonArray groups = this.userInfo().getAsJsonArray("groups");
        if (groups.size() > 0) {
            return new Group(groups.get(0).getAsJsonObject());
        }
        return null;
    }

    public void addGroups(Group ... groups) throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        JsonObject post = new JsonObject();
        post.add("groups", (JsonElement)this.groupsToJsonArray(groups));
        this.requests.post("users/" + this.userTransformer + "/groups/add", post);
        this.invalidateCache();
    }

    public void removeGroups(Group ... groups) throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        JsonObject post = new JsonObject();
        post.add("groups", (JsonElement)this.groupsToJsonArray(groups));
        this.requests.post("users/" + this.userTransformer + "/groups/remove", post);
        this.invalidateCache();
    }

    public void updateMinecraftGroups(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat [] addedGroups, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat [] removedGroups) throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        JsonObject post = new JsonObject();
        post.add("add", this.requests.gson().toJsonTree((Object)addedGroups));
        post.add("remove", this.requests.gson().toJsonTree((Object)removedGroups));
        this.requests.post("minecraft/" + this.userTransformer + "/sync-groups", post);
    }

    private @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat JsonArray groupsToJsonArray(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Group @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat [] groups) {
        JsonArray array = new JsonArray();
        for (Group group : groups) {
            array.add((Number)group.getId());
        }
        return array;
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat int notificationCount() throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        JsonObject response = this.requests.get("users/" + this.userTransformer + "/notifications", new Object[0]);
        return response.getAsJsonArray("notifications").size();
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat List<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Notification> notifications() throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        JsonObject response = this.requests.get("users/" + this.userTransformer + "/notifications", new Object[0]);
        return GsonHelper.toObjectList(response.getAsJsonArray("notifications"), Notification::new);
    }

    public void createReport(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessUser user, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String reason) throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        Objects.requireNonNull(user, "User to report is null");
        Objects.requireNonNull(reason, "Report reason is null");
        Preconditions.checkArgument((reason.length() < 255 ? 1 : 0) != 0, (String)"Report reason too long, it's %s characters but must be less than 255", (int)reason.length());
        JsonObject post = new JsonObject();
        post.addProperty("reporter", (Number)this.id());
        post.addProperty("reported", (Number)user.id());
        post.addProperty("content", reason);
        try {
            this.requests.post("reports/create", post);
        }
        catch (ApiException e) {
            if (e.apiError() == ApiError.CORE_REPORT_CONTENT_TOO_LONG) {
                throw new IllegalStateException("Website said report reason is too long, but we have client-side validation for this so it should be impossible");
            }
            throw e;
        }
    }

    public void createReport(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat UUID reportedUuid, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String reportedName, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String reason) throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        this.createReport(reportedUuid, reportedName, reason, 0);
    }

    public void createReport(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat UUID reportedUuid, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String reportedName, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String reason, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat int serverId) throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        Objects.requireNonNull(reportedUuid, "Reported uuid is null");
        Objects.requireNonNull(reportedName, "Reported name is null");
        Objects.requireNonNull(reason, "Report reason is null");
        Preconditions.checkArgument((reason.length() < 255 ? 1 : 0) != 0, (String)"Report reason too long, it's %s characters but must be less than 255", (int)reason.length());
        JsonObject post = new JsonObject();
        post.addProperty("reporter", (Number)this.id());
        post.addProperty("reported_uid", reportedUuid.toString());
        post.addProperty("reported_username", reportedName);
        post.addProperty("content", reason);
        if (serverId != 0) {
            post.addProperty("server_id", (Number)serverId);
        }
        try {
            this.requests.post("reports/create", post);
        }
        catch (ApiException e) {
            if (e.apiError() == ApiError.CORE_REPORT_CONTENT_TOO_LONG) {
                throw new IllegalStateException("Website said report reason is too long, but we have client-side validation for this so it should be impossible");
            }
            throw e;
        }
    }

    public @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat List<@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Announcement> announcements() throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        JsonObject response = this.requests.get("users/" + this.userTransformer + "/announcements", new Object[0]);
        return NamelessAPI.announcements(response);
    }

    public void banUser() throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        this.requests.post("users/" + this.userTransformer + "/ban", new JsonObject());
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Collection<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat CustomProfileFieldValue> profileFields() throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        if (!this.userInfo().has("profile_fields")) {
            return Collections.emptyList();
        }
        JsonObject fieldsJson = this.userInfo().getAsJsonObject("profile_fields");
        ArrayList<CustomProfileFieldValue> fieldValues = new ArrayList<CustomProfileFieldValue>(fieldsJson.size());
        for (Map.Entry e : fieldsJson.entrySet()) {
            int id = Integer.parseInt((String)e.getKey());
            JsonObject values = ((JsonElement)e.getValue()).getAsJsonObject();
            fieldValues.add(new CustomProfileFieldValue(new CustomProfileField(id, values.get("name").getAsString(), CustomProfileFieldType.fromNamelessTypeInt(values.get("type").getAsInt()), values.get("public").getAsBoolean(), values.get("required").getAsBoolean(), values.get("description").getAsString()), GsonHelper.getNullableString(values, "value")));
        }
        return fieldValues;
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Map<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat DetailedIntegrationData> integrations() throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        if (this._cachedIntegrationData != null) {
            return this._cachedIntegrationData;
        }
        JsonObject userInfo = this.userInfo();
        JsonArray integrationsJsonArray = userInfo.getAsJsonArray("integrations");
        HashMap<String, DetailedIntegrationData> integrationDataMap = new HashMap<String, DetailedIntegrationData>(integrationsJsonArray.size());
        for (JsonElement integrationElement : integrationsJsonArray) {
            DetailedIntegrationData integrationData;
            String integrationName;
            JsonObject integrationJson = integrationElement.getAsJsonObject();
            switch (integrationName = integrationJson.get("integration").getAsString()) {
                case "Minecraft": {
                    integrationData = new DetailedMinecraftIntegrationData(integrationJson);
                    break;
                }
                case "Discord": {
                    integrationData = new DetailedDiscordIntegrationData(integrationJson);
                    break;
                }
                default: {
                    integrationData = new DetailedIntegrationData(integrationJson);
                }
            }
            integrationDataMap.put(integrationName, integrationData);
        }
        this._cachedIntegrationData = integrationDataMap;
        return integrationDataMap;
    }

    public @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat UUID minecraftUuid() throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        IntegrationData integration = this.integrations().get("Minecraft");
        return integration == null ? null : ((IMinecraftIntegrationData)((Object)integration)).uuid();
    }

    public @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String minecraftUsername() throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        IntegrationData integration = this.integrations().get("Minecraft");
        return integration == null ? null : integration.username();
    }

    public @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Long discordId() throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        IntegrationData integration = this.integrations().get("Discord");
        return integration == null ? null : Long.valueOf(((IDiscordIntegrationData)((Object)integration)).idLong());
    }

    public @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String discordUsername() throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        IntegrationData integration = this.integrations().get("Discord");
        return integration == null ? null : integration.username();
    }

    public void verify(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String verificationCode) throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        JsonObject body = new JsonObject();
        body.addProperty("code", verificationCode);
        this.requests.post("users/" + this.userTransformer + "/verify", body);
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat DiscordUser discord() throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        return new DiscordUser(this);
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat StoreUser store() throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        return new StoreUser(this);
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat SuggestionsUser suggestions() throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        return new SuggestionsUser(this);
    }
}

