/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.nameless-api.exception;

import com.namelessmc.plugin.lib.nameless-api.exception.NamelessException;
import com.namelessmc.plugin.lib.nameless-api.modules.NamelessModule;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nonempty.qual.UnknownNonEmpty;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;

public class MissingModuleException
extends NamelessException {
    private static final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat long serialVersionUID = 1L;

    public MissingModuleException(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessModule module) {
        super(MissingModuleException.getExceptionMessage(module));
    }

    private static @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String getExceptionMessage(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessModule module) {
        StringBuilder builder = new StringBuilder("Required module not installed: ");
        builder.append(module.name());
        builder.append(".");
        if (module.isIncluded()) {
            builder.append(" This module is an official module, included with NamelessMC. Please enable it.");
        } else {
            builder.append(" This module is a third-party module.");
            if (module.downloadLink() != null) {
                builder.append(" It can be downloaded here: ");
                builder.append(module.downloadLink());
            } else {
                builder.append(" It can be downloaded externally.");
            }
        }
        return builder.toString();
    }
}

