/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.velocity;

import com.google.inject.Inject;
import com.namelessmc.plugin.common.ConfigurationHandler;
import com.namelessmc.plugin.common.NamelessPlugin;
import com.namelessmc.plugin.velocity.Slf4jLogger;
import com.namelessmc.plugin.velocity.VelocityCommandProxy;
import com.namelessmc.plugin.velocity.VelocityDataSender;
import com.namelessmc.plugin.velocity.VelocityEventProxy;
import com.namelessmc.plugin.velocity.VelocityScheduler;
import com.namelessmc.plugin.velocity.audiences.VelocityAudienceProvider;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyReloadEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import java.nio.file.Path;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nonempty.qual.UnknownNonEmpty;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.slf4j.Logger;

@Plugin(id="namelessmc", name="NamelessMC", version="3.4.2", url="https://plugin.namelessmc.com/", description="Integration with NamelessMC websites", authors={"Derkades"})
public class VelocityNamelessPlugin {
    private final  @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Metrics.Factory metricsFactory;
    private final @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat ProxyServer server;
    private final @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin;

    @Inject
    public VelocityNamelessPlugin(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat ProxyServer server, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Logger logger, @DataDirectory @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Path dataDirectory,  @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Metrics.Factory metricsFactory) {
        this.server = server;
        this.metricsFactory = metricsFactory;
        this.plugin = new NamelessPlugin(dataDirectory, new VelocityScheduler(this, server.getScheduler()), config -> new Slf4jLogger((ConfigurationHandler)config, logger), Path.of("logs", "latest.log"), "velocity", server.getVersion().getVersion());
        this.plugin.setAudienceProvider(new VelocityAudienceProvider(this.plugin.config(), server));
        this.plugin.registerReloadable(new VelocityDataSender(this.plugin, this.server));
    }

    @Subscribe
    public void onProxyInitialization(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat ProxyInitializeEvent event) {
        this.plugin.load();
        this.server.getEventManager().register((Object)this, (Object)new VelocityEventProxy(this.plugin));
        this.metricsFactory.make(this, 14863);
        VelocityCommandProxy.registerCommands(this, this.plugin, this.server);
    }

    @Subscribe
    public void onReload(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat ProxyReloadEvent event) {
        this.plugin.unload();
        this.plugin.load();
    }
}

