/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.common;

import com.namelessmc.plugin.common.ConfigurationHandler;
import com.namelessmc.plugin.common.LanguageHandler;
import com.namelessmc.plugin.common.NamelessPlugin;
import com.namelessmc.plugin.common.Reloadable;
import com.namelessmc.plugin.common.audiences.NamelessPlayer;
import com.namelessmc.plugin.common.command.AbstractScheduledTask;
import com.namelessmc.plugin.lib.adventure.text.Component;
import com.namelessmc.plugin.lib.checker-framework.checker.formatter.qual.UnknownFormat;
import com.namelessmc.plugin.lib.checker-framework.checker.initialization.qual.Initialized;
import com.namelessmc.plugin.lib.checker-framework.checker.nonempty.qual.UnknownNonEmpty;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.NonNull;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.Nullable;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.UnknownKeyFor;
import com.namelessmc.plugin.lib.checker-framework.checker.optional.qual.MaybePresent;
import com.namelessmc.plugin.lib.checker-framework.checker.regex.qual.UnknownRegex;
import com.namelessmc.plugin.lib.checker-framework.common.aliasing.qual.MaybeAliased;
import com.namelessmc.plugin.lib.checker-framework.common.aliasing.qual.MaybeLeaked;
import com.namelessmc.plugin.lib.configurate.CommentedConfigurationNode;
import com.namelessmc.plugin.lib.derkutils.ListUtils;
import com.namelessmc.plugin.lib.nameless-api.Announcement;
import com.namelessmc.plugin.lib.nameless-api.NamelessAPI;
import com.namelessmc.plugin.lib.nameless-api.NamelessUser;
import com.namelessmc.plugin.lib.nameless-api.exception.NamelessException;
import java.time.Duration;
import java.util.List;
import java.util.stream.Collectors;

public class AnnouncementTask
implements Runnable,
Reloadable {
    private final @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin;
    private @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat AbstractScheduledTask task;

    AnnouncementTask(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void unload() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
    }

    @Override
    public void load() {
        CommentedConfigurationNode config = (CommentedConfigurationNode)this.plugin.config().main().node(new Object[]{"announcements"});
        if (((CommentedConfigurationNode)config.node(new Object[]{"enabled"})).getBoolean()) {
            Duration interval = ConfigurationHandler.getDuration(config.node(new Object[]{"interval"}));
            if (interval != null) {
                this.task = this.plugin.scheduler().runTimer(this, interval);
            } else {
                this.plugin.logger().warning("Invalid announcements interval");
            }
        }
    }

    @Override
    public void run() {
        CommentedConfigurationNode config = (CommentedConfigurationNode)this.plugin.config().main().node(new Object[]{"announcements"});
        NamelessAPI api = this.plugin.apiProvider().api();
        if (api == null) {
            return;
        }
        @Nullable String filterDisplay = ((CommentedConfigurationNode)config.node(new Object[]{"display"})).getString();
        Duration delay = Duration.ZERO;
        for (NamelessPlayer player : this.plugin.audiences().onlinePlayers()) {
            this.plugin.scheduler().runDelayed(() -> this.plugin.scheduler().runAsync(() -> {
                List<Announcement> announcements;
                try {
                    NamelessUser user = api.userByMinecraftUuid(player.uuid());
                    announcements = user != null ? user.announcements() : api.announcements();
                }
                catch (NamelessException e) {
                    this.plugin.logger().logException(e);
                    return;
                }
                if (filterDisplay != null) {
                    announcements = announcements.stream().filter(a -> a.displayedPages().contains(filterDisplay)).collect(Collectors.toList());
                }
                if (!announcements.isEmpty()) {
                    Announcement announcement = ListUtils.choice(announcements);
                    String announcementMessage = announcement.message();
                    this.plugin.scheduler().runSync(() -> {
                        NamelessPlayer player2 = this.plugin.audiences().player(player.uuid());
                        if (player2 == null) {
                            return;
                        }
                        Component message = this.plugin.language().get(LanguageHandler.Term.WEBSITE_ANNOUNCEMENT, "message", announcementMessage);
                        player2.sendMessage(message);
                    });
                }
            }), delay);
            delay = delay.plusMillis(250L);
        }
    }
}

