/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.common;

import com.namelessmc.plugin.common.AbstractPermissions;
import com.namelessmc.plugin.common.NamelessPlugin;
import com.namelessmc.plugin.common.Reloadable;
import com.namelessmc.plugin.common.command.AbstractScheduledTask;
import com.namelessmc.plugin.common.logger.AbstractLogger;
import com.namelessmc.plugin.lib.checker-framework.checker.formatter.qual.UnknownFormat;
import com.namelessmc.plugin.lib.checker-framework.checker.initialization.qual.Initialized;
import com.namelessmc.plugin.lib.checker-framework.checker.nonempty.qual.UnknownNonEmpty;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.NonNull;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.Nullable;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.UnknownKeyFor;
import com.namelessmc.plugin.lib.checker-framework.checker.optional.qual.MaybePresent;
import com.namelessmc.plugin.lib.checker-framework.checker.regex.qual.UnknownRegex;
import com.namelessmc.plugin.lib.checker-framework.common.aliasing.qual.MaybeAliased;
import com.namelessmc.plugin.lib.checker-framework.common.aliasing.qual.MaybeLeaked;
import com.namelessmc.plugin.lib.configurate.CommentedConfigurationNode;
import com.namelessmc.plugin.lib.gson.JsonObject;
import com.namelessmc.plugin.lib.methanol.Methanol;
import com.namelessmc.plugin.lib.nameless-api.NamelessAPI;
import com.namelessmc.plugin.lib.nameless-api.Website;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.UUID;

public class Metrics
implements Reloadable {
    private static final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat URI SUBMIT_URI = URI.create("https://metrics.rkslot.nl/submit");
    private static final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String SOURCE = "nameless-plugin";
    private static final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String USER_AGENT = "Nameless-Plugin/3.4.2";
    private static final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Duration SEND_INTERVAL = Duration.ofMinutes(15L);
    private static final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String METRICS_ID = UUID.randomUUID().toString();
    private final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin;
    private final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String platformInternalName;
    private final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String platformVersion;
    private final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Methanol methanol;
    private @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat AbstractScheduledTask task;
    private @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat boolean firstStartup = true;

    public Metrics(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String platformInternalName, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String platformVersion) {
        this.plugin = plugin;
        this.platformInternalName = platformInternalName;
        this.platformVersion = platformVersion;
        this.methanol = Methanol.create();
    }

    private @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat JsonObject metricsJson() {
        AbstractPermissions permissionsAdapter;
        Website website;
        JsonObject json = new JsonObject();
        json.addProperty("source", SOURCE);
        json.addProperty("uuid", METRICS_ID);
        JsonObject fields = new JsonObject();
        fields.addProperty("version", "3.4.2");
        fields.addProperty("platform_internal_name", this.platformInternalName);
        fields.addProperty("platform_version", this.platformVersion);
        fields.addProperty("java_version", Runtime.version().feature());
        fields.addProperty("os_name", System.getProperty("os.name"));
        NamelessAPI api = this.plugin.apiProvider().apiIfCached();
        fields.addProperty("api_working", api != null);
        if (api != null && (website = api.websiteIfCached()) != null) {
            fields.addProperty("website_version", website.rawVersion());
        }
        fields.addProperty("permissions_adapter", (permissionsAdapter = this.plugin.permissions()) != null ? permissionsAdapter.getClass().getSimpleName() : "None");
        CommentedConfigurationNode config = this.plugin.config().main();
        CommentedConfigurationNode modules = this.plugin.config().modules();
        fields.addProperty("api_debug", config.node("api", "debug").getBoolean());
        fields.addProperty("api_offline_uuids", config.node("api", "offline-uuids").getBoolean());
        fields.addProperty("server_data_sender", config.node("server-data-sender", "enabled").getBoolean());
        fields.addProperty("server_data_sender_placeholders", config.node("server-data-sender", "placeholders", "enabled").getBoolean());
        fields.addProperty("group_sync", config.node("group-sync", "enabled").getBoolean());
        fields.addProperty("logging_verbose", config.node("logging", "verbose").getBoolean());
        fields.addProperty("not_registered_join_message", config.node("not-registered-join-message").getBoolean());
        fields.addProperty("join_notifications", config.node("join-notifications").getBoolean());
        fields.addProperty("language", this.plugin.language().getActiveLanguageCode());
        fields.addProperty("announcements", config.node("announcements", "enabled").getBoolean());
        fields.addProperty("register_custom_username", config.node("register-custom-username").getBoolean(true));
        fields.addProperty("sync_ban_to_website", config.node("sync-ban-to-website").getBoolean());
        fields.addProperty("user_sync", config.node("user-sync", "enabeld").getBoolean());
        fields.addProperty("user_sync_whitelist", config.node("user-sync", "whitelist", "enabled").getBoolean());
        fields.addProperty("user_sync_bans", config.node("user-sync", "bans", "enabled").getBoolean());
        fields.addProperty("retrieve_placeholders", config.node("retrieve-placeholders", "enabled").getBoolean());
        fields.addProperty("websend_command_executor", modules.node("websend", "command-executor", "enabled").getBoolean());
        fields.addProperty("websend_send_logs", modules.node("websend", "send-logs", "enabled").getBoolean());
        fields.addProperty("store_command_executor", modules.node("store", "command-executor", "enabled").getBoolean());
        json.add("fields", fields);
        return json;
    }

    public void sendMetrics() {
        String jsonString = this.metricsJson().toString();
        this.plugin.logger().fine(() -> "Sending metrics: " + jsonString);
        this.plugin.scheduler().runAsync(() -> {
            HttpRequest request = HttpRequest.newBuilder(SUBMIT_URI).header("Content-Type", "application/json").header("User-Agent", USER_AGENT).timeout(Duration.ofSeconds(5L)).POST(HttpRequest.BodyPublishers.ofString(jsonString, StandardCharsets.UTF_8)).build();
            try {
                if (this.plugin.logger().isVerbose()) {
                    HttpResponse<String> response = this.methanol.send(request, HttpResponse.BodyHandlers.ofString());
                    if (response.statusCode() != 200) {
                        this.plugin.logger().fine(() -> "Received status code " + response.statusCode() + " with body:\n" + (String)response.body());
                    }
                } else {
                    this.methanol.send(request, HttpResponse.BodyHandlers.discarding());
                }
            }
            catch (Exception e) {
                this.plugin.logger().fine(() -> "Exception while sending metrics: " + AbstractLogger.stackTraceAsString(e));
            }
        });
    }

    @Override
    public void unload() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
    }

    @Override
    public void load() {
        this.task = this.plugin.scheduler().runTimer(this::sendMetrics, SEND_INTERVAL);
        if (this.firstStartup) {
            this.plugin.scheduler().runDelayed(this::sendMetrics, Duration.ofSeconds(30L));
            this.firstStartup = false;
        }
    }
}

