/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.common;

import com.namelessmc.plugin.common.NamelessPlugin;
import com.namelessmc.plugin.common.Reloadable;
import com.namelessmc.plugin.common.event.NamelessPlayerBanEvent;
import com.namelessmc.plugin.lib.checker-framework.checker.formatter.qual.UnknownFormat;
import com.namelessmc.plugin.lib.checker-framework.checker.initialization.qual.Initialized;
import com.namelessmc.plugin.lib.checker-framework.checker.nonempty.qual.UnknownNonEmpty;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.NonNull;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.Nullable;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.UnknownKeyFor;
import com.namelessmc.plugin.lib.checker-framework.checker.optional.qual.MaybePresent;
import com.namelessmc.plugin.lib.checker-framework.checker.regex.qual.UnknownRegex;
import com.namelessmc.plugin.lib.checker-framework.common.aliasing.qual.MaybeAliased;
import com.namelessmc.plugin.lib.checker-framework.common.aliasing.qual.MaybeLeaked;
import com.namelessmc.plugin.lib.configurate.CommentedConfigurationNode;
import com.namelessmc.plugin.lib.event.EventSubscription;
import com.namelessmc.plugin.lib.nameless-api.NamelessAPI;
import com.namelessmc.plugin.lib.nameless-api.NamelessUser;
import com.namelessmc.plugin.lib.nameless-api.exception.NamelessException;
import java.util.UUID;

public class SyncBanToWebsite
implements Reloadable {
    private final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin;
    private @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat EventSubscription subscription;

    SyncBanToWebsite(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void unload() {
        if (this.subscription != null) {
            this.subscription.unsubscribe();
            this.subscription = null;
        }
    }

    @Override
    public void load() {
        if (!((CommentedConfigurationNode)this.plugin.config().main().node(new Object[]{"sync-ban-to-website"})).getBoolean()) {
            return;
        }
        this.plugin.events().subscribe(NamelessPlayerBanEvent.class, event -> {
            UUID uuid = event.uuid();
            this.plugin.scheduler().runAsync(() -> {
                NamelessAPI api = this.plugin.apiProvider().api();
                if (api == null) {
                    this.plugin.logger().warning("Skipped trying to ban user, website connection is not working properly.");
                    return;
                }
                try {
                    NamelessUser user = api.userByMinecraftUuid(uuid);
                    if (user != null) {
                        if (user.isBanned()) {
                            this.plugin.logger().info("User " + user.username() + " is already banned");
                        } else {
                            user.banUser();
                            this.plugin.logger().info("Banned user on website");
                        }
                    }
                }
                catch (NamelessException e) {
                    this.plugin.logger().warning("Failed to ban player on website");
                    this.plugin.logger().logException(e);
                }
            });
        });
    }
}

