/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.common.command;

import com.namelessmc.plugin.common.LanguageHandler;
import com.namelessmc.plugin.common.NamelessPlugin;
import com.namelessmc.plugin.common.Permission;
import com.namelessmc.plugin.common.audiences.NamelessCommandSender;
import com.namelessmc.plugin.common.audiences.NamelessConsole;
import com.namelessmc.plugin.common.audiences.NamelessPlayer;
import com.namelessmc.plugin.common.command.CommonCommand;
import com.namelessmc.plugin.lib.checker-framework.checker.formatter.qual.UnknownFormat;
import com.namelessmc.plugin.lib.checker-framework.checker.initialization.qual.Initialized;
import com.namelessmc.plugin.lib.checker-framework.checker.nonempty.qual.UnknownNonEmpty;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.NonNull;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.UnknownKeyFor;
import com.namelessmc.plugin.lib.checker-framework.checker.optional.qual.MaybePresent;
import com.namelessmc.plugin.lib.checker-framework.checker.regex.qual.UnknownRegex;
import com.namelessmc.plugin.lib.checker-framework.common.aliasing.qual.MaybeAliased;
import com.namelessmc.plugin.lib.checker-framework.common.aliasing.qual.MaybeLeaked;
import com.namelessmc.plugin.lib.nameless-api.NamelessAPI;
import com.namelessmc.plugin.lib.nameless-api.NamelessUser;
import com.namelessmc.plugin.lib.nameless-api.exception.NamelessException;
import java.util.List;
import java.util.stream.Collectors;

public class GetNotificationsCommand
extends CommonCommand {
    public GetNotificationsCommand(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin) {
        super(plugin, "get-notifications", LanguageHandler.Term.COMMAND_NOTIFICATIONS_USAGE, LanguageHandler.Term.COMMAND_NOTIFICATIONS_DESCRIPTION, Permission.COMMAND_GET_NOTIFICATIONS);
    }

    @Override
    public void execute(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessCommandSender sender, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat [] args) {
        if (args.length != 0) {
            sender.sendMessage(this.usage());
            return;
        }
        if (sender instanceof NamelessConsole) {
            sender.sendMessage(this.language().get(LanguageHandler.Term.COMMAND_NOT_A_PLAYER));
            return;
        }
        this.scheduler().runAsync(() -> {
            NamelessAPI api = this.apiProvider().api();
            if (api == null) {
                sender.sendMessage(this.language().get(LanguageHandler.Term.ERROR_WEBSITE_CONNECTION));
                return;
            }
            try {
                NamelessUser user = api.userByMinecraftUuid(((NamelessPlayer)sender).uuid());
                if (user == null) {
                    sender.sendMessage(this.language().get(LanguageHandler.Term.PLAYER_SELF_NOT_REGISTERED));
                    return;
                }
                List notifications = user.notifications().stream().sorted((n1, n2) -> n2.type().ordinal() - n1.type().ordinal()).collect(Collectors.toUnmodifiableList());
                if (notifications.size() == 0) {
                    sender.sendMessage(this.language().get(LanguageHandler.Term.COMMAND_NOTIFICATIONS_OUTPUT_NO_NOTIFICATIONS));
                    return;
                }
                this.scheduler().runSync(() -> notifications.forEach(notification -> sender.sendMessage(this.language().get(LanguageHandler.Term.COMMAND_NOTIFICATIONS_OUTPUT_NOTIFICATION, "url", notification.url(), "message", notification.message()))));
            }
            catch (NamelessException e) {
                sender.sendMessage(this.language().get(LanguageHandler.Term.ERROR_WEBSITE_CONNECTION));
                this.logger().logException(e);
            }
        });
    }
}

