/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.common.command;

import com.namelessmc.plugin.common.LanguageHandler;
import com.namelessmc.plugin.common.NamelessPlugin;
import com.namelessmc.plugin.common.Permission;
import com.namelessmc.plugin.common.audiences.NamelessCommandSender;
import com.namelessmc.plugin.common.command.CommonCommand;
import com.namelessmc.plugin.lib.checker-framework.checker.formatter.qual.UnknownFormat;
import com.namelessmc.plugin.lib.checker-framework.checker.initialization.qual.Initialized;
import com.namelessmc.plugin.lib.checker-framework.checker.nonempty.qual.UnknownNonEmpty;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.NonNull;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.UnknownKeyFor;
import com.namelessmc.plugin.lib.checker-framework.checker.optional.qual.MaybePresent;
import com.namelessmc.plugin.lib.checker-framework.checker.regex.qual.UnknownRegex;
import com.namelessmc.plugin.lib.checker-framework.common.aliasing.qual.MaybeAliased;
import com.namelessmc.plugin.lib.checker-framework.common.aliasing.qual.MaybeLeaked;
import com.namelessmc.plugin.lib.nameless-api.NamelessAPI;
import com.namelessmc.plugin.lib.nameless-api.NamelessUser;
import com.namelessmc.plugin.lib.nameless-api.exception.NamelessException;
import java.util.Collections;
import java.util.List;

public class StoreChangeCreditsCommand
extends CommonCommand {
    public StoreChangeCreditsCommand(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin) {
        super(plugin, "store-change-credits", LanguageHandler.Term.COMMAND_STORE_CHANGE_CREDITS_USAGE, LanguageHandler.Term.COMMAND_STORE_CHANGE_CREDITS_DESCRIPTION, Permission.COMMAND_STORE_CHANGE_CREDITS);
    }

    @Override
    public void execute(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessCommandSender sender, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat [] args) {
        int credits;
        if (args.length != 2) {
            sender.sendMessage(this.usage());
            return;
        }
        try {
            try {
                credits = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException ignored) {
                sender.sendMessage(this.usage());
                return;
            }
        }
        catch (NumberFormatException e) {
            sender.sendMessage(this.usage());
            return;
        }
        if (credits == 0) {
            sender.sendMessage(this.language().get(LanguageHandler.Term.COMMAND_STORE_CHANGE_CREDITS_OUTPUT_NOTHING));
            return;
        }
        this.plugin().scheduler().runAsync(() -> {
            block6: {
                NamelessAPI api = this.apiProvider().api();
                if (api == null) {
                    this.scheduler().runSync(() -> sender.sendMessage(this.language().get(LanguageHandler.Term.ERROR_WEBSITE_CONNECTION)));
                    return;
                }
                try {
                    NamelessUser user = api.userByMinecraftUsername(args[0]);
                    if (user == null) {
                        this.scheduler().runSync(() -> sender.sendMessage(this.language().get(LanguageHandler.Term.ERROR_TARGET_NO_WEBSITE_ACCOUNT)));
                        return;
                    }
                    String namelessUsername = user.username();
                    if (credits > 0) {
                        user.store().addCredits(credits);
                        sender.sendMessage(this.language().get(LanguageHandler.Term.COMMAND_STORE_CHANGE_CREDITS_OUTPUT_ADDED, "credits", String.format("%.2f", Float.valueOf((float)credits / 100.0f)), "username", namelessUsername));
                        break block6;
                    }
                    if (credits < 0) {
                        user.store().removeCredits(-credits);
                        sender.sendMessage(this.language().get(LanguageHandler.Term.COMMAND_STORE_CHANGE_CREDITS_OUTPUT_REMOVED, "credits", String.format("%.2f", Float.valueOf((float)(-credits) / 100.0f)), "username", namelessUsername));
                        break block6;
                    }
                    throw new IllegalStateException();
                }
                catch (NamelessException e) {
                    this.logger().logException(e);
                }
            }
        });
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat List<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String> complete(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessCommandSender sender, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat [] args) {
        if (args.length == 1) {
            return this.plugin().userCache().minecraftUsernamesSearch(args[0]);
        }
        return Collections.emptyList();
    }
}

