/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.common.command;

import com.namelessmc.plugin.common.LanguageHandler;
import com.namelessmc.plugin.common.NamelessPlugin;
import com.namelessmc.plugin.common.Permission;
import com.namelessmc.plugin.common.audiences.NamelessCommandSender;
import com.namelessmc.plugin.common.audiences.NamelessPlayer;
import com.namelessmc.plugin.common.command.CommonCommand;
import com.namelessmc.plugin.lib.checker-framework.checker.formatter.qual.UnknownFormat;
import com.namelessmc.plugin.lib.checker-framework.checker.initialization.qual.Initialized;
import com.namelessmc.plugin.lib.checker-framework.checker.nonempty.qual.UnknownNonEmpty;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.NonNull;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.UnknownKeyFor;
import com.namelessmc.plugin.lib.checker-framework.checker.optional.qual.MaybePresent;
import com.namelessmc.plugin.lib.checker-framework.checker.regex.qual.UnknownRegex;
import com.namelessmc.plugin.lib.checker-framework.common.aliasing.qual.MaybeAliased;
import com.namelessmc.plugin.lib.checker-framework.common.aliasing.qual.MaybeLeaked;
import com.namelessmc.plugin.lib.nameless-api.NamelessAPI;
import com.namelessmc.plugin.lib.nameless-api.NamelessUser;
import com.namelessmc.plugin.lib.nameless-api.exception.NamelessException;
import com.namelessmc.plugin.lib.nameless-api.modules.suggestions.Suggestion;

public class SuggestCommand
extends CommonCommand {
    public SuggestCommand(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin) {
        super(plugin, "suggest", LanguageHandler.Term.COMMAND_SUGGEST_USAGE, LanguageHandler.Term.COMMAND_SUGGEST_DESCRIPTION, Permission.COMMAND_SUGGEST);
    }

    @Override
    protected void execute(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessCommandSender sender, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat [] args) {
        String suggestionTitle = String.join((CharSequence)" ", args);
        if (suggestionTitle.length() < 6) {
            sender.sendMessage(this.language().get(LanguageHandler.Term.COMMAND_SUGGEST_OUTPUT_TOO_SHORT));
            return;
        }
        NamelessAPI api = this.apiProvider().api();
        if (api == null) {
            sender.sendMessage(this.language().get(LanguageHandler.Term.ERROR_WEBSITE_CONNECTION));
            return;
        }
        if (!(sender instanceof NamelessPlayer)) {
            sender.sendMessage(this.language().get(LanguageHandler.Term.COMMAND_NOT_A_PLAYER));
            return;
        }
        this.scheduler().runAsync(() -> {
            try {
                NamelessUser user = api.userByMinecraftUuid(((NamelessPlayer)sender).uuid());
                if (user == null) {
                    this.scheduler().runSync(() -> sender.sendMessage(this.language().get(LanguageHandler.Term.PLAYER_SELF_NOT_REGISTERED)));
                    return;
                }
                Suggestion suggestion = user.suggestions().createSuggestion(suggestionTitle, suggestionTitle);
                String url = suggestion.url().toString();
                this.scheduler().runSync(() -> sender.sendMessage(this.language().get(LanguageHandler.Term.COMMAND_SUGGEST_OUTPUT_SUCCESS, "url", url)));
            }
            catch (NamelessException e) {
                this.scheduler().runSync(() -> sender.sendMessage(this.language().get(LanguageHandler.Term.ERROR_WEBSITE_CONNECTION)));
            }
        });
    }
}

