/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.adventure.text;

import com.namelessmc.plugin.lib.adventure.text.AbstractComponentBuilder;
import com.namelessmc.plugin.lib.adventure.text.Component;
import com.namelessmc.plugin.lib.adventure.text.ComponentLike;
import com.namelessmc.plugin.lib.adventure.text.NBTComponent;
import com.namelessmc.plugin.lib.adventure.text.NBTComponentBuilder;
import com.namelessmc.plugin.lib.jetbrains-annotations.NotNull;
import com.namelessmc.plugin.lib.jetbrains-annotations.Nullable;
import java.util.Objects;

abstract class AbstractNBTComponentBuilder<C extends NBTComponent<C, B>, B extends NBTComponentBuilder<C, B>>
extends AbstractComponentBuilder<C, B>
implements NBTComponentBuilder<C, B> {
    @Nullable
    protected String nbtPath;
    protected boolean interpret = false;
    @Nullable
    protected Component separator;

    AbstractNBTComponentBuilder() {
    }

    AbstractNBTComponentBuilder(@NotNull C component) {
        super(component);
        this.nbtPath = component.nbtPath();
        this.interpret = component.interpret();
        this.separator = component.separator();
    }

    @Override
    @NotNull
    public B nbtPath(@NotNull String nbtPath) {
        this.nbtPath = Objects.requireNonNull(nbtPath, "nbtPath");
        return (B)this;
    }

    @Override
    @NotNull
    public B interpret(boolean interpret) {
        this.interpret = interpret;
        return (B)this;
    }

    @Override
    @NotNull
    public B separator(@Nullable ComponentLike separator) {
        this.separator = ComponentLike.unbox(separator);
        return (B)this;
    }
}

