/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.adventure.text;

import com.namelessmc.plugin.lib.adventure.text.BuildableComponent;
import com.namelessmc.plugin.lib.adventure.text.Component;
import com.namelessmc.plugin.lib.adventure.text.ComponentBuilder;
import com.namelessmc.plugin.lib.adventure.text.ComponentLike;
import com.namelessmc.plugin.lib.adventure.text.ScopedComponent;
import com.namelessmc.plugin.lib.adventure.translation.Translatable;
import com.namelessmc.plugin.lib.examination.ExaminableProperty;
import com.namelessmc.plugin.lib.jetbrains-annotations.Contract;
import com.namelessmc.plugin.lib.jetbrains-annotations.NotNull;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public interface TranslatableComponent
extends BuildableComponent<TranslatableComponent, Builder>,
ScopedComponent<TranslatableComponent> {
    @NotNull
    public String key();

    @Contract(pure=true)
    @NotNull
    default public TranslatableComponent key(@NotNull Translatable translatable) {
        return this.key(Objects.requireNonNull(translatable, "translatable").translationKey());
    }

    @Contract(pure=true)
    @NotNull
    public TranslatableComponent key(@NotNull String var1);

    @NotNull
    public List<Component> args();

    @Contract(pure=true)
    @NotNull
    public TranslatableComponent args(ComponentLike ... var1);

    @Contract(pure=true)
    @NotNull
    public TranslatableComponent args(@NotNull List<? extends ComponentLike> var1);

    @Override
    @NotNull
    default public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.concat(Stream.of(ExaminableProperty.of("key", this.key()), ExaminableProperty.of("args", this.args())), BuildableComponent.super.examinableProperties());
    }

    public static interface Builder
    extends ComponentBuilder<TranslatableComponent, Builder> {
        @Contract(pure=true)
        @NotNull
        default public Builder key(@NotNull Translatable translatable) {
            return this.key(Objects.requireNonNull(translatable, "translatable").translationKey());
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder key(@NotNull String var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder args(@NotNull ComponentBuilder<?, ?> var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder args(ComponentBuilder<?, ?> ... var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder args(@NotNull Component var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder args(ComponentLike ... var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder args(@NotNull List<? extends ComponentLike> var1);
    }
}

