/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.configurate.serialize;

import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.Nullable;
import com.namelessmc.plugin.lib.configurate.serialize.PatternFlags;
import com.namelessmc.plugin.lib.configurate.serialize.ScalarSerializer;
import com.namelessmc.plugin.lib.configurate.serialize.SerializationException;
import java.lang.reflect.AnnotatedType;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

final class PatternSerializer
extends ScalarSerializer.Annotated<Pattern> {
    PatternSerializer() {
        super(Pattern.class);
    }

    @Override
    public Pattern deserialize(AnnotatedType type, Object obj) throws SerializationException {
        try {
            @Nullable PatternFlags flags = type.getAnnotation(PatternFlags.class);
            if (flags != null) {
                return Pattern.compile(obj.toString(), flags.value());
            }
            return Pattern.compile(obj.toString());
        }
        catch (PatternSyntaxException ex) {
            throw new SerializationException(ex);
        }
    }

    @Override
    public Object serialize(AnnotatedType type, Pattern item, Predicate<Class<?>> typeSupported) {
        return item.pattern();
    }
}

