/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.derkutils;

import com.namelessmc.plugin.lib.checker-framework.checker.formatter.qual.UnknownFormat;
import com.namelessmc.plugin.lib.checker-framework.checker.initialization.qual.Initialized;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.NonNull;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.UnknownKeyFor;
import com.namelessmc.plugin.lib.checker-framework.checker.optional.qual.MaybePresent;
import com.namelessmc.plugin.lib.checker-framework.checker.regex.qual.UnknownRegex;
import com.namelessmc.plugin.lib.checker-framework.common.aliasing.qual.MaybeAliased;
import com.namelessmc.plugin.lib.checker-framework.common.aliasing.qual.MaybeLeaked;
import com.namelessmc.plugin.lib.guava.base.Preconditions;
import io.netty.util.internal.ThreadLocalRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ListUtils {
    public static @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat boolean stringListContainsString(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat List<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String> list, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String string) {
        return ListUtils.stringListContainsString(list, string, false);
    }

    public static @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat boolean stringListContainsString(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat List<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String> list, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String string, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat boolean caseSensitive) {
        Objects.requireNonNull(list, "List is null");
        Objects.requireNonNull(string, "Contains string is null");
        boolean contains = false;
        for (String entry : list) {
            if (caseSensitive) {
                if (!entry.contains(string)) continue;
                contains = true;
                continue;
            }
            if (!entry.toLowerCase().contains(string.toLowerCase())) continue;
            contains = true;
        }
        return contains;
    }

    public static @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat List<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String> replaceInStringList(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat List<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String> list, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Object @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat [] before, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Object @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat [] after) {
        Objects.requireNonNull(list, "List is null");
        Objects.requireNonNull(before, "Before array is null");
        Objects.requireNonNull(after, "After array is null");
        Preconditions.checkArgument(before.length == after.length, "before[] length %s must be equal to after[] length %s", before.length, after.length);
        ArrayList<String> newList = new ArrayList<String>();
        for (String string : list) {
            for (int i = 0; i < before.length; ++i) {
                string = string.replace(before[i].toString(), after[i].toString());
            }
            newList.add(string);
        }
        return newList;
    }

    public static @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat List<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String> replaceInStringList(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat List<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String> list, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Object before, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Object after) {
        return ListUtils.replaceInStringList(list, new Object[]{before}, new Object[]{after});
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat int sizeSum(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Collection<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Collection<T>> collections) {
        Objects.requireNonNull(collections, "Collections collection is null");
        int size = 0;
        for (Collection<T> col : collections) {
            Objects.requireNonNull(col, "A collection is null");
            size += col.size();
        }
        return size;
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat int sizeSum(T @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat [] @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat [] arrays) {
        Objects.requireNonNull(arrays, "Arrays array is null");
        int size = 0;
        for (T[] array : arrays) {
            Objects.requireNonNull(array, "An array is null");
            size += array.length;
        }
        return size;
    }

    public static <T> T @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat [] combineArrays(T[] ... arrays) {
        ArrayList<T> list = new ArrayList<T>(ListUtils.sizeSum(arrays));
        for (T[] array : arrays) {
            list.addAll(Arrays.asList(array));
        }
        return list.toArray();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Optional<T> toOptional(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Collection<T> collection) {
        if (collection.isEmpty()) {
            return Optional.empty();
        }
        Preconditions.checkArgument(collection.size() == 1, "Size of collection must be 1 if it is not empty, but it is %s", collection.size());
        return Optional.of(collection.iterator().next());
    }

    public static <T> T choice(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Set<T> set) {
        Preconditions.checkNotNull(set, "Set is null");
        Preconditions.checkArgument(set.size() > 0, "Set must contain at least one element");
        return (T)set.stream().skip(ThreadLocalRandom.current().nextInt(set.size())).findFirst().orElseThrow();
    }

    public static <T> T choice(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat List<T> list) {
        return list.get(ThreadLocalRandom.current().nextInt(list.size()));
    }

    public static <T> T choice(T @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat [] array) {
        return array[ThreadLocalRandom.current().nextInt(array.length)];
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat List<T> chooseMultiple(T @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat [] array, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat int amount) {
        Preconditions.checkArgument(amount <= array.length, "Amount to pick from array must not exceed array size, but is %s", amount);
        return IntStream.generate(() -> ThreadLocalRandom.current().nextInt(array.length)).distinct().limit(amount).mapToObj(i -> array[i]).collect(Collectors.toList());
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat List<T> chooseMultiple(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat List<T> list, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat int amount) {
        Preconditions.checkArgument(amount <= list.size(), "Amount to pick from array must not exceed array size, but is %s", amount);
        return IntStream.generate(() -> ThreadLocalRandom.current().nextInt(list.size())).distinct().limit(amount).mapToObj(list::get).collect(Collectors.toList());
    }
}

