/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.event;

import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.NonNull;
import com.namelessmc.plugin.lib.event.EventBus;
import com.namelessmc.plugin.lib.event.EventSubscriber;
import com.namelessmc.plugin.lib.event.EventSubscription;
import com.namelessmc.plugin.lib.event.Internals;
import com.namelessmc.plugin.lib.event.PostResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

final class EventBusImpl<E>
implements EventBus<E> {
    private static final Comparator<EventSubscriber<?>> COMPARATOR = Comparator.comparingInt(EventSubscriber::postOrder);
    private final Map<Class<? extends E>, Collection<? extends Class<?>>> classes = new HashMap();
    private final Map<Class<? extends E>, List<EventSubscriber<? super E>>> unbaked = new HashMap<Class<? extends E>, List<EventSubscriber<? super E>>>();
    private final Map<Class<? extends E>, List<EventSubscriber<? super E>>> baked = new HashMap<Class<? extends E>, List<EventSubscriber<? super E>>>();
    private final Object lock = new Object();
    private final Class<E> type;
    private final EventBus.Accepts<E> accepts;

    EventBusImpl(Class<E> type, EventBus.Accepts<E> accepts) {
        this.type = type;
        this.accepts = accepts;
    }

    @Override
    public @NonNull Class<E> type() {
        return this.type;
    }

    @Override
    public @NonNull PostResult post(@NonNull E event) {
        HashMap exceptions = null;
        List<EventSubscriber<?>> subscribers = this.subscribers(event.getClass());
        for (EventSubscriber<?> subscriber : subscribers) {
            if (!this.accepts(event, subscriber)) continue;
            try {
                subscriber.on(event);
            }
            catch (Throwable t) {
                if (exceptions == null) {
                    exceptions = new HashMap();
                }
                exceptions.put(subscriber, t);
            }
        }
        if (exceptions == null) {
            return PostResult.success();
        }
        return PostResult.failure(exceptions);
    }

    private boolean accepts(E event, EventSubscriber<? super E> subscriber) {
        return this.accepts.accepts((Class<? super E>)this.type, (E)event, subscriber);
    }

    @Override
    public boolean subscribed(@NonNull Class<? extends E> type) {
        return !this.subscribers(type).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends E> @NonNull EventSubscription subscribe(@NonNull Class<T> event, @NonNull EventSubscriber<? super T> subscriber) {
        Object object = this.lock;
        synchronized (object) {
            List subscribers = EventBusImpl.yayGenerics(this.unbaked.computeIfAbsent(event, key -> new ArrayList()));
            subscribers.add(subscriber);
            this.baked.clear();
        }
        return () -> {
            Object object = this.lock;
            synchronized (object) {
                List subscribers = EventBusImpl.yayGenerics(this.unbaked.get(event));
                if (subscribers != null) {
                    subscribers.remove(subscriber);
                    this.baked.clear();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribeIf(@NonNull Predicate<EventSubscriber<? super E>> predicate) {
        Object object = this.lock;
        synchronized (object) {
            boolean dirty = false;
            for (List<EventSubscriber<EventSubscriber<? super E>>> list : this.unbaked.values()) {
                dirty |= list.removeIf(predicate);
            }
            if (dirty) {
                this.baked.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<EventSubscriber<? super E>> subscribers(@NonNull Class<? extends E> event) {
        Object object = this.lock;
        synchronized (object) {
            return this.baked.computeIfAbsent(event, this::subscribers0);
        }
    }

    private List<EventSubscriber<? super E>> subscribers0(@NonNull Class<? extends E> event) {
        ArrayList subscribers = new ArrayList();
        Collection types = this.classes.computeIfAbsent(event, this::findClasses);
        for (Class type : types) {
            subscribers.addAll(this.unbaked.getOrDefault(type, Collections.emptyList()));
        }
        subscribers.sort(COMPARATOR);
        return subscribers;
    }

    private Collection<? extends Class<?>> findClasses(Class<?> type) {
        List<Class<?>> classes = Internals.ancestors(type);
        classes.removeIf(klass -> !this.type.isAssignableFrom((Class<?>)klass));
        return classes;
    }

    private static <T extends U, U> List<U> yayGenerics(List<T> list) {
        return list;
    }
}

