/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.guava.base;

import com.namelessmc.plugin.lib.errorprone.annotations.CanIgnoreReturnValue;
import com.namelessmc.plugin.lib.guava.annotations.GwtCompatible;
import com.namelessmc.plugin.lib.guava.base.ElementTypesAreNonnullByDefault;
import com.namelessmc.plugin.lib.guava.base.NullnessCasts;
import com.namelessmc.plugin.lib.guava.base.ParametricNullness;
import com.namelessmc.plugin.lib.guava.base.Preconditions;
import com.namelessmc.plugin.lib.javax-annotation.CheckForNull;
import java.util.Iterator;
import java.util.NoSuchElementException;

@ElementTypesAreNonnullByDefault
@GwtCompatible
abstract class AbstractIterator<T>
implements Iterator<T> {
    private State state = State.NOT_READY;
    @CheckForNull
    private T next;

    protected AbstractIterator() {
    }

    @CheckForNull
    protected abstract T computeNext();

    @CheckForNull
    @CanIgnoreReturnValue
    protected final T endOfData() {
        this.state = State.DONE;
        return null;
    }

    @Override
    public final boolean hasNext() {
        Preconditions.checkState(this.state != State.FAILED);
        switch (this.state.ordinal()) {
            case 2: {
                return false;
            }
            case 0: {
                return true;
            }
        }
        return this.tryToComputeNext();
    }

    private boolean tryToComputeNext() {
        this.state = State.FAILED;
        this.next = this.computeNext();
        if (this.state != State.DONE) {
            this.state = State.READY;
            return true;
        }
        return false;
    }

    @Override
    @ParametricNullness
    public final T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.state = State.NOT_READY;
        T result = NullnessCasts.uncheckedCastNullableTToT(this.next);
        this.next = null;
        return result;
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    private static enum State {
        READY,
        NOT_READY,
        DONE,
        FAILED;

    }
}

