/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.methanol;

import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.MonotonicNonNull;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.Nullable;
import com.namelessmc.plugin.lib.errorprone.annotations.CanIgnoreReturnValue;
import com.namelessmc.plugin.lib.methanol.CacheAwareResponse;
import com.namelessmc.plugin.lib.methanol.Methanol;
import com.namelessmc.plugin.lib.methanol.StorageExtension;
import com.namelessmc.plugin.lib.methanol.TrackedResponse;
import com.namelessmc.plugin.lib.methanol.internal.Utils;
import com.namelessmc.plugin.lib.methanol.internal.Validate;
import com.namelessmc.plugin.lib.methanol.internal.cache.CacheInterceptor;
import com.namelessmc.plugin.lib.methanol.internal.cache.CacheReadingPublisher;
import com.namelessmc.plugin.lib.methanol.internal.cache.CacheResponse;
import com.namelessmc.plugin.lib.methanol.internal.cache.CacheResponseMetadata;
import com.namelessmc.plugin.lib.methanol.internal.cache.CacheWritingPublisher;
import com.namelessmc.plugin.lib.methanol.internal.cache.DiskStore;
import com.namelessmc.plugin.lib.methanol.internal.cache.InternalStorageExtension;
import com.namelessmc.plugin.lib.methanol.internal.cache.LocalCache;
import com.namelessmc.plugin.lib.methanol.internal.cache.NetworkResponse;
import com.namelessmc.plugin.lib.methanol.internal.cache.Store;
import com.namelessmc.plugin.lib.methanol.internal.concurrent.FallbackExecutorProvider;
import com.namelessmc.plugin.lib.methanol.internal.flow.FlowSupport;
import com.namelessmc.plugin.lib.methanol.internal.function.Unchecked;
import java.io.Flushable;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.nio.file.Path;
import java.time.Clock;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class HttpCache
implements AutoCloseable,
Flushable {
    private static final System.Logger logger = System.getLogger(HttpCache.class.getName());
    private static final int CACHE_VERSION = 1;
    private final Store store;
    private final Executor executor;
    private final boolean isDefaultExecutor;
    private final StatsRecorder statsRecorder;
    private final Clock clock;
    private final boolean synchronizeWrites;
    private final Optional<Listener> userListener;
    private final Listener listener;
    private final LocalCache asyncLocalCache;
    private final LocalCache syncLocalCache;
    private volatile boolean disable;

    private HttpCache(Store store, Executor executor, boolean isDefaultExecutor, Builder builder) {
        this.store = Objects.requireNonNull(store);
        this.executor = Objects.requireNonNull(executor);
        this.isDefaultExecutor = isDefaultExecutor;
        this.statsRecorder = Objects.requireNonNullElseGet(builder.statsRecorder, StatsRecorder::createConcurrentRecorder);
        this.clock = Objects.requireNonNullElse(builder.clock, Utils.systemMillisUtc());
        this.synchronizeWrites = builder.synchronizeWrites;
        this.userListener = Optional.ofNullable(builder.listener);
        this.listener = new CompositeListener(this.userListener.orElse(DisabledListener.INSTANCE), new StatsRecordingListener(this.statsRecorder));
        this.asyncLocalCache = new LocalCacheImpl(executor);
        this.syncLocalCache = new LocalCacheImpl(FlowSupport.SYNC_EXECUTOR);
    }

    Store store() {
        return this.store;
    }

    public Optional<Path> directory() {
        return this.store instanceof DiskStore ? Optional.of(((DiskStore)this.store).directory()) : Optional.empty();
    }

    public long maxSize() {
        return this.store.maxSize();
    }

    public Optional<Executor> executor() {
        return this.isDefaultExecutor ? Optional.empty() : Optional.of(this.executor);
    }

    public Optional<Listener> listener() {
        return this.userListener;
    }

    public long size() throws IOException {
        return this.store.size();
    }

    public Stats stats() {
        return this.statsRecorder.snapshot();
    }

    public Stats stats(URI uri) {
        return this.statsRecorder.snapshot(uri);
    }

    @Deprecated(since="1.8.0", forRemoval=true)
    public void initialize() {
    }

    @Deprecated(since="1.8.0", forRemoval=true)
    public CompletableFuture<Void> initializeAsync() {
        return CompletableFuture.completedFuture(null);
    }

    public Iterator<URI> uris() throws IOException {
        return new Iterator<URI>(){
            private final Iterator<Store.Viewer> viewerIterator;
            private @Nullable URI nextUri;
            private boolean canRemove;
            {
                this.viewerIterator = HttpCache.this.store.iterator();
            }

            @Override
            public boolean hasNext() {
                this.canRemove = false;
                return this.nextUri != null || this.findNext();
            }

            @Override
            public URI next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                URI uri = Validate.castNonNull(this.nextUri);
                this.nextUri = null;
                this.canRemove = true;
                return uri;
            }

            @Override
            public void remove() {
                Validate.requireState(this.canRemove, "next() must be called before remove()");
                this.canRemove = false;
                this.viewerIterator.remove();
            }

            private boolean findNext() {
                while (this.nextUri == null && this.viewerIterator.hasNext()) {
                    Store.Viewer viewer = this.viewerIterator.next();
                    try {
                        CacheResponseMetadata metadata = HttpCache.tryRecoverMetadata(viewer);
                        if (metadata == null) continue;
                        this.nextUri = metadata.uri();
                        boolean bl = true;
                        return bl;
                    }
                    finally {
                        if (viewer == null) continue;
                        viewer.close();
                    }
                }
                return false;
            }
        };
    }

    public void clear() throws IOException {
        this.store.clear();
    }

    public boolean remove(URI uri) throws IOException {
        return this.store.remove(HttpCache.toStoreKey(uri));
    }

    public boolean remove(HttpRequest request) throws IOException {
        try (Store.Viewer viewer = this.store.view(HttpCache.toStoreKey(request)).orElse(null);){
            CacheResponseMetadata metadata;
            if (viewer != null && (metadata = HttpCache.tryRecoverMetadata(viewer)) != null && metadata.matches(request)) {
                boolean bl = viewer.removeEntry();
                return bl;
            }
        }
        return false;
    }

    public void enable(boolean on) {
        this.disable = !on;
    }

    public boolean isEnabled() {
        return !this.disable;
    }

    public void dispose() throws IOException {
        this.store.dispose();
    }

    @Override
    public void flush() throws IOException {
        this.store.flush();
    }

    @Override
    public void close() throws IOException {
        this.store.close();
    }

    public String toString() {
        return Utils.toStringIdentityPrefix(this) + "[store=" + this.store + "]";
    }

    Methanol.Interceptor interceptor(Predicate<String> implicitHeaderPredicate) {
        return new CacheInterceptor(async -> async ? this.asyncLocalCache : this.syncLocalCache, this.listener, this.executor, this.clock, this.synchronizeWrites, implicitHeaderPredicate);
    }

    static String toStoreKey(HttpRequest request) {
        return HttpCache.toStoreKey(request.uri());
    }

    static String toStoreKey(URI uri) {
        return uri.toString();
    }

    private static @Nullable CacheResponseMetadata tryRecoverMetadata(Store.Viewer viewer) {
        try {
            return CacheResponseMetadata.decode(viewer.metadata());
        }
        catch (IOException e) {
            try {
                viewer.removeEntry();
            }
            catch (IOException removeEx) {
                e.addSuppressed(removeEx);
            }
            logger.log(System.Logger.Level.WARNING, "Unrecoverable cache entry", (Throwable)e);
            return null;
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private static CacheReadingPublisher.Listener toReadListener(final Listener listener, final HttpRequest request) {
        return new CacheReadingPublisher.Listener(){

            @Override
            public void onReadSuccess() {
                listener.onReadSuccess(request);
            }

            @Override
            public void onReadFailure(Throwable exception) {
                listener.onReadFailure(request, exception);
            }
        };
    }

    private static CacheWritingPublisher.Listener toWriteListener(final Listener listener, final HttpRequest request) {
        return new CacheWritingPublisher.Listener(){

            @Override
            public void onWriteSuccess() {
                listener.onWriteSuccess(request);
            }

            @Override
            public void onWriteFailure(Throwable exception) {
                listener.onWriteFailure(request, exception);
            }
        };
    }

    public static final class Builder {
        @MonotonicNonNull InternalStorageExtension storageExtension;
        @MonotonicNonNull Executor executor;
        @MonotonicNonNull StatsRecorder statsRecorder;
        @MonotonicNonNull Listener listener;
        @MonotonicNonNull Clock clock;
        boolean synchronizeWrites;

        Builder() {
        }

        @CanIgnoreReturnValue
        public Builder cacheOnMemory(long maxSize) {
            return this.cacheOn(StorageExtension.inMemory(maxSize));
        }

        @CanIgnoreReturnValue
        public Builder cacheOnDisk(Path directory, long maxSize) {
            return this.cacheOn(StorageExtension.onDisk(directory, maxSize));
        }

        @CanIgnoreReturnValue
        public Builder cacheOn(StorageExtension storageExtension) {
            Objects.requireNonNull(storageExtension);
            Validate.requireArgument(storageExtension instanceof InternalStorageExtension, "Unrecognized StorageExtension: %s", storageExtension);
            this.storageExtension = (InternalStorageExtension)storageExtension;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder executor(Executor executor) {
            this.executor = Objects.requireNonNull(executor);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder statsRecorder(StatsRecorder statsRecorder) {
            this.statsRecorder = Objects.requireNonNull(statsRecorder);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder listener(Listener listener) {
            this.listener = Objects.requireNonNull(listener);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder synchronizeWrites(boolean synchronizeWrites) {
            this.synchronizeWrites = synchronizeWrites;
            return this;
        }

        @CanIgnoreReturnValue
        Builder clock(Clock clock) {
            this.clock = Objects.requireNonNull(clock);
            return this;
        }

        private InternalStorageExtension storageExtension() {
            InternalStorageExtension storeExtension = this.storageExtension;
            Validate.requireState(storeExtension != null, "A storage backend must be specified");
            return storeExtension;
        }

        public HttpCache build() {
            boolean isDefaultExecutor;
            Executor executor = this.executor;
            if (executor != null) {
                isDefaultExecutor = false;
            } else {
                executor = FallbackExecutorProvider.get();
                isDefaultExecutor = true;
            }
            Store store = this.storageExtension().createStore(executor, 1);
            return new HttpCache(store, executor, isDefaultExecutor, this);
        }
    }

    private static final class StatsSnapshot
    implements Stats {
        static final Stats EMPTY = new StatsSnapshot(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
        private final long requestCount;
        private final long hitCount;
        private final long missCount;
        private final long networkUseCount;
        private final long readSuccessCount;
        private final long readFailureCounter;
        private final long writeSuccessCount;
        private final long writeFailureCount;

        StatsSnapshot(long requestCount, long hitCount, long missCount, long networkUseCount, long readSuccessCount, long readFailureCounter, long writeSuccessCount, long writeFailureCount) {
            this.requestCount = requestCount;
            this.hitCount = hitCount;
            this.missCount = missCount;
            this.networkUseCount = networkUseCount;
            this.readSuccessCount = readSuccessCount;
            this.readFailureCounter = readFailureCounter;
            this.writeSuccessCount = writeSuccessCount;
            this.writeFailureCount = writeFailureCount;
        }

        @Override
        public long requestCount() {
            return this.requestCount;
        }

        @Override
        public long hitCount() {
            return this.hitCount;
        }

        @Override
        public long missCount() {
            return this.missCount;
        }

        @Override
        public long networkUseCount() {
            return this.networkUseCount;
        }

        @Override
        public long readSuccessCount() {
            return this.readSuccessCount;
        }

        @Override
        public long readFailureCount() {
            return this.readFailureCounter;
        }

        @Override
        public long writeSuccessCount() {
            return this.writeSuccessCount;
        }

        @Override
        public long writeFailureCount() {
            return this.writeFailureCount;
        }

        public int hashCode() {
            return Objects.hash(this.requestCount, this.hitCount, this.missCount, this.networkUseCount, this.readSuccessCount, this.readFailureCounter, this.writeSuccessCount, this.writeFailureCount);
        }

        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof Stats)) {
                return false;
            }
            Stats other = (Stats)obj;
            return this.requestCount == other.requestCount() && this.hitCount == other.hitCount() && this.missCount == other.missCount() && this.networkUseCount == other.networkUseCount() && this.readSuccessCount == other.readSuccessCount() && this.readFailureCounter == other.readFailureCount() && this.writeSuccessCount == other.writeSuccessCount() && this.writeFailureCount == other.writeFailureCount();
        }

        public String toString() {
            return String.format("Stats[requestCount=%d, hitCount=%d, missCount=%d, networkUseCount=%d, readSuccessCount=%d, readFailureCount=%d, writeSuccessCount=%d, writeFailureCount=%d]", this.requestCount, this.hitCount, this.missCount, this.networkUseCount, this.readSuccessCount, this.readFailureCounter, this.writeSuccessCount, this.writeFailureCount);
        }
    }

    private static enum DisabledStatsRecorder implements StatsRecorder
    {
        INSTANCE;


        @Override
        public void recordRequest(URI uri) {
        }

        @Override
        public void recordHit(URI uri) {
        }

        @Override
        public void recordMiss(URI uri) {
        }

        @Override
        public void recordNetworkUse(URI uri) {
        }

        @Override
        public void recordWriteSuccess(URI uri) {
        }

        @Override
        public void recordWriteFailure(URI uri) {
        }

        @Override
        public Stats snapshot() {
            return Stats.empty();
        }

        @Override
        public Stats snapshot(URI uri) {
            return Stats.empty();
        }
    }

    private static final class ConcurrentPerUriStatsRecorder
    extends ConcurrentStatsRecorder {
        private final ConcurrentMap<URI, StatsRecorder> perUriRecorders = new ConcurrentHashMap<URI, StatsRecorder>();

        ConcurrentPerUriStatsRecorder() {
        }

        @Override
        public void recordRequest(URI uri) {
            super.recordRequest(uri);
            this.perUriRecorders.computeIfAbsent(uri, __ -> new ConcurrentStatsRecorder()).recordRequest(uri);
        }

        @Override
        public void recordHit(URI uri) {
            super.recordHit(uri);
            this.perUriRecorders.computeIfAbsent(uri, __ -> new ConcurrentStatsRecorder()).recordHit(uri);
        }

        @Override
        public void recordMiss(URI uri) {
            super.recordMiss(uri);
            this.perUriRecorders.computeIfAbsent(uri, __ -> new ConcurrentStatsRecorder()).recordMiss(uri);
        }

        @Override
        public void recordNetworkUse(URI uri) {
            super.recordNetworkUse(uri);
            this.perUriRecorders.computeIfAbsent(uri, __ -> new ConcurrentStatsRecorder()).recordNetworkUse(uri);
        }

        @Override
        public void recordReadSuccess(URI uri) {
            super.recordReadSuccess(uri);
            this.perUriRecorders.computeIfAbsent(uri, __ -> new ConcurrentStatsRecorder()).recordReadSuccess(uri);
        }

        @Override
        public void recordReadFailure(URI uri) {
            super.recordReadFailure(uri);
            this.perUriRecorders.computeIfAbsent(uri, __ -> new ConcurrentStatsRecorder()).recordReadFailure(uri);
        }

        @Override
        public void recordWriteSuccess(URI uri) {
            super.recordWriteSuccess(uri);
            this.perUriRecorders.computeIfAbsent(uri, __ -> new ConcurrentStatsRecorder()).recordWriteSuccess(uri);
        }

        @Override
        public void recordWriteFailure(URI uri) {
            super.recordWriteFailure(uri);
            this.perUriRecorders.computeIfAbsent(uri, __ -> new ConcurrentStatsRecorder()).recordWriteFailure(uri);
        }

        @Override
        public Stats snapshot(URI uri) {
            StatsRecorder recorder = (StatsRecorder)this.perUriRecorders.get(uri);
            return recorder != null ? recorder.snapshot() : Stats.empty();
        }
    }

    private static class ConcurrentStatsRecorder
    implements StatsRecorder {
        private final LongAdder requestCounter = new LongAdder();
        private final LongAdder hitCounter = new LongAdder();
        private final LongAdder missCounter = new LongAdder();
        private final LongAdder networkUseCounter = new LongAdder();
        private final LongAdder readSuccessCounter = new LongAdder();
        private final LongAdder readFailureCounter = new LongAdder();
        private final LongAdder writeSuccessCounter = new LongAdder();
        private final LongAdder writeFailureCounter = new LongAdder();

        ConcurrentStatsRecorder() {
        }

        @Override
        public void recordRequest(URI uri) {
            Objects.requireNonNull(uri);
            this.requestCounter.increment();
        }

        @Override
        public void recordHit(URI uri) {
            Objects.requireNonNull(uri);
            this.hitCounter.increment();
        }

        @Override
        public void recordMiss(URI uri) {
            Objects.requireNonNull(uri);
            this.missCounter.increment();
        }

        @Override
        public void recordNetworkUse(URI uri) {
            Objects.requireNonNull(uri);
            this.networkUseCounter.increment();
        }

        @Override
        public void recordReadSuccess(URI uri) {
            Objects.requireNonNull(uri);
            this.readSuccessCounter.increment();
        }

        @Override
        public void recordReadFailure(URI uri) {
            Objects.requireNonNull(uri);
            this.readFailureCounter.increment();
        }

        @Override
        public void recordWriteSuccess(URI uri) {
            Objects.requireNonNull(uri);
            this.writeSuccessCounter.increment();
        }

        @Override
        public void recordWriteFailure(URI uri) {
            Objects.requireNonNull(uri);
            this.writeFailureCounter.increment();
        }

        @Override
        public Stats snapshot() {
            return new StatsSnapshot(this.requestCounter.sum(), this.hitCounter.sum(), this.missCounter.sum(), this.networkUseCounter.sum(), this.readSuccessCounter.sum(), this.readFailureCounter.sum(), this.writeSuccessCounter.sum(), this.writeFailureCounter.sum());
        }

        @Override
        public Stats snapshot(URI uri) {
            return Stats.empty();
        }
    }

    public static interface StatsRecorder {
        public void recordRequest(URI var1);

        public void recordHit(URI var1);

        public void recordMiss(URI var1);

        public void recordNetworkUse(URI var1);

        default public void recordReadSuccess(URI uri) {
        }

        default public void recordReadFailure(URI uri) {
        }

        public void recordWriteSuccess(URI var1);

        public void recordWriteFailure(URI var1);

        public Stats snapshot();

        public Stats snapshot(URI var1);

        public static StatsRecorder createConcurrentRecorder() {
            return new ConcurrentStatsRecorder();
        }

        public static StatsRecorder createConcurrentPerUriRecorder() {
            return new ConcurrentPerUriStatsRecorder();
        }

        public static StatsRecorder disabled() {
            return DisabledStatsRecorder.INSTANCE;
        }
    }

    public static interface Stats {
        public long requestCount();

        public long hitCount();

        public long missCount();

        public long networkUseCount();

        default public long readSuccessCount() {
            return 0L;
        }

        default public long readFailureCount() {
            return 0L;
        }

        public long writeSuccessCount();

        public long writeFailureCount();

        default public double hitRate() {
            return Stats.rate(this.hitCount(), this.requestCount());
        }

        default public double missRate() {
            return Stats.rate(this.missCount(), this.requestCount());
        }

        private static double rate(long x, long y) {
            return y == 0L || x >= y ? 1.0 : (double)x / (double)y;
        }

        public static Stats empty() {
            return StatsSnapshot.EMPTY;
        }
    }

    private static final class CompositeListener
    implements Listener {
        private final List<Listener> listeners;

        CompositeListener(Listener ... listeners) {
            this.listeners = List.of(listeners);
        }

        @Override
        public void onRequest(HttpRequest request) {
            this.listeners.forEach(listener -> listener.onRequest(request));
        }

        @Override
        public void onNetworkUse(HttpRequest request, @Nullable TrackedResponse<?> cacheResponse) {
            this.listeners.forEach(listener -> listener.onNetworkUse(request, cacheResponse));
        }

        @Override
        public void onResponse(HttpRequest request, CacheAwareResponse<?> response) {
            this.listeners.forEach(listener -> listener.onResponse(request, response));
        }

        @Override
        public void onReadSuccess(HttpRequest request) {
            this.listeners.forEach(listener -> listener.onReadSuccess(request));
        }

        @Override
        public void onReadFailure(HttpRequest request, Throwable exception) {
            this.listeners.forEach(listener -> listener.onReadFailure(request, exception));
        }

        @Override
        public void onWriteSuccess(HttpRequest request) {
            this.listeners.forEach(listener -> listener.onWriteSuccess(request));
        }

        @Override
        public void onWriteFailure(HttpRequest request, Throwable exception) {
            this.listeners.forEach(listener -> listener.onWriteFailure(request, exception));
        }
    }

    private static final class StatsRecordingListener
    implements Listener {
        private final StatsRecorder statsRecorder;

        StatsRecordingListener(StatsRecorder statsRecorder) {
            this.statsRecorder = statsRecorder;
        }

        @Override
        public void onRequest(HttpRequest request) {
            this.statsRecorder.recordRequest(request.uri());
        }

        @Override
        public void onNetworkUse(HttpRequest request, @Nullable TrackedResponse<?> cacheResponse) {
            this.statsRecorder.recordNetworkUse(request.uri());
        }

        @Override
        public void onResponse(HttpRequest request, CacheAwareResponse<?> response) {
            switch (response.cacheStatus()) {
                case MISS: 
                case UNSATISFIABLE: {
                    this.statsRecorder.recordMiss(request.uri());
                    break;
                }
                case HIT: 
                case CONDITIONAL_HIT: {
                    this.statsRecorder.recordHit(request.uri());
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected status: " + response.cacheStatus()));
                }
            }
        }

        @Override
        public void onReadSuccess(HttpRequest request) {
            this.statsRecorder.recordReadSuccess(request.uri());
        }

        @Override
        public void onReadFailure(HttpRequest request, Throwable exception) {
            this.statsRecorder.recordReadFailure(request.uri());
        }

        @Override
        public void onWriteSuccess(HttpRequest request) {
            this.statsRecorder.recordWriteSuccess(request.uri());
        }

        @Override
        public void onWriteFailure(HttpRequest request, Throwable exception) {
            this.statsRecorder.recordWriteFailure(request.uri());
        }
    }

    private static enum DisabledListener implements Listener
    {
        INSTANCE;

    }

    public static interface Listener {
        default public void onRequest(HttpRequest request) {
        }

        default public void onNetworkUse(HttpRequest request, @Nullable TrackedResponse<?> cacheResponse) {
        }

        default public void onResponse(HttpRequest request, CacheAwareResponse<?> response) {
        }

        default public void onReadSuccess(HttpRequest request) {
        }

        default public void onReadFailure(HttpRequest request, Throwable exception) {
        }

        default public void onWriteSuccess(HttpRequest request) {
        }

        default public void onWriteFailure(HttpRequest request, Throwable exception) {
        }
    }

    private final class LocalCacheImpl
    implements LocalCache {
        private final Executor executor;

        LocalCacheImpl(Executor executor) {
            this.executor = executor;
        }

        @Override
        public CompletableFuture<Optional<CacheResponse>> get(HttpRequest request) {
            if (HttpCache.this.disable) {
                return CompletableFuture.completedFuture(Optional.empty());
            }
            return HttpCache.this.store.view(HttpCache.toStoreKey(request), this.executor).thenApply(viewer -> this.readCacheResponse((Optional<Store.Viewer>)viewer, request));
        }

        private Optional<CacheResponse> readCacheResponse(Optional<Store.Viewer> viewer, HttpRequest request) {
            Optional<CacheResponse> cacheResponse = viewer.map(x$0 -> HttpCache.tryRecoverMetadata(x$0)).filter(metadata -> metadata.matches(request)).map(metadata -> new CacheResponse(metadata.toResponseBuilder().buildTrackedResponse(), (Store.Viewer)viewer.orElseThrow(), this.executor, HttpCache.toReadListener(HttpCache.this.listener, request)));
            if (cacheResponse.isEmpty()) {
                viewer.ifPresent(Store.Viewer::close);
            }
            return cacheResponse;
        }

        @Override
        public CompletableFuture<Boolean> update(CacheResponse cacheResponse) {
            if (HttpCache.this.disable) {
                return CompletableFuture.completedFuture(false);
            }
            return cacheResponse.edit().thenCompose(optionalEditor -> optionalEditor.map(editor -> ((CompletableFuture)editor.commit(CacheResponseMetadata.from(cacheResponse.get()).encode(), this.executor).thenApply(__ -> true)).whenComplete((__, ___) -> editor.close())).orElseGet(() -> CompletableFuture.completedFuture(false)));
        }

        @Override
        public CompletableFuture<Optional<NetworkResponse>> put(HttpRequest request, NetworkResponse networkResponse, @Nullable CacheResponse existingCacheResponse) {
            if (HttpCache.this.disable) {
                return CompletableFuture.completedFuture(Optional.empty());
            }
            CompletableFuture<Optional<Store.Editor>> editorFuture = existingCacheResponse != null ? existingCacheResponse.edit() : HttpCache.this.store.edit(HttpCache.toStoreKey(request), this.executor);
            return editorFuture.thenApply(optionalEditor -> optionalEditor.map(editor -> networkResponse.writingWith((Store.Editor)editor, this.executor, HttpCache.toWriteListener(HttpCache.this.listener, request), HttpCache.this.synchronizeWrites)));
        }

        @Override
        public CompletableFuture<Boolean> removeAll(List<URI> uris) {
            if (HttpCache.this.disable) {
                return CompletableFuture.completedFuture(false);
            }
            return Unchecked.supplyAsync(() -> HttpCache.this.store.removeAll(uris.stream().map(HttpCache::toStoreKey).collect(Collectors.toUnmodifiableList())), this.executor);
        }
    }
}

