/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.methanol;

import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.MonotonicNonNull;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.Nullable;
import com.namelessmc.plugin.lib.errorprone.annotations.InlineMe;
import com.namelessmc.plugin.lib.methanol.internal.Validate;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;

public abstract class TypeRef<T> {
    private final Type type;
    private @MonotonicNonNull Class<?> lazyRawType;
    private @MonotonicNonNull List<TypeRef<?>> lazyTypeArguments;

    protected TypeRef() {
        Type superclass = this.getClass().getGenericSuperclass();
        Validate.requireState(superclass instanceof ParameterizedType, "TypeRef must be used in parameterized form (i.e. new TypeRef<List<String>>() {})");
        this.type = ((ParameterizedType)superclass).getActualTypeArguments()[0];
    }

    private TypeRef(Type type) {
        this.type = type;
        this.lazyRawType = TypeRef.rawTypeOf(type);
    }

    public final Type type() {
        return this.type;
    }

    public final Class<? super T> rawType() {
        Class<?> rawType = this.lazyRawType;
        if (rawType == null) {
            try {
                rawType = TypeRef.rawTypeOf(this.type);
            }
            catch (IllegalArgumentException e) {
                throw new AssertionError("Couldn't get raw type of <" + this.type + ">", e);
            }
            this.lazyRawType = rawType;
        }
        return rawType;
    }

    public final boolean isRawType() {
        return this.type instanceof Class;
    }

    public final boolean isParameterizedType() {
        return this.type instanceof ParameterizedType;
    }

    public final boolean isGenericArray() {
        return this.type instanceof GenericArrayType;
    }

    public final boolean isTypeVariable() {
        return this.type instanceof TypeVariable;
    }

    public final boolean isWildcard() {
        return this.type instanceof WildcardType;
    }

    public final Optional<TypeRef<?>> typeArgumentAt(int i) {
        Validate.requireArgument(i >= 0, "Negative index: %d", i);
        List<TypeRef<?>> typeArguments = this.typeArguments();
        return i < typeArguments.size() ? Optional.of(typeArguments.get(i)) : Optional.empty();
    }

    public final Class<T> exactRawType() {
        if (!(this.type instanceof Class)) {
            throw new UnsupportedOperationException("<" + this.type + "> is not a raw type");
        }
        return (Class)this.type;
    }

    public final T uncheckedCast(Object value) {
        return this.rawType().cast(value);
    }

    public final TypeRef<? super T> resolveSupertype(Class<?> supertype) {
        Type resolved = TypeRef.resolve(this.type, supertype);
        Validate.requireArgument(resolved != null, "<%s> is not a supertype of <%s>", supertype, this.type);
        return TypeRef.of(Validate.castNonNull(resolved));
    }

    public final List<TypeRef<?>> typeArguments() {
        List<TypeRef<?>> typeArguments = this.lazyTypeArguments;
        if (typeArguments == null) {
            this.lazyTypeArguments = typeArguments = this.computeTypeArguments();
        }
        return typeArguments;
    }

    private List<TypeRef<?>> computeTypeArguments() {
        if (!(this.type instanceof ParameterizedType)) {
            return List.of();
        }
        ArrayList result = new ArrayList();
        for (Type type : ((ParameterizedType)this.type).getActualTypeArguments()) {
            result.add(TypeRef.of(type));
        }
        return Collections.unmodifiableList(result);
    }

    public final boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TypeRef)) {
            return false;
        }
        return this.type.equals(((TypeRef)obj).type);
    }

    public final int hashCode() {
        return 31 * this.type.hashCode();
    }

    public final String toString() {
        return this.type.getTypeName();
    }

    @Deprecated
    @InlineMe(replacement="TypeRef.of(type)", imports={"com.namelessmc.plugin.lib.methanol.TypeRef"})
    public static TypeRef<?> from(Type type) {
        return TypeRef.of(type);
    }

    public static TypeRef<?> of(Type type) {
        return new ExplicitTypeRef(type);
    }

    @Deprecated
    @InlineMe(replacement="TypeRef.of(rawType)", imports={"com.namelessmc.plugin.lib.methanol.TypeRef"})
    public static <U> TypeRef<U> from(Class<U> rawType) {
        return TypeRef.of(rawType);
    }

    public static <U> TypeRef<U> of(Class<U> rawType) {
        return new ExplicitTypeRef(rawType);
    }

    public static <T> TypeRef<? extends T> ofRuntimeType(T instance) {
        return new ExplicitTypeRef(instance.getClass());
    }

    private static Class<?> rawTypeOf(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getRawType();
            Validate.requireArgument(rawType instanceof Class, "ParameterizedType::getRawType of <%s> returned a non-raw type <%s>", type, rawType);
            return (Class)rawType;
        }
        if (type instanceof GenericArrayType) {
            Class<?> rawComponentType = TypeRef.rawTypeOf(((GenericArrayType)type).getGenericComponentType());
            return Array.newInstance(rawComponentType, 0).getClass();
        }
        if (type instanceof TypeVariable) {
            return TypeRef.rawUpperBound(((TypeVariable)type).getBounds());
        }
        if (type instanceof WildcardType) {
            return TypeRef.rawUpperBound(((WildcardType)type).getUpperBounds());
        }
        throw new IllegalArgumentException("Unknown specialization of java.lang.reflect.Type: <" + type + ">");
    }

    private static Class<?> rawUpperBound(Type[] upperBounds) {
        return upperBounds.length > 0 ? TypeRef.rawTypeOf(upperBounds[0]) : Object.class;
    }

    private static @Nullable Type resolve(Type spec, Class<?> supertype) {
        if (spec instanceof Class) {
            Class rawSpec = (Class)spec;
            if (rawSpec.isArray()) {
                Class<?> supertypeComponent = supertype.getComponentType();
                Validate.requireArgument(supertypeComponent != null, "Type specialization <%s> is an array but supertype <%s> isn't", spec, supertype);
                Type resolvedComponent = TypeRef.resolve(rawSpec.getComponentType(), supertypeComponent);
                return resolvedComponent != null ? TypeRef.arrayTypeOf(resolvedComponent) : null;
            }
            return TypeRef.resolve(rawSpec, supertype);
        }
        if (spec instanceof ParameterizedType) {
            return TypeRef.resolve((ParameterizedType)spec, supertype);
        }
        if (spec instanceof GenericArrayType) {
            Class<?> supertypeComponent = supertype.getComponentType();
            Validate.requireArgument(supertypeComponent != null, "Type specialization <%s> is an array but supertype <%s> isn't", spec, supertype);
            Type resolvedComponent = TypeRef.resolve(((GenericArrayType)spec).getGenericComponentType(), supertypeComponent);
            return resolvedComponent != null ? TypeRef.arrayTypeOf(resolvedComponent) : null;
        }
        if (spec instanceof TypeVariable) {
            return TypeRef.resolveFromAny(((TypeVariable)spec).getBounds(), supertype);
        }
        if (spec instanceof WildcardType) {
            return TypeRef.resolveFromAny(((WildcardType)spec).getUpperBounds(), supertype);
        }
        throw new IllegalArgumentException("Unknown specialization of java.lang.reflect.Type: <" + spec + ">");
    }

    private static @Nullable Type resolve(Class<?> spec, Class<?> supertype) {
        if (spec == supertype) {
            return spec;
        }
        if (!supertype.isAssignableFrom(spec)) {
            return null;
        }
        return TypeRef.resolveFromSupertypes(spec, supertype);
    }

    private static @Nullable Type resolve(ParameterizedType spec, Class<?> supertype) {
        Class<?> rawSpec = TypeRef.rawTypeOf(spec);
        if (rawSpec == supertype) {
            return spec;
        }
        if (!supertype.isAssignableFrom(rawSpec)) {
            return null;
        }
        Type resolved = TypeRef.resolveFromSupertypes(rawSpec, supertype);
        return resolved != null ? TypeRef.substitute(spec, resolved) : null;
    }

    private static @Nullable Type resolveFromSupertypes(Class<?> rawSpec, Class<?> supertype) {
        Type resolved = TypeRef.resolveFromAny(rawSpec.getGenericInterfaces(), supertype);
        return resolved != null ? resolved : TypeRef.resolve(rawSpec.getGenericSuperclass(), supertype);
    }

    private static @Nullable Type resolveFromAny(Type[] upperBounds, Class<?> supertype) {
        for (Type bound : upperBounds) {
            Type resolved = TypeRef.resolve(bound, supertype);
            if (resolved == null) continue;
            return resolved;
        }
        return null;
    }

    private static Type substitute(ParameterizedType spec, Type target) {
        Objects.requireNonNull(target);
        if (target instanceof Class) {
            return target;
        }
        if (target instanceof ParameterizedType) {
            ParameterizedType parameterizedTarget = (ParameterizedType)target;
            Type[] arguments = parameterizedTarget.getActualTypeArguments();
            Type[] substitutedArguments = TypeRef.substituteAll(spec, arguments);
            Type owner = parameterizedTarget.getOwnerType();
            Type substitutedOwner = owner != null ? TypeRef.substitute(spec, owner) : null;
            return substitutedArguments != arguments || substitutedOwner != owner ? new ParameterizedTypeImpl(substitutedArguments, substitutedOwner, parameterizedTarget.getRawType()) : target;
        }
        if (target instanceof GenericArrayType) {
            Type substitutedComponentType;
            GenericArrayType arrayTarget = (GenericArrayType)target;
            Type componentType = arrayTarget.getGenericComponentType();
            return componentType != (substitutedComponentType = TypeRef.substitute(spec, componentType)) ? TypeRef.arrayTypeOf(substitutedComponentType) : target;
        }
        if (target instanceof TypeVariable) {
            TypeVariable typeVariableTarget = (TypeVariable)target;
            ParameterizedType currentSpec = spec;
            while (true) {
                int j;
                Class<?> rawCurrentSpec = TypeRef.rawTypeOf(currentSpec);
                if (typeVariableTarget.getGenericDeclaration() == rawCurrentSpec && (j = TypeRef.indexOf(rawCurrentSpec.getTypeParameters(), typeVariableTarget)) >= 0) {
                    return currentSpec.getActualTypeArguments()[j];
                }
                Type currentSpecOwner = currentSpec.getOwnerType();
                if (!(currentSpecOwner instanceof ParameterizedType)) break;
                currentSpec = (ParameterizedType)currentSpecOwner;
            }
            return target;
        }
        if (target instanceof WildcardType) {
            WildcardType wildcardTarget = (WildcardType)target;
            Type[] upperBounds = wildcardTarget.getUpperBounds();
            Type[] substitutedUpperBounds = TypeRef.substituteAll(spec, upperBounds);
            Type[] lowerBounds = wildcardTarget.getLowerBounds();
            Type[] substitutedLowerBounds = TypeRef.substituteAll(spec, lowerBounds);
            return substitutedUpperBounds != upperBounds || substitutedLowerBounds != lowerBounds ? new WildcardTypeImpl(substitutedUpperBounds, substitutedLowerBounds) : target;
        }
        throw new IllegalArgumentException("Unknown specialization of java.lang.reflect.Type: <" + target + ">");
    }

    private static Type[] substituteAll(ParameterizedType spec, Type[] types) {
        Type[] substitutedTypes = null;
        for (int i = 0; i < types.length; ++i) {
            Type type = types[i];
            Type substitutedType = TypeRef.substitute(spec, type);
            if (substitutedType == type) continue;
            if (substitutedTypes == null) {
                substitutedTypes = (Type[])Arrays.copyOf(types, types.length, Type[].class);
            }
            substitutedTypes[i] = substitutedType;
        }
        return substitutedTypes != null ? substitutedTypes : types;
    }

    private static Type arrayTypeOf(Type componentType) {
        return componentType instanceof Class ? Array.newInstance((Class)componentType, 0).getClass() : new GenericArrayTypeImpl(componentType);
    }

    private static <T> int indexOf(T[] array, T element) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(element)) continue;
            return i;
        }
        return -1;
    }

    private static Type[] nonNullCopy(Type[] types) {
        Type[] copy;
        for (Type type : copy = Arrays.copyOf(types, types.length)) {
            Objects.requireNonNull(type);
        }
        return copy;
    }

    private static final class WildcardTypeImpl
    implements WildcardType {
        private final Type[] upperBounds;
        private final Type[] lowerBounds;

        WildcardTypeImpl(Type[] upperBounds, Type[] lowerBounds) {
            this.upperBounds = TypeRef.nonNullCopy(upperBounds);
            this.lowerBounds = TypeRef.nonNullCopy(lowerBounds);
            Validate.requireArgument(upperBounds.length > 0 && (upperBounds[0] == Object.class || lowerBounds.length == 0), "Inconsistent bounds for a WildcardType");
        }

        @Override
        public Type[] getUpperBounds() {
            return (Type[])this.upperBounds.clone();
        }

        @Override
        public Type[] getLowerBounds() {
            return (Type[])this.lowerBounds.clone();
        }

        public String toString() {
            Type[] boundsToStringify;
            String prefix;
            if (this.lowerBounds.length > 0) {
                prefix = "? super ";
                boundsToStringify = this.lowerBounds;
            } else {
                if (this.upperBounds[0].equals(Object.class)) {
                    return "?";
                }
                prefix = "? extends ";
                boundsToStringify = this.upperBounds;
            }
            StringJoiner joiner = new StringJoiner(" & ");
            for (Type bound : boundsToStringify) {
                joiner.add(bound.getTypeName());
            }
            return prefix + joiner;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof WildcardType)) {
                return false;
            }
            WildcardType other = (WildcardType)obj;
            return Arrays.equals(this.upperBounds, other.getUpperBounds()) && Arrays.equals(this.lowerBounds, other.getLowerBounds());
        }

        public int hashCode() {
            return Arrays.hashCode(this.upperBounds) ^ Arrays.hashCode(this.lowerBounds);
        }
    }

    private static final class ParameterizedTypeImpl
    implements ParameterizedType {
        private final Type[] typeArguments;
        private final @Nullable Type ownerType;
        private final Class<?> rawType;

        ParameterizedTypeImpl(Type[] typeArguments, @Nullable Type ownerType, Type rawType) {
            this.typeArguments = TypeRef.nonNullCopy(typeArguments);
            this.ownerType = ownerType;
            Validate.requireArgument(Objects.requireNonNull(rawType) instanceof Class, "<%s> is not a raw type", rawType);
            this.rawType = (Class)rawType;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return (Type[])this.typeArguments.clone();
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        public @Nullable Type getOwnerType() {
            return this.ownerType;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.ownerType != null) {
                sb.append(this.ownerType.getTypeName()).append("$").append(this.rawType.getSimpleName());
            } else {
                sb.append(this.rawType.getName());
            }
            if (this.typeArguments.length > 0) {
                StringJoiner joiner = new StringJoiner(", ", "<", ">").setEmptyValue("");
                for (Type type : this.typeArguments) {
                    joiner.add(type.getTypeName());
                }
                sb.append(joiner);
            }
            return sb.toString();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType other = (ParameterizedType)obj;
            return Arrays.equals(this.typeArguments, other.getActualTypeArguments()) && Objects.equals(this.ownerType, other.getOwnerType()) && this.rawType.equals(other.getRawType());
        }

        public int hashCode() {
            return Arrays.hashCode(this.typeArguments) ^ Objects.hash(this.ownerType) ^ this.rawType.hashCode();
        }
    }

    private static final class GenericArrayTypeImpl
    implements GenericArrayType {
        private final Type componentType;

        GenericArrayTypeImpl(Type componentType) {
            this.componentType = Objects.requireNonNull(componentType);
        }

        @Override
        public Type getGenericComponentType() {
            return this.componentType;
        }

        public int hashCode() {
            return this.componentType.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof GenericArrayType)) {
                return false;
            }
            return this.componentType.equals(((GenericArrayType)obj).getGenericComponentType());
        }

        public String toString() {
            return this.componentType.getTypeName() + "[]";
        }
    }

    private static final class ExplicitTypeRef<T>
    extends TypeRef<T> {
        ExplicitTypeRef(Type type) {
            super(Objects.requireNonNull(type));
        }
    }
}

