/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.methanol;

import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.MonotonicNonNull;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.Nullable;
import com.namelessmc.plugin.lib.errorprone.annotations.concurrent.GuardedBy;
import com.namelessmc.plugin.lib.methanol.internal.Utils;
import com.namelessmc.plugin.lib.methanol.internal.Validate;
import com.namelessmc.plugin.lib.methanol.internal.flow.AbstractQueueSubscription;
import com.namelessmc.plugin.lib.methanol.internal.flow.FlowSupport;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.net.http.HttpRequest;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class WritableBodyPublisher
implements HttpRequest.BodyPublisher,
Flushable,
AutoCloseable {
    private static final VarHandle STATE;
    private static final ByteBuffer CLOSED_SENTINEL;
    private static final int DEFAULT_BUFFER_SIZE;
    private final Lock writeLock = new ReentrantLock();
    private final ConcurrentLinkedQueue<ByteBuffer> pipe = new ConcurrentLinkedQueue();
    private final AtomicBoolean subscribed = new AtomicBoolean();
    private final int bufferSize;
    private State state = Initial.INSTANCE;
    @GuardedBy(value="writeLock")
    private @Nullable ByteBuffer sinkBuffer;
    private @MonotonicNonNull WritableByteChannel lazyChannel;
    private @MonotonicNonNull OutputStream lazyOutputStream;
    private volatile boolean submittedSentinel;

    private WritableBodyPublisher(int bufferSize) {
        Validate.requireArgument(bufferSize > 0, "non-positive buffer size");
        this.bufferSize = bufferSize;
    }

    public WritableByteChannel byteChannel() {
        WritableByteChannel channel = this.lazyChannel;
        if (channel == null) {
            this.lazyChannel = channel = new SinkChannel();
        }
        return channel;
    }

    public OutputStream outputStream() {
        OutputStream outputStream = this.lazyOutputStream;
        if (outputStream == null) {
            this.lazyOutputStream = outputStream = new SinkOutputStream(this.byteChannel());
        }
        return outputStream;
    }

    public void closeExceptionally(Throwable exception) {
        State prevState;
        State currentState;
        do {
            if ((currentState = this.state) instanceof Closed) {
                FlowSupport.onDroppedException(exception);
                return;
            }
            prevState = currentState;
        } while ((!(currentState instanceof Subscribed) || !STATE.compareAndSet(this, currentState, Closed.normally())) && (currentState != Initial.INSTANCE || !STATE.compareAndSet(this, currentState, Closed.exceptionally(exception))));
        if (prevState instanceof Subscribed) {
            ((Subscribed)prevState).subscription.fireOrKeepAliveOnError(exception);
        }
    }

    @Override
    public void close() {
        State prevState;
        State currentState;
        do {
            if ((currentState = this.state) instanceof Closed) {
                return;
            }
            prevState = currentState;
        } while (!STATE.compareAndSet(this, currentState, Closed.normally()));
        this.submitSentinel();
        if (prevState instanceof Subscribed) {
            ((Subscribed)prevState).subscription.fireOrKeepAlive();
        }
    }

    public boolean isClosed() {
        return this.state instanceof Closed;
    }

    @Override
    public void flush() {
        Validate.requireState(!this.isClosed(), "closed");
        this.fireOrKeepAliveOnNextIf(this.flushBuffer());
    }

    @Override
    public long contentLength() {
        return -1L;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
        if (this.subscribed.compareAndSet(false, true)) {
            SubscriptionImpl subscription = new SubscriptionImpl(subscriber);
            if (STATE.compareAndSet(this, Initial.INSTANCE, new Subscribed(subscription))) {
                subscription.fireOrKeepAlive();
            } else {
                State currentState = this.state;
                if (currentState instanceof Closed) {
                    Throwable exception = ((Closed)currentState).exception;
                    if (exception != null) {
                        subscription.fireOrKeepAliveOnError(exception);
                    } else {
                        this.submitSentinel();
                        subscription.fireOrKeepAlive();
                    }
                }
            }
        } else {
            FlowSupport.rejectMulticast(subscriber);
        }
    }

    private void fireOrKeepAliveOnNextIf(boolean condition) {
        State currentState;
        if (condition && (currentState = this.state) instanceof Subscribed) {
            ((Subscribed)currentState).subscription.fireOrKeepAliveOnNext();
        }
    }

    private boolean flushBuffer() {
        this.writeLock.lock();
        try {
            boolean bl = this.unguardedFlushBuffer();
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @GuardedBy(value="writeLock")
    private boolean unguardedFlushBuffer() {
        ByteBuffer buffer = this.sinkBuffer;
        if (buffer != null && buffer.position() > 0) {
            this.sinkBuffer = null;
            this.pipe.add(buffer.flip().asReadOnlyBuffer());
            return true;
        }
        return false;
    }

    private void submitSentinel() {
        if (!this.submittedSentinel) {
            this.writeLock.lock();
            try {
                if (!this.submittedSentinel) {
                    this.submittedSentinel = true;
                    this.flushBuffer();
                    this.pipe.add(CLOSED_SENTINEL);
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    public static WritableBodyPublisher create() {
        return new WritableBodyPublisher(DEFAULT_BUFFER_SIZE);
    }

    public static WritableBodyPublisher create(int bufferSize) {
        return new WritableBodyPublisher(bufferSize);
    }

    static {
        try {
            STATE = MethodHandles.lookup().findVarHandle(WritableBodyPublisher.class, "state", State.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
        CLOSED_SENTINEL = ByteBuffer.allocate(0);
        DEFAULT_BUFFER_SIZE = Utils.BUFFER_SIZE;
    }

    private final class SubscriptionImpl
    extends AbstractQueueSubscription<ByteBuffer> {
        SubscriptionImpl(Flow.Subscriber<? super ByteBuffer> downstream) {
            super(downstream, FlowSupport.SYNC_EXECUTOR, WritableBodyPublisher.this.pipe, CLOSED_SENTINEL);
        }

        @Override
        protected void abort(boolean flowInterrupted) {
            WritableBodyPublisher.this.pipe.clear();
            if (flowInterrupted) {
                State currentState;
                while ((currentState = WritableBodyPublisher.this.state) instanceof Subscribed && !STATE.compareAndSet(WritableBodyPublisher.this, currentState, Closed.normally())) {
                }
                return;
            }
        }
    }

    private final class SinkOutputStream
    extends OutputStream {
        private final OutputStream out;

        SinkOutputStream(WritableByteChannel channel) {
            this.out = Channels.newOutputStream(channel);
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            try {
                WritableBodyPublisher.this.flush();
            }
            catch (IllegalStateException e) {
                throw new IOException("closed", e);
            }
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }

    private final class SinkChannel
    implements WritableByteChannel {
        SinkChannel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int write(ByteBuffer src) throws ClosedChannelException {
            Objects.requireNonNull(src);
            if (WritableBodyPublisher.this.isClosed()) {
                throw new ClosedChannelException();
            }
            if (!src.hasRemaining()) {
                return 0;
            }
            int written = 0;
            boolean signalsAvailable = false;
            WritableBodyPublisher.this.writeLock.lock();
            try {
                ByteBuffer buffer = WritableBodyPublisher.this.sinkBuffer;
                do {
                    if (buffer == null) {
                        buffer = ByteBuffer.allocate(WritableBodyPublisher.this.bufferSize);
                    }
                    written += Utils.copyRemaining(src, buffer);
                    if (buffer.hasRemaining()) continue;
                    WritableBodyPublisher.this.pipe.add(buffer.flip().asReadOnlyBuffer());
                    signalsAvailable = true;
                    buffer = null;
                } while (src.hasRemaining() && this.isOpen());
                if (WritableBodyPublisher.this.isClosed()) {
                    WritableBodyPublisher.this.sinkBuffer = null;
                    if (written <= 0) {
                        throw new AsynchronousCloseException();
                    }
                    int n = written;
                    return n;
                }
                WritableBodyPublisher.this.sinkBuffer = buffer;
            }
            finally {
                WritableBodyPublisher.this.writeLock.unlock();
            }
            WritableBodyPublisher.this.fireOrKeepAliveOnNextIf(signalsAvailable);
            return written;
        }

        @Override
        public boolean isOpen() {
            return !WritableBodyPublisher.this.isClosed();
        }

        @Override
        public void close() {
            WritableBodyPublisher.this.close();
        }
    }

    private static final class Closed
    implements State {
        static final Closed NORMALLY = new Closed(null);
        final @Nullable Throwable exception;

        Closed(@Nullable Throwable exception) {
            this.exception = exception;
        }

        static Closed normally() {
            return NORMALLY;
        }

        static Closed exceptionally(Throwable exception) {
            return new Closed(Objects.requireNonNull(exception));
        }
    }

    private static final class Subscribed
    implements State {
        final SubscriptionImpl subscription;

        Subscribed(SubscriptionImpl subscription) {
            this.subscription = Objects.requireNonNull(subscription);
        }
    }

    private static enum Initial implements State
    {
        INSTANCE;

    }

    private static interface State {
    }
}

