/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.methanol.internal.cache;

import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.Nullable;
import com.namelessmc.plugin.lib.methanol.HttpStatus;
import com.namelessmc.plugin.lib.methanol.Methanol;
import com.namelessmc.plugin.lib.methanol.MutableRequest;
import com.namelessmc.plugin.lib.methanol.ResponseBuilder;
import com.namelessmc.plugin.lib.methanol.internal.Utils;
import com.namelessmc.plugin.lib.methanol.internal.cache.ChainAdapter;
import com.namelessmc.plugin.lib.methanol.internal.extensions.Handlers;
import com.namelessmc.plugin.lib.methanol.internal.flow.FlowSupport;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicInteger;

public final class RedirectingInterceptor
implements Methanol.Interceptor {
    private static final int DEFAULT_MAX_REDIRECTS = 5;
    private static final int MAX_REDIRECTS = Integer.getInteger("jdk.httpclient.redirects.retrylimit", 5);
    private final HttpClient.Redirect policy;
    private final Executor handlerExecutor;

    public RedirectingInterceptor(HttpClient.Redirect policy, Executor handlerExecutor) {
        this.policy = Objects.requireNonNull(policy);
        this.handlerExecutor = Objects.requireNonNull(handlerExecutor);
    }

    @Override
    public <T> HttpResponse<T> intercept(HttpRequest request, Methanol.Interceptor.Chain<T> chain) throws IOException, InterruptedException {
        return this.policy == HttpClient.Redirect.NEVER ? chain.forward(request) : Utils.get(this.exchange(request, chain, false));
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> interceptAsync(HttpRequest request, Methanol.Interceptor.Chain<T> chain) {
        return this.policy == HttpClient.Redirect.NEVER ? chain.forwardAsync(request) : this.exchange(request, chain, true);
    }

    private <T> CompletableFuture<HttpResponse<T>> exchange(HttpRequest request, Methanol.Interceptor.Chain<T> chain, boolean async) {
        Methanol.Interceptor.Chain<Flow.Publisher<List<ByteBuffer>>> publisherChain = Handlers.toPublisherChain(chain, this.handlerExecutor);
        return new Exchange(request, async ? ChainAdapter.async(publisherChain) : ChainAdapter.syncOnCaller(publisherChain)).exchange().thenCompose(response -> Handlers.handleAsync(response, chain.bodyHandler(), async ? this.handlerExecutor : FlowSupport.SYNC_EXECUTOR));
    }

    private final class Exchange {
        private final AtomicInteger redirectCount = new AtomicInteger();
        private final HttpRequest request;
        private final ChainAdapter chainAdapter;

        Exchange(HttpRequest request, ChainAdapter chainAdapter) {
            this.request = request;
            this.chainAdapter = chainAdapter;
        }

        CompletableFuture<HttpResponse<Flow.Publisher<List<ByteBuffer>>>> exchange() {
            return this.chainAdapter.forward(this.request).thenCompose(this::exchange);
        }

        CompletableFuture<HttpResponse<Flow.Publisher<List<ByteBuffer>>>> exchange(HttpResponse<Flow.Publisher<List<ByteBuffer>>> response) {
            HttpRequest redirectRequest = this.createRedirectRequest(response);
            if (redirectRequest == null || this.redirectCount.incrementAndGet() >= MAX_REDIRECTS) {
                return CompletableFuture.completedFuture(response);
            }
            Handlers.handleAsync(response, HttpResponse.BodyHandlers.discarding(), RedirectingInterceptor.this.handlerExecutor);
            return this.chainAdapter.forward(redirectRequest).thenCompose(redirectResponse -> this.exchange(ResponseBuilder.from(redirectResponse).previousResponse(ResponseBuilder.from(response).dropBody().build()).build()));
        }

        public @Nullable HttpRequest createRedirectRequest(HttpResponse<?> response) {
            if (RedirectingInterceptor.this.policy == HttpClient.Redirect.NEVER) {
                return null;
            }
            int statusCode = response.statusCode();
            if (this.isRedirecting(statusCode) && statusCode != 304) {
                URI redirectUri = this.redirectUri(response.headers());
                String redirectMethod = this.redirectMethod(response.statusCode());
                if (this.canRedirectTo(redirectUri)) {
                    boolean retainBody = statusCode != 303 && this.request.method().equalsIgnoreCase(redirectMethod);
                    return MutableRequest.copyOf(this.request).uri(redirectUri).method(redirectMethod, this.request.bodyPublisher().filter(__ -> retainBody).orElseGet(HttpRequest.BodyPublishers::noBody));
                }
            }
            return null;
        }

        private URI redirectUri(HttpHeaders responseHeaders) {
            return responseHeaders.firstValue("Location").map(this.request.uri()::resolve).orElseThrow(() -> new UncheckedIOException(new IOException("Invalid redirection")));
        }

        private String redirectMethod(int statusCode) {
            String originalMethod = this.request.method();
            switch (statusCode) {
                case 301: 
                case 302: {
                    return originalMethod.equalsIgnoreCase("POST") ? "GET" : originalMethod;
                }
                case 303: {
                    return "GET";
                }
            }
            return originalMethod;
        }

        private boolean canRedirectTo(URI redirectUri) {
            String oldScheme = this.request.uri().getScheme();
            String newScheme = redirectUri.getScheme();
            switch (RedirectingInterceptor.this.policy) {
                case ALWAYS: {
                    return true;
                }
                case NEVER: {
                    return false;
                }
                case NORMAL: {
                    return newScheme.equalsIgnoreCase(oldScheme) || newScheme.equalsIgnoreCase("https");
                }
            }
            throw new AssertionError((Object)("Unexpected policy: " + RedirectingInterceptor.this.policy));
        }

        private boolean isRedirecting(int statusCode) {
            if (!HttpStatus.isRedirection(statusCode) || statusCode > 308) {
                return false;
            }
            switch (statusCode) {
                case 300: 
                case 304: 
                case 305: 
                case 306: {
                    return false;
                }
            }
            return true;
        }
    }
}

