/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.methanol.internal.extensions;

import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.Nullable;
import com.namelessmc.plugin.lib.errorprone.annotations.concurrent.GuardedBy;
import com.namelessmc.plugin.lib.methanol.internal.extensions.ForwardingBodySubscriber;
import com.namelessmc.plugin.lib.methanol.internal.flow.AbstractQueueSubscription;
import com.namelessmc.plugin.lib.methanol.internal.flow.FlowSupport;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;

public final class HttpResponsePublisher<T>
implements Flow.Publisher<HttpResponse<T>> {
    private final AtomicBoolean subscribed = new AtomicBoolean();
    private final HttpClient client;
    private final HttpRequest request;
    private final HttpResponse.BodyHandler<T> bodyHandler;
    private final @Nullable Function<HttpRequest, @Nullable HttpResponse.BodyHandler<T>> pushPromiseHandler;
    private final Executor executor;

    public HttpResponsePublisher(HttpClient client, HttpRequest request, HttpResponse.BodyHandler<T> bodyHandler, @Nullable Function<HttpRequest, @Nullable HttpResponse.BodyHandler<T>> pushPromiseMapper, Executor executor) {
        this.client = Objects.requireNonNull(client);
        this.request = Objects.requireNonNull(request);
        this.bodyHandler = Objects.requireNonNull(bodyHandler);
        this.pushPromiseHandler = pushPromiseMapper;
        this.executor = Objects.requireNonNull(executor);
    }

    @Override
    public void subscribe(Flow.Subscriber<? super HttpResponse<T>> subscriber) {
        if (this.subscribed.compareAndSet(false, true)) {
            new SubscriptionImpl(subscriber, this).fireOrKeepAlive();
        } else {
            FlowSupport.rejectMulticast(subscriber);
        }
    }

    private static final class NotifyingBodySubscriber<R>
    extends ForwardingBodySubscriber<R> {
        private final Runnable callback;

        NotifyingBodySubscriber(HttpResponse.BodySubscriber<R> downstream, Runnable onComplete) {
            super(downstream);
            this.callback = onComplete;
        }

        @Override
        public void onComplete() {
            super.onComplete();
            this.callback.run();
        }
    }

    private static final class SubscriptionImpl<V>
    extends AbstractQueueSubscription<HttpResponse<V>> {
        private final Lock lock = new ReentrantLock();
        private final HttpClient client;
        private final HttpRequest initialRequest;
        private final HttpResponse.BodyHandler<V> handler;
        private final @Nullable HttpResponse.PushPromiseHandler<V> pushPromiseHandler;
        @GuardedBy(value="lock")
        private int ongoing;
        @GuardedBy(value="lock")
        private boolean isInitialResponseBodyComplete;
        private boolean isInitialRequestSent;

        SubscriptionImpl(Flow.Subscriber<? super HttpResponse<V>> downstream, HttpResponsePublisher<V> publisher) {
            super(downstream, publisher.executor);
            this.client = publisher.client;
            this.initialRequest = publisher.request;
            this.handler = publisher.bodyHandler;
            this.pushPromiseHandler = publisher.pushPromiseHandler != null ? new SubscriptionPushPromiseHandler(publisher.pushPromiseHandler) : null;
        }

        @Override
        protected long emit(Flow.Subscriber<? super HttpResponse<V>> downstream, long emit) {
            if (emit > 0L && !this.isInitialRequestSent) {
                this.isInitialRequestSent = true;
                try {
                    this.incrementOngoing();
                    this.client.sendAsync(this.initialRequest, this::notifyOnBodyCompletion, this.pushPromiseHandler).whenComplete(this::onResponse);
                }
                catch (Throwable t) {
                    this.cancelOnError(downstream, t, true);
                    return 0L;
                }
            }
            return super.emit(downstream, emit);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onResponse(HttpResponse<V> response, Throwable exception) {
            if (exception != null) {
                this.fireOrKeepAliveOnError(exception);
            } else {
                boolean isComplete;
                this.lock.lock();
                try {
                    isComplete = this.ongoing == 1 && this.isInitialResponseBodyComplete;
                }
                finally {
                    this.lock.unlock();
                }
                if (isComplete) {
                    this.submitAndComplete(response);
                } else {
                    boolean isCompleteAfterSubmit;
                    this.submit(response);
                    this.lock.lock();
                    try {
                        int ongoingAfterDecrement = --this.ongoing;
                        isCompleteAfterSubmit = ongoingAfterDecrement == 0 && this.isInitialResponseBodyComplete;
                    }
                    finally {
                        this.lock.unlock();
                    }
                    if (isCompleteAfterSubmit) {
                        this.complete();
                    }
                }
            }
        }

        private void onInitialResponseBodyCompletion() {
            boolean isComplete;
            this.lock.lock();
            try {
                this.isInitialResponseBodyComplete = true;
                isComplete = this.ongoing == 0;
            }
            finally {
                this.lock.unlock();
            }
            if (isComplete) {
                this.complete();
            } else {
                this.fireOrKeepAlive();
            }
        }

        private HttpResponse.BodySubscriber<V> notifyOnBodyCompletion(HttpResponse.ResponseInfo info) {
            return new NotifyingBodySubscriber<V>(this.handler.apply(info), this::onInitialResponseBodyCompletion);
        }

        private void incrementOngoing() {
            this.lock.lock();
            try {
                ++this.ongoing;
            }
            finally {
                this.lock.unlock();
            }
        }

        private class SubscriptionPushPromiseHandler
        implements HttpResponse.PushPromiseHandler<V> {
            private final Function<HttpRequest, @Nullable HttpResponse.BodyHandler<V>> acceptor;

            SubscriptionPushPromiseHandler(Function<HttpRequest, HttpResponse.BodyHandler<V>> acceptor) {
                this.acceptor = acceptor;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void applyPushPromise(HttpRequest initiatingRequest, HttpRequest pushPromiseRequest, Function<HttpResponse.BodyHandler<V>, CompletableFuture<HttpResponse<V>>> acceptor) {
                boolean localIsInitialResponseBodyComplete;
                SubscriptionImpl.this.lock.lock();
                try {
                    localIsInitialResponseBodyComplete = SubscriptionImpl.this.isInitialResponseBodyComplete;
                }
                finally {
                    SubscriptionImpl.this.lock.unlock();
                }
                if (localIsInitialResponseBodyComplete) {
                    SubscriptionImpl.this.fireOrKeepAliveOnError(new IllegalStateException("Receiving push promise after initial response body has been received: " + pushPromiseRequest));
                } else if (!SubscriptionImpl.this.isCancelled() && !SubscriptionImpl.this.hasPendingErrors()) {
                    this.applyPushPromise(pushPromiseRequest, acceptor);
                }
            }

            private void applyPushPromise(HttpRequest pushPromiseRequest, Function<HttpResponse.BodyHandler<V>, CompletableFuture<HttpResponse<V>>> acceptor) {
                HttpResponse.BodyHandler pushedResponseBodyHandler;
                try {
                    pushedResponseBodyHandler = this.acceptor.apply(pushPromiseRequest);
                }
                catch (Throwable t) {
                    SubscriptionImpl.this.fireOrKeepAliveOnError(t);
                    return;
                }
                if (pushedResponseBodyHandler != null) {
                    SubscriptionImpl.this.incrementOngoing();
                    acceptor.apply(pushedResponseBodyHandler).whenComplete((x$0, x$1) -> SubscriptionImpl.this.onResponse(x$0, (Throwable)x$1));
                }
            }
        }
    }
}

