/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.methanol.internal.flow;

import com.namelessmc.plugin.lib.methanol.internal.concurrent.SerialExecutor;
import com.namelessmc.plugin.lib.methanol.internal.flow.FlowSupport;
import com.namelessmc.plugin.lib.methanol.internal.flow.ForwardingSubscriber;
import java.util.Objects;
import java.util.concurrent.Flow;

public abstract class SerializedForwardingSubscriber<T>
extends ForwardingSubscriber<T> {
    private final SerialExecutor serialExecutor = new SerialExecutor(FlowSupport.SYNC_EXECUTOR);
    private boolean done;

    protected SerializedForwardingSubscriber() {
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        Objects.requireNonNull(subscription);
        this.serialExecutor.execute(() -> super.onSubscribe(subscription));
    }

    @Override
    public void onNext(T item) {
        Objects.requireNonNull(item);
        this.serialExecutor.execute(() -> {
            if (!this.done) {
                super.onNext(item);
            }
        });
    }

    @Override
    public void onError(Throwable throwable) {
        Objects.requireNonNull(throwable);
        this.serialExecutor.execute(() -> {
            if (!this.done) {
                this.done = true;
                super.onError(throwable);
            }
        });
    }

    @Override
    public void onComplete() {
        this.serialExecutor.execute(() -> {
            if (!this.done) {
                this.done = true;
                super.onComplete();
            }
        });
    }
}

