/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.methanol.internal.spi;

import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.Nullable;
import com.namelessmc.plugin.lib.methanol.internal.concurrent.Lazy;
import java.util.List;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.stream.Collectors;

public final class ServiceProviders<S> {
    private static final System.Logger logger = System.getLogger(ServiceProviders.class.getName());
    private final Lazy<List<S>> providers;

    public ServiceProviders(Class<S> service) {
        Objects.requireNonNull(service);
        this.providers = Lazy.of(() -> ServiceProviders.loadProviders(service));
    }

    public List<S> get() {
        return this.providers.get();
    }

    private static <U> List<U> loadProviders(Class<U> service) {
        return ServiceLoader.load(service, service.getClassLoader()).stream().map(ServiceProviders::tryGet).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
    }

    private static <U> @Nullable U tryGet(ServiceLoader.Provider<U> provider) {
        try {
            return provider.get();
        }
        catch (ServiceConfigurationError error) {
            logger.log(System.Logger.Level.WARNING, "Provider <" + provider.type() + "> will be ignored as it couldn't be instantiated", (Throwable)error);
            return null;
        }
    }
}

