/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.nameless-api;

import com.namelessmc.plugin.lib.checker-framework.checker.formatter.qual.UnknownFormat;
import com.namelessmc.plugin.lib.checker-framework.checker.initialization.qual.Initialized;
import com.namelessmc.plugin.lib.checker-framework.checker.nonempty.qual.UnknownNonEmpty;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.NonNull;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.Nullable;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.UnknownKeyFor;
import com.namelessmc.plugin.lib.checker-framework.checker.optional.qual.MaybePresent;
import com.namelessmc.plugin.lib.checker-framework.checker.regex.qual.UnknownRegex;
import com.namelessmc.plugin.lib.checker-framework.common.aliasing.qual.MaybeAliased;
import com.namelessmc.plugin.lib.checker-framework.common.aliasing.qual.MaybeLeaked;
import com.namelessmc.plugin.lib.gson.Gson;
import com.namelessmc.plugin.lib.gson.JsonObject;
import com.namelessmc.plugin.lib.gson.JsonParser;
import com.namelessmc.plugin.lib.gson.JsonSyntaxException;
import com.namelessmc.plugin.lib.guava.base.Ascii;
import com.namelessmc.plugin.lib.guava.base.Preconditions;
import com.namelessmc.plugin.lib.guava.io.ByteStreams;
import com.namelessmc.plugin.lib.methanol.Methanol;
import com.namelessmc.plugin.lib.methanol.MutableRequest;
import com.namelessmc.plugin.lib.nameless-api.exception.ApiError;
import com.namelessmc.plugin.lib.nameless-api.exception.ApiException;
import com.namelessmc.plugin.lib.nameless-api.exception.NamelessException;
import com.namelessmc.plugin.lib.nameless-api.logger.ApiLogger;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class RequestHandler {
    private static final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat int RETRIES = 2;
    private final @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat URL apiUrl;
    private final @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Methanol httpClient;
    private final @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat ApiLogger debugLogger;
    private final @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Gson gson;
    private final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat int responseLengthLimit;

    RequestHandler(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat URL apiUrl, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Methanol httpClient, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Gson gson, @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat ApiLogger debugLogger, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat int responseLengthLimit) {
        this.apiUrl = Objects.requireNonNull(apiUrl, "API URL is null");
        this.httpClient = Objects.requireNonNull(httpClient, "http client is null");
        this.gson = gson;
        this.debugLogger = debugLogger;
        this.responseLengthLimit = responseLengthLimit;
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Gson gson() {
        return this.gson;
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat JsonObject post(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String route, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat JsonObject postData) throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        return this.makeConnection(route, postData, 2);
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat JsonObject get(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String route, Object ... parameters) throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        StringBuilder urlBuilder = new StringBuilder(route);
        if (parameters.length > 0) {
            if (parameters.length % 2 != 0) {
                String paramString = Arrays.stream(parameters).map(Objects::toString).collect(Collectors.joining("|"));
                throw new IllegalArgumentException(String.format("Parameter string varargs array length must be even (length is %s - %s)", parameters.length, paramString));
            }
            for (int i = 0; i < parameters.length; ++i) {
                Object param = parameters[i];
                if (i % 2 == 0) {
                    if (param == null) {
                        throw new IllegalArgumentException("Parameter keys must never be null, only values may be null");
                    }
                    urlBuilder.append("&");
                    urlBuilder.append(param);
                    continue;
                }
                if (param == null) continue;
                urlBuilder.append("=");
                urlBuilder.append(URLEncoder.encode(param.toString(), StandardCharsets.UTF_8));
            }
        }
        return this.makeConnection(urlBuilder.toString(), null, 2);
    }

    private void debug(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Supplier<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String> messageSupplier) {
        if (this.debugLogger != null) {
            this.debugLogger.log(messageSupplier.get());
        }
    }

    private @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat JsonObject makeConnection(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String route, @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat JsonObject postBody, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat int retries) throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        JsonObject json;
        String responseBody;
        int statusCode;
        Preconditions.checkArgument(!route.startsWith("/"), "Route must not start with a slash");
        URI uri = URI.create(String.valueOf(this.apiUrl) + route);
        if (uri.getHost() == null) {
            throw new NamelessException("URI has empty host, does it contain invalid characters? Please note that although underscores are legal in domain names, the Java URI class (and the Java HttpClient) does not accept them, because it uses the specification for 'host names' not 'domain names'.");
        }
        MutableRequest request = MutableRequest.create(uri);
        this.debug(() -> "Making connection " + (postBody != null ? "POST" : "GET") + " to " + String.valueOf(request.uri()));
        long requestStartTime = System.currentTimeMillis();
        if (postBody != null) {
            byte[] postBytes = this.gson.toJson(postBody).getBytes(StandardCharsets.UTF_8);
            request.POST(HttpRequest.BodyPublishers.ofByteArray(postBytes));
            request.header("Content-Type", "application/json");
            this.debug(() -> "POST request body:\n" + new String(postBytes, StandardCharsets.UTF_8));
        } else {
            request.GET();
        }
        request.header("Accept", "application/json");
        try {
            HttpResponse<InputStream> httpResponse = this.httpClient.send((HttpRequest)request, HttpResponse.BodyHandlers.ofInputStream());
            statusCode = httpResponse.statusCode();
            responseBody = this.getBodyAsString(httpResponse);
        }
        catch (IOException e) {
            @Nullable String exceptionMessage = e.getMessage();
            StringBuilder message = new StringBuilder();
            message.append("Network connection error (not a Nameless issue). ");
            message.append(e.getClass().getSimpleName());
            message.append(": ");
            message.append(exceptionMessage);
            if (exceptionMessage != null) {
                if (e.getMessage() != null && e.getMessage().contains("GOAWAY received")) {
                    if (retries > 0) {
                        this.debug(() -> "Retrying after received GOAWAY");
                        return this.makeConnection(route, postBody, retries - 1);
                    }
                    message.append("Already retried after GOAWAY multiple times, your web server is probably down.");
                } else if (exceptionMessage.contains("unable to find valid certification path to requested target")) {
                    message.append("\nHINT: Your HTTPS certificate is probably valid, but is it complete? Ensure your website uses a valid *full chain* SSL/TLS certificate.");
                } else if (exceptionMessage.contains("No subject alternative DNS name matching")) {
                    message.append("\nHINT: Is your HTTPS certificate valid? Is it for the correct domain?");
                } else if (exceptionMessage.contains("Connect timed out")) {
                    message.append("\nHINT: Is a webserver running at the provided domain? Are we blocked by a firewall? Is your webserver fast enough?");
                } else if (exceptionMessage.contains("Connection refused")) {
                    message.append("\nHINT: Is the domain correct? Is your webserver running? Are we blocked by a firewall?");
                } else if (exceptionMessage.contains("timed out")) {
                    message.append("\nHINT: The website responded too slow, no response after waiting for ");
                    message.append((System.currentTimeMillis() - requestStartTime) / 1000L);
                    message.append(" seconds.");
                }
            }
            throw new NamelessException(message.toString(), e);
        }
        catch (InterruptedException e) {
            throw new NamelessException("In-progress request was aborted", e);
        }
        this.debug(() -> "Website response body, after " + (System.currentTimeMillis() - requestStartTime) + "ms:\n" + RequestHandler.regularAsciiOnly(responseBody));
        if (responseBody.length() == 0) {
            if (statusCode == 301 || statusCode == 302 || statusCode == 303 || statusCode == 307 || statusCode == 308) {
                throw new NamelessException("Website returned a redirect. Please ensure your URL is correct, paying attention to whether it should use HTTP or HTTPS, or whether it should or should not contain 'www.'.");
            }
            throw new NamelessException("Website returned empty response with status code " + statusCode);
        }
        try {
            json = JsonParser.parseString(responseBody).getAsJsonObject();
        }
        catch (JsonSyntaxException | IllegalStateException e) {
            StringBuilder message = new StringBuilder();
            message.append("Website returned invalid response with code ");
            message.append(statusCode);
            message.append(".\n");
            if (statusCode >= 301 && statusCode <= 303) {
                message.append("HINT: The web server returned a redirect. If your URL uses http://, change to https://. If your website forces www., make sure to add www. to the url.\n");
            } else if (statusCode == 520 || statusCode == 521) {
                message.append("HINT: Status code 520/521 is sent by CloudFlare when the backend webserver is down or having issues. Check your webserver and CloudFlare configuration.\n");
            } else if (responseBody.contains("/aes.js")) {
                message.append("HINT: It looks like requests are being blocked by your web server or a proxy. ");
                message.append("This is a common occurrence with free web hosting services; they usually don't allow API access.\n");
            } else if (responseBody.contains("<title>Please Wait... | Cloudflare</title>") || responseBody.contains("#cf-bubbles") || responseBody.contains("_cf_chl_opt")) {
                message.append("HINT: CloudFlare is blocking our request. Please see https://docs.namelessmc.com/cloudflare-api\n");
            } else if (responseBody.startsWith("\ufeff")) {
                message.append("HINT: The website response contains invisible unicode characters. This seems to be caused by Partydragen's Store module, we have no idea why.\n");
            }
            message.append("Website response, after ");
            message.append(System.currentTimeMillis() - requestStartTime);
            message.append("ms:\n");
            message.append("-----------------\n");
            int totalLengthLimit = 1500;
            String printableResponse = RequestHandler.regularAsciiOnly(responseBody);
            message.append(Ascii.truncate(printableResponse, 1500, "[truncated]\n"));
            if (message.charAt(message.length() - 1) != '\n') {
                message.append('\n');
            }
            throw new NamelessException(message.toString(), e);
        }
        if (json.has("error")) {
            String errorString = json.get("error").getAsString();
            if (errorString.equals("true")) {
                throw new NamelessException("Error string is 'true', are you using an older NamelessMC version?");
            }
            ApiError apiError = ApiError.fromString(errorString);
            if (apiError == null) {
                throw new NamelessException("Unknown API error: " + errorString);
            }
            String meta = json.has("meta") && !json.get("meta").isJsonNull() ? json.get("meta").toString() : null;
            throw new ApiException(apiError, meta);
        }
        return json;
    }

    private @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String getBodyAsString(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat HttpResponse<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat InputStream> response) throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat IOException {
        try (InputStream in = response.body();){
            String string;
            block13: {
                InputStream limited = ByteStreams.limit(in, this.responseLengthLimit);
                try {
                    byte[] bytes = limited.readAllBytes();
                    if (bytes.length == this.responseLengthLimit) {
                        throw new IOException("Response larger than limit of " + this.responseLengthLimit + " bytes.");
                    }
                    string = new String(bytes, StandardCharsets.UTF_8);
                    if (limited == null) break block13;
                }
                catch (Throwable throwable) {
                    if (limited != null) {
                        try {
                            limited.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                limited.close();
            }
            return string;
        }
    }

    private static @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String regularAsciiOnly(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String message) {
        char[] chars = message.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            int c = chars[i];
            chars[i] = c >= 32 && c <= 126 || c == 10 ? c : 46;
        }
        return new String(chars);
    }
}

