/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.nameless-api.modules.discord;

import com.namelessmc.plugin.lib.checker-framework.checker.formatter.qual.UnknownFormat;
import com.namelessmc.plugin.lib.checker-framework.checker.initialization.qual.Initialized;
import com.namelessmc.plugin.lib.checker-framework.checker.nonempty.qual.UnknownNonEmpty;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.NonNull;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.UnknownKeyFor;
import com.namelessmc.plugin.lib.checker-framework.checker.optional.qual.MaybePresent;
import com.namelessmc.plugin.lib.checker-framework.checker.regex.qual.UnknownRegex;
import com.namelessmc.plugin.lib.checker-framework.common.aliasing.qual.MaybeAliased;
import com.namelessmc.plugin.lib.checker-framework.common.aliasing.qual.MaybeLeaked;
import com.namelessmc.plugin.lib.gson.JsonArray;
import com.namelessmc.plugin.lib.gson.JsonObject;
import com.namelessmc.plugin.lib.guava.base.Preconditions;
import com.namelessmc.plugin.lib.nameless-api.NamelessAPI;
import com.namelessmc.plugin.lib.nameless-api.RequestHandler;
import com.namelessmc.plugin.lib.nameless-api.exception.NamelessException;
import com.namelessmc.plugin.lib.nameless-api.modules.NamelessModule;
import java.net.URL;
import java.util.Map;
import java.util.Objects;

public class DiscordAPI {
    private final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat RequestHandler requests;

    public DiscordAPI(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessAPI api) throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        this.requests = api.requests();
        api.ensureModuleInstalled(NamelessModule.DISCORD_INTEGRATION);
    }

    public void updateBotUrl(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat URL url) throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        Objects.requireNonNull(url, "Bot url is null");
        JsonObject json = new JsonObject();
        json.addProperty("url", url.toString());
        this.requests.post("discord/update-bot-settings", json);
    }

    public void updateBotUser(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String username, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat long userId) throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        Objects.requireNonNull(username, "Bot username is null");
        JsonObject json = new JsonObject();
        json.addProperty("bot_username", username);
        json.addProperty("bot_user_id", "" + userId);
        this.requests.post("discord/update-bot-settings", json);
    }

    public void updateGuildId(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat long guildId) throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        JsonObject json = new JsonObject();
        json.addProperty("guild_id", "" + guildId);
        this.requests.post("discord/update-bot-settings", json);
    }

    public void updateBotSettings(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat URL url, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat long guildId, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String username, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat long userId) throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        Objects.requireNonNull(url, "Bot url is null");
        Objects.requireNonNull(username, "Bot username is null");
        JsonObject json = new JsonObject();
        json.addProperty("url", url.toString());
        json.addProperty("guild_id", "" + guildId);
        json.addProperty("bot_username", username);
        json.addProperty("bot_user_id", "" + userId);
        this.requests.post("discord/update-bot-settings", json);
    }

    public void updateDiscordUsername(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat long discordUserId, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String discordUsername) throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        Objects.requireNonNull(discordUsername, "Discord username is null");
        JsonObject user = new JsonObject();
        user.addProperty("id", discordUserId);
        user.addProperty("name", discordUsername);
        JsonArray users = new JsonArray();
        users.add(user);
        JsonObject json = new JsonObject();
        json.add("users", users);
        this.requests.post("discord/update-usernames", json);
    }

    public void updateDiscordUsernames(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat long @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat [] discordUserIds, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat [] discordUsernames) throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        Objects.requireNonNull(discordUserIds, "User ids array is null");
        Objects.requireNonNull(discordUsernames, "Usernames array is null");
        Preconditions.checkArgument(discordUserIds.length == discordUsernames.length, "discord user ids and discord usernames must be of same length");
        if (discordUserIds.length == 0) {
            return;
        }
        JsonArray users = new JsonArray();
        for (int i = 0; i < discordUserIds.length; ++i) {
            JsonObject user = new JsonObject();
            user.addProperty("id", discordUserIds[i]);
            user.addProperty("name", discordUsernames[i]);
            users.add(user);
        }
        JsonObject json = new JsonObject();
        json.add("users", users);
        this.requests.post("discord/update-usernames", json);
    }

    public void updateRoleList(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Map<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Long, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String> discordRoles) throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        JsonArray roles = new JsonArray();
        discordRoles.forEach((id, name) -> {
            JsonObject role = new JsonObject();
            role.addProperty("id", (Number)id);
            role.addProperty("name", (String)name);
            roles.add(role);
        });
        JsonObject json = new JsonObject();
        json.add("roles", roles);
        this.requests.post("discord/submit-role-list", json);
    }
}

