/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.nameless-api.modules.websend;

import com.namelessmc.plugin.lib.checker-framework.checker.formatter.qual.UnknownFormat;
import com.namelessmc.plugin.lib.checker-framework.checker.initialization.qual.Initialized;
import com.namelessmc.plugin.lib.checker-framework.checker.nonempty.qual.UnknownNonEmpty;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.NonNull;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.UnknownKeyFor;
import com.namelessmc.plugin.lib.checker-framework.checker.optional.qual.MaybePresent;
import com.namelessmc.plugin.lib.checker-framework.checker.regex.qual.UnknownRegex;
import com.namelessmc.plugin.lib.checker-framework.common.aliasing.qual.MaybeAliased;
import com.namelessmc.plugin.lib.checker-framework.common.aliasing.qual.MaybeLeaked;
import com.namelessmc.plugin.lib.gson.JsonArray;
import com.namelessmc.plugin.lib.gson.JsonElement;
import com.namelessmc.plugin.lib.gson.JsonObject;
import com.namelessmc.plugin.lib.nameless-api.NamelessAPI;
import com.namelessmc.plugin.lib.nameless-api.RequestHandler;
import com.namelessmc.plugin.lib.nameless-api.exception.NamelessException;
import com.namelessmc.plugin.lib.nameless-api.modules.NamelessModule;
import com.namelessmc.plugin.lib.nameless-api.modules.websend.WebsendCommand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class WebsendAPI {
    private final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat RequestHandler requests;

    public WebsendAPI(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessAPI api) throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        this.requests = api.requests();
        api.ensureModuleInstalled(NamelessModule.WEBSEND);
    }

    public @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat List<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat WebsendCommand> commands(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat int serverId) throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        JsonObject response = this.requests.get("websend/commands", "server_id", serverId);
        JsonArray commandsJson = response.getAsJsonArray("commands");
        ArrayList<WebsendCommand> commands = new ArrayList<WebsendCommand>(commandsJson.size());
        for (JsonElement e : commandsJson) {
            JsonObject commandJson = e.getAsJsonObject();
            int commandId = commandJson.get("id").getAsInt();
            String commandLine = commandJson.get("command").getAsString();
            commands.add(new WebsendCommand(commandId, commandLine));
        }
        return Collections.unmodifiableList(commands);
    }

    public void sendConsoleLog(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat int serverId, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Collection<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String> lines) throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        this.sendConsoleLog(serverId, lines, false);
    }

    public void sendConsoleLog(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat int serverId, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Collection<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String> lines, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat boolean clearPrevious) throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        JsonObject body = new JsonObject();
        body.addProperty("server_id", serverId);
        body.addProperty("clear_previous", clearPrevious);
        JsonArray content = new JsonArray();
        for (String line : lines) {
            content.add(line);
        }
        body.add("content", content);
        this.requests.post("websend/console", body);
    }
}

