/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.common.command;

import com.namelessmc.plugin.common.LanguageHandler;
import com.namelessmc.plugin.common.NamelessPlugin;
import com.namelessmc.plugin.common.Permission;
import com.namelessmc.plugin.common.audiences.NamelessCommandSender;
import com.namelessmc.plugin.common.audiences.NamelessConsole;
import com.namelessmc.plugin.common.audiences.NamelessPlayer;
import com.namelessmc.plugin.common.command.CommonCommand;
import com.namelessmc.plugin.lib.checker-framework.checker.formatter.qual.UnknownFormat;
import com.namelessmc.plugin.lib.checker-framework.checker.initialization.qual.Initialized;
import com.namelessmc.plugin.lib.checker-framework.checker.nonempty.qual.UnknownNonEmpty;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.NonNull;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.UnknownKeyFor;
import com.namelessmc.plugin.lib.checker-framework.checker.optional.qual.MaybePresent;
import com.namelessmc.plugin.lib.checker-framework.checker.regex.qual.UnknownRegex;
import com.namelessmc.plugin.lib.checker-framework.common.aliasing.qual.MaybeAliased;
import com.namelessmc.plugin.lib.checker-framework.common.aliasing.qual.MaybeLeaked;
import com.namelessmc.plugin.lib.nameless-api.NamelessAPI;
import com.namelessmc.plugin.lib.nameless-api.exception.ApiException;
import com.namelessmc.plugin.lib.nameless-api.exception.NamelessException;
import com.namelessmc.plugin.lib.nameless-api.integrations.MinecraftIntegrationData;

public class VerifyCommand
extends CommonCommand {
    public VerifyCommand(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin) {
        super(plugin, "verify", LanguageHandler.Term.COMMAND_VALIDATE_USAGE, LanguageHandler.Term.COMMAND_VALIDATE_DESCRIPTION, Permission.COMMAND_VERIFY);
    }

    @Override
    public void execute(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessCommandSender sender, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat [] args) {
        if (args.length != 1) {
            sender.sendMessage(this.usage());
            return;
        }
        if (sender instanceof NamelessConsole) {
            sender.sendMessage(this.language().get(LanguageHandler.Term.COMMAND_NOT_A_PLAYER));
            return;
        }
        this.scheduler().runAsync(() -> {
            NamelessAPI api = this.apiProvider().api();
            if (api == null) {
                sender.sendMessage(this.language().get(LanguageHandler.Term.ERROR_WEBSITE_CONNECTION));
                return;
            }
            try {
                String code = args[0];
                NamelessPlayer player = (NamelessPlayer)sender;
                MinecraftIntegrationData integrationData = new MinecraftIntegrationData(player.uuid(), player.username());
                api.verifyIntegration(integrationData, code);
                sender.sendMessage(this.language().get(LanguageHandler.Term.COMMAND_VALIDATE_OUTPUT_SUCCESS));
                this.plugin().groupSync().resetGroups(player);
            }
            catch (ApiException e) {
                switch (e.apiError()) {
                    case CORE_INVALID_CODE: {
                        sender.sendMessage(this.language().get(LanguageHandler.Term.COMMAND_VALIDATE_OUTPUT_FAIL_INVALID_CODE));
                        return;
                    }
                    case CORE_INTEGRATION_ALREADY_VERIFIED: {
                        sender.sendMessage(this.language().get(LanguageHandler.Term.COMMAND_VALIDATE_OUTPUT_FAIL_ALREADY_VALIDATED));
                        return;
                    }
                    case CORE_INTEGRATION_IDENTIFIER_ERROR: 
                    case CORE_INTEGRATION_USERNAME_ERROR: {
                        sender.sendMessage(this.language().get(LanguageHandler.Term.COMMAND_VALIDATE_OUTPUT_FAIL_MINECRAFT_ACCOUNT_LINKED));
                        return;
                    }
                }
                sender.sendMessage(this.language().get(LanguageHandler.Term.ERROR_WEBSITE_CONNECTION));
                this.logger().logException(e);
            }
            catch (NamelessException e) {
                sender.sendMessage(this.language().get(LanguageHandler.Term.ERROR_WEBSITE_CONNECTION));
                this.logger().logException(e);
            }
        });
    }
}

