/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.methanol;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.MonotonicNonNull;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.Nullable;
import com.namelessmc.plugin.lib.methanol.AdapterCodec;
import com.namelessmc.plugin.lib.methanol.BodyAdapter;
import com.namelessmc.plugin.lib.methanol.CacheControl;
import com.namelessmc.plugin.lib.methanol.HeadersAccumulator;
import com.namelessmc.plugin.lib.methanol.MediaType;
import com.namelessmc.plugin.lib.methanol.MimeAwareRequest;
import com.namelessmc.plugin.lib.methanol.MimeBody;
import com.namelessmc.plugin.lib.methanol.MoreBodyPublishers;
import com.namelessmc.plugin.lib.methanol.TaggableRequest;
import com.namelessmc.plugin.lib.methanol.TypeRef;
import com.namelessmc.plugin.lib.methanol.internal.Utils;
import com.namelessmc.plugin.lib.methanol.internal.Validate;
import com.namelessmc.plugin.lib.methanol.internal.extensions.HeadersBuilder;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Consumer;

public final class MutableRequest
extends TaggableRequest
implements TaggableRequest.Builder,
HeadersAccumulator<MutableRequest>,
MimeAwareRequest {
    private static final URI EMPTY_URI = URI.create("");
    private final Map<TypeRef<?>, Object> tags = new HashMap();
    private final HeadersBuilder headersBuilder = new HeadersBuilder();
    private final BodyAdapter.Hints.Builder hintsBuilder = BodyAdapter.Hints.newBuilder();
    private String method;
    private URI uri;
    private @Nullable Object body;
    private @MonotonicNonNull Duration timeout;
    private  @MonotonicNonNull HttpClient.Version version;
    private boolean expectContinue;
    private @Nullable HttpHeaders cachedHeaders;
    private @MonotonicNonNull AdapterCodec adapterCodec;

    private MutableRequest() {
        this.method = "GET";
        this.uri = EMPTY_URI;
    }

    private MutableRequest(MutableRequest other) {
        this.method = other.method;
        this.uri = other.uri;
        this.body = other.body;
        this.expectContinue = other.expectContinue;
        this.adapterCodec = other.adapterCodec;
        this.cachedHeaders = other.cachedHeaders;
        this.headersBuilder.addAll(other.headersBuilder);
        this.tags.putAll(other.tags);
        this.hintsBuilder.putAll(other.hintsBuilder);
        if (other.timeout != null) {
            this.timeout = other.timeout;
        }
        if (other.version != null) {
            this.version = other.version;
        }
    }

    @CanIgnoreReturnValue
    public MutableRequest uri(String uri) {
        return this.uri(URI.create(uri));
    }

    @CanIgnoreReturnValue
    public MutableRequest cacheControl(CacheControl cacheControl) {
        return this.setHeader("Cache-Control", cacheControl.toString());
    }

    @CanIgnoreReturnValue
    public MutableRequest apply(Consumer<? super MutableRequest> consumer) {
        consumer.accept(this);
        return this;
    }

    @Override
    Map<TypeRef<?>, Object> tags() {
        return Map.copyOf(this.tags);
    }

    @Override
    @CanIgnoreReturnValue
    public MutableRequest tag(Object value) {
        return this.tag((TypeRef)TypeRef.ofRuntimeType(value), value);
    }

    @Override
    @CanIgnoreReturnValue
    public <T> MutableRequest tag(Class<T> type, T value) {
        return this.tag((TypeRef)TypeRef.of(type), (Object)value);
    }

    @Override
    @CanIgnoreReturnValue
    public <T> MutableRequest tag(TypeRef<T> typeRef, T value) {
        this.tags.put(typeRef, Objects.requireNonNull(value));
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public MutableRequest removeTag(Class<?> type) {
        return this.removeTag((TypeRef)TypeRef.of(type));
    }

    @Override
    @CanIgnoreReturnValue
    public MutableRequest removeTag(TypeRef<?> typeRef) {
        this.tags.remove(Objects.requireNonNull(typeRef));
        return this;
    }

    public MutableRequest hints(Consumer<BodyAdapter.Hints.Builder> hintsMutator) {
        hintsMutator.accept(this.hintsBuilder);
        return this;
    }

    public <T> MutableRequest hint(Class<T> type, T value) {
        this.hintsBuilder.put(type, value);
        return this;
    }

    @Override
    public Optional<HttpRequest.BodyPublisher> bodyPublisher() {
        return Optional.ofNullable(this.body).map(body -> MutableRequest.resolve(this, body, this.adapterCodec != null ? this.adapterCodec : AdapterCodec.installed()));
    }

    @CanIgnoreReturnValue
    public MutableRequest adapterCodec(AdapterCodec adapterCodec) {
        this.adapterCodec = Objects.requireNonNull(adapterCodec);
        if (this.body instanceof UnresolvedBody) {
            ((UnresolvedBody)this.body).unresolve();
        }
        return this;
    }

    public Optional<AdapterCodec> adapterCodec() {
        return Optional.ofNullable(this.adapterCodec);
    }

    @Override
    public String method() {
        return this.method;
    }

    @Override
    public Optional<Duration> timeout() {
        return Optional.ofNullable(this.timeout);
    }

    @Override
    public boolean expectContinue() {
        return this.expectContinue;
    }

    @Override
    public URI uri() {
        return this.uri;
    }

    @Override
    public Optional<HttpClient.Version> version() {
        return Optional.ofNullable(this.version);
    }

    @Override
    public HttpHeaders headers() {
        HttpHeaders headers = this.cachedHeaders;
        if (headers == null) {
            this.cachedHeaders = headers = this.headersBuilder.build();
        }
        return headers;
    }

    @Override
    public BodyAdapter.Hints hints() {
        return this.hintsBuilder.build();
    }

    @Override
    @CanIgnoreReturnValue
    public MutableRequest uri(URI uri) {
        this.uri = Objects.requireNonNull(uri);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public MutableRequest expectContinue(boolean enable) {
        this.expectContinue = enable;
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public MutableRequest version(HttpClient.Version version) {
        this.version = Objects.requireNonNull(version);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public MutableRequest header(String name, String value) {
        this.headersBuilder.add(name, value);
        this.cachedHeaders = null;
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public MutableRequest headers(String ... headers) {
        this.headersBuilder.addAll(headers);
        this.cachedHeaders = null;
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public MutableRequest headers(HttpHeaders headers) {
        this.headersBuilder.addAll(headers);
        this.cachedHeaders = null;
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public MutableRequest setHeader(String name, String value) {
        this.headersBuilder.set(name, value);
        this.cachedHeaders = null;
        return this;
    }

    @Override
    public MutableRequest setHeader(String name, List<String> values) {
        this.headersBuilder.set(name, values);
        this.cachedHeaders = null;
        return this;
    }

    @Override
    public MutableRequest setHeaderIfAbsent(String name, String value) {
        this.headersBuilder.setIfAbsent(name, value);
        this.cachedHeaders = null;
        return this;
    }

    @Override
    public MutableRequest setHeaderIfAbsent(String name, List<String> values) {
        this.headersBuilder.setIfAbsent(name, values);
        this.cachedHeaders = null;
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public MutableRequest removeHeaders() {
        this.headersBuilder.clear();
        this.cachedHeaders = null;
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public MutableRequest removeHeader(String name) {
        if (this.headersBuilder.remove(name)) {
            this.cachedHeaders = null;
        }
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public MutableRequest removeHeadersIf(BiPredicate<String, String> filter) {
        if (this.headersBuilder.removeIf(filter)) {
            this.cachedHeaders = null;
        }
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public MutableRequest timeout(Duration timeout) {
        this.timeout = Utils.requirePositiveDuration(timeout);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public MutableRequest GET() {
        return this.setMethod("GET", null);
    }

    @Override
    @CanIgnoreReturnValue
    public MutableRequest HEAD() {
        return this.setMethod("HEAD", null);
    }

    @Override
    @CanIgnoreReturnValue
    public MutableRequest POST(HttpRequest.BodyPublisher bodyPublisher) {
        return this.setMethod("POST", Objects.requireNonNull(bodyPublisher));
    }

    @CanIgnoreReturnValue
    public MutableRequest POST(Object payload, MediaType mediaType) {
        return this.POST(payload, TypeRef.ofRuntimeType(payload), mediaType);
    }

    @CanIgnoreReturnValue
    public <T> MutableRequest POST(T payload, TypeRef<T> typeRef, MediaType mediaType) {
        return this.setMethod("POST", this.toMimeBody(payload, typeRef, mediaType));
    }

    @Override
    @CanIgnoreReturnValue
    public MutableRequest PUT(HttpRequest.BodyPublisher bodyPublisher) {
        return this.setMethod("PUT", Objects.requireNonNull(bodyPublisher));
    }

    @CanIgnoreReturnValue
    public MutableRequest PUT(Object payload, MediaType mediaType) {
        return this.PUT(payload, TypeRef.ofRuntimeType(payload), mediaType);
    }

    @CanIgnoreReturnValue
    public <T> MutableRequest PUT(T payload, TypeRef<T> typeRef, MediaType mediaType) {
        return this.setMethod("PUT", this.toMimeBody(payload, typeRef, mediaType));
    }

    @CanIgnoreReturnValue
    public MutableRequest PATCH(HttpRequest.BodyPublisher bodyPublisher) {
        return this.setMethod("PATCH", Objects.requireNonNull(bodyPublisher));
    }

    @CanIgnoreReturnValue
    public MutableRequest PATCH(Object payload, MediaType mediaType) {
        return this.PATCH(payload, TypeRef.ofRuntimeType(payload), mediaType);
    }

    @CanIgnoreReturnValue
    public <T> MutableRequest PATCH(T payload, TypeRef<T> typeRef, MediaType mediaType) {
        return this.setMethod("PATCH", this.toMimeBody(payload, typeRef, mediaType));
    }

    @Override
    @CanIgnoreReturnValue
    public MutableRequest DELETE() {
        return this.setMethod("DELETE", null);
    }

    @Override
    @CanIgnoreReturnValue
    public MutableRequest method(String method, HttpRequest.BodyPublisher bodyPublisher) {
        Validate.requireArgument(Utils.isValidToken(method), "Illegal method name: '%s'", method);
        return this.setMethod(method, Objects.requireNonNull(bodyPublisher));
    }

    @CanIgnoreReturnValue
    public MutableRequest method(String method, Object payload, MediaType mediaType) {
        return this.method(method, payload, TypeRef.ofRuntimeType(payload), mediaType);
    }

    @CanIgnoreReturnValue
    public <T> MutableRequest method(String method, T payload, TypeRef<T> typeRef, MediaType mediaType) {
        Validate.requireArgument(Utils.isValidToken(method), "Illegal method name: '%s'", method);
        return this.setMethod(method, this.toMimeBody(payload, typeRef, mediaType));
    }

    private <T> MimeBody toMimeBody(T payload, TypeRef<T> typeRef, MediaType mediaType) {
        return payload instanceof HttpRequest.BodyPublisher ? MoreBodyPublishers.ofMediaType((HttpRequest.BodyPublisher)payload, mediaType) : new UnresolvedBody<T>(payload, typeRef, mediaType);
    }

    @Override
    public TaggableRequest build() {
        return new ImmutableRequest(this);
    }

    public TaggableRequest toImmutableRequest() {
        return new ImmutableRequest(this);
    }

    @Override
    public MutableRequest copy() {
        return new MutableRequest(this);
    }

    public String toString() {
        return this.uri + " " + this.method;
    }

    @Override
    public Optional<MimeBody> mimeBody() {
        return this.body instanceof MimeBody ? Optional.of((MimeBody)this.body) : Optional.empty();
    }

    @CanIgnoreReturnValue
    private MutableRequest setMethod(String method, @Nullable Object body) {
        this.method = Objects.requireNonNull(method);
        this.body = body;
        return this;
    }

    private static HttpRequest.BodyPublisher resolve(TaggableRequest request, Object body, AdapterCodec adapterCodec) {
        if (body instanceof HttpRequest.BodyPublisher) {
            return (HttpRequest.BodyPublisher)body;
        }
        if (body instanceof UnresolvedBody) {
            return ((UnresolvedBody)body).resolve(request, adapterCodec);
        }
        throw new IllegalStateException("Unexpected request body: " + body);
    }

    public static MutableRequest copyOf(HttpRequest other) {
        return other instanceof MutableRequest ? ((MutableRequest)other).copy() : MutableRequest.copyOfForeignRequest(other);
    }

    private static MutableRequest copyOfForeignRequest(HttpRequest other) {
        assert (!(other instanceof MutableRequest));
        return new MutableRequest().uri(other.uri()).headers(other.headers()).expectContinue(other.expectContinue()).apply(self -> {
            other.timeout().ifPresent(self::timeout);
            other.version().ifPresent(self::version);
            if (other instanceof TaggableRequest) {
                TaggableRequest taggableOther = (TaggableRequest)other;
                self.tags.putAll(taggableOther.tags());
                self.hintsBuilder.putAll(taggableOther.hints());
            }
            if (other instanceof ImmutableRequest) {
                ImmutableRequest immutableOther = (ImmutableRequest)other;
                immutableOther.adapterCodec.ifPresent(self::adapterCodec);
                self.setMethod(immutableOther.method, immutableOther.body.orElse(null));
            } else {
                self.setMethod(other.method(), other.bodyPublisher().orElse(null));
            }
        });
    }

    static Optional<AdapterCodec> adapterCodecOf(HttpRequest request) {
        if (request instanceof MutableRequest) {
            return ((MutableRequest)request).adapterCodec();
        }
        if (request instanceof ImmutableRequest) {
            return ((ImmutableRequest)request).adapterCodec;
        }
        return Optional.empty();
    }

    public static MutableRequest create() {
        return new MutableRequest();
    }

    public static MutableRequest create(String uri) {
        return new MutableRequest().uri(uri);
    }

    public static MutableRequest create(URI uri) {
        return new MutableRequest().uri(uri);
    }

    public static MutableRequest GET(String uri) {
        return new MutableRequest().uri(uri);
    }

    public static MutableRequest GET(URI uri) {
        return new MutableRequest().uri(uri);
    }

    public static MutableRequest HEAD(String uri) {
        return new MutableRequest().uri(uri).HEAD();
    }

    public static MutableRequest HEAD(URI uri) {
        return new MutableRequest().uri(uri).HEAD();
    }

    public static MutableRequest DELETE(String uri) {
        return new MutableRequest().uri(uri).DELETE();
    }

    public static MutableRequest DELETE(URI uri) {
        return new MutableRequest().uri(uri).DELETE();
    }

    public static MutableRequest POST(String uri, HttpRequest.BodyPublisher bodyPublisher) {
        return new MutableRequest().uri(uri).POST(bodyPublisher);
    }

    public static MutableRequest POST(URI uri, HttpRequest.BodyPublisher bodyPublisher) {
        return new MutableRequest().uri(uri).POST(bodyPublisher);
    }

    public static MutableRequest POST(String uri, Object payload, MediaType mediaType) {
        return new MutableRequest().uri(uri).POST(payload, mediaType);
    }

    public static MutableRequest POST(URI uri, Object payload, MediaType mediaType) {
        return new MutableRequest().uri(uri).POST(payload, mediaType);
    }

    public static <T> MutableRequest POST(String uri, T payload, TypeRef<T> typeRef, MediaType mediaType) {
        return new MutableRequest().uri(uri).POST(payload, typeRef, mediaType);
    }

    public static <T> MutableRequest POST(URI uri, T payload, TypeRef<T> typeRef, MediaType mediaType) {
        return new MutableRequest().uri(uri).POST(payload, typeRef, mediaType);
    }

    public static MutableRequest PUT(String uri, HttpRequest.BodyPublisher bodyPublisher) {
        return new MutableRequest().uri(uri).PUT(bodyPublisher);
    }

    public static MutableRequest PUT(URI uri, HttpRequest.BodyPublisher bodyPublisher) {
        return new MutableRequest().uri(uri).PUT(bodyPublisher);
    }

    public static MutableRequest PUT(String uri, Object payload, MediaType mediaType) {
        return new MutableRequest().uri(uri).PUT(payload, mediaType);
    }

    public static MutableRequest PUT(URI uri, Object payload, MediaType mediaType) {
        return new MutableRequest().uri(uri).PUT(payload, mediaType);
    }

    public static <T> MutableRequest PUT(String uri, T payload, TypeRef<T> typeRef, MediaType mediaType) {
        return new MutableRequest().uri(uri).PUT(payload, typeRef, mediaType);
    }

    public static <T> MutableRequest PUT(URI uri, T payload, TypeRef<T> typeRef, MediaType mediaType) {
        return new MutableRequest().uri(uri).PUT(payload, typeRef, mediaType);
    }

    public static MutableRequest PATCH(String uri, HttpRequest.BodyPublisher bodyPublisher) {
        return new MutableRequest().uri(uri).PATCH(bodyPublisher);
    }

    public static MutableRequest PATCH(URI uri, HttpRequest.BodyPublisher bodyPublisher) {
        return new MutableRequest().uri(uri).PATCH(bodyPublisher);
    }

    public static MutableRequest PATCH(String uri, Object payload, MediaType mediaType) {
        return new MutableRequest().uri(uri).PATCH(payload, mediaType);
    }

    public static MutableRequest PATCH(URI uri, Object payload, MediaType mediaType) {
        return new MutableRequest().uri(uri).PATCH(payload, mediaType);
    }

    public static <T> MutableRequest PATCH(String uri, T payload, TypeRef<T> typeRef, MediaType mediaType) {
        return new MutableRequest().uri(uri).PATCH(payload, typeRef, mediaType);
    }

    public static <T> MutableRequest PATCH(URI uri, T payload, TypeRef<T> typeRef, MediaType mediaType) {
        return new MutableRequest().uri(uri).PATCH(payload, typeRef, mediaType);
    }

    private static final class UnresolvedBody<T>
    implements MimeBody {
        private final T payload;
        private final TypeRef<T> typeRef;
        private final MediaType mediaType;
        private @Nullable HttpRequest.BodyPublisher resolvedBodyPublisher;

        UnresolvedBody(T payload, TypeRef<T> typeRef, MediaType mediaType) {
            this.typeRef = Objects.requireNonNull(typeRef);
            this.payload = Objects.requireNonNull(payload);
            this.mediaType = Objects.requireNonNull(mediaType);
        }

        HttpRequest.BodyPublisher resolve(TaggableRequest request, AdapterCodec adapterCodec) {
            HttpRequest.BodyPublisher bodyPublisher = this.resolvedBodyPublisher;
            if (bodyPublisher == null) {
                this.resolvedBodyPublisher = bodyPublisher = adapterCodec.publisherOf(this.payload, this.typeRef, request.hints().mutate().forEncoder(request).build());
            }
            return bodyPublisher;
        }

        void unresolve() {
            this.resolvedBodyPublisher = null;
        }

        @Override
        public MediaType mediaType() {
            return this.mediaType;
        }
    }

    private static final class ImmutableRequest
    extends TaggableRequest
    implements MimeAwareRequest {
        final String method;
        final URI uri;
        final HttpHeaders headers;
        final Optional<?> body;
        final Optional<Duration> timeout;
        final Optional<HttpClient.Version> version;
        final Optional<AdapterCodec> adapterCodec;
        final boolean expectContinue;
        final Map<TypeRef<?>, Object> tags;
        final BodyAdapter.Hints hints;

        ImmutableRequest(MutableRequest other) {
            this.method = other.method;
            this.uri = other.uri;
            this.headers = other.headers();
            this.body = Optional.ofNullable(other.body);
            this.timeout = Optional.ofNullable(other.timeout);
            this.version = Optional.ofNullable(other.version);
            this.adapterCodec = Optional.ofNullable(other.adapterCodec);
            this.expectContinue = other.expectContinue;
            this.tags = other.tags();
            this.hints = other.hints();
        }

        @Override
        Map<TypeRef<?>, Object> tags() {
            return this.tags;
        }

        @Override
        public BodyAdapter.Hints hints() {
            return this.hints;
        }

        @Override
        public String method() {
            return this.method;
        }

        @Override
        public URI uri() {
            return this.uri;
        }

        @Override
        public HttpHeaders headers() {
            return this.headers;
        }

        @Override
        public Optional<HttpRequest.BodyPublisher> bodyPublisher() {
            return this.body.map(body -> MutableRequest.resolve(this, body, this.adapterCodec.orElseGet(AdapterCodec::installed)));
        }

        @Override
        public boolean expectContinue() {
            return this.expectContinue;
        }

        @Override
        public Optional<Duration> timeout() {
            return this.timeout;
        }

        @Override
        public Optional<HttpClient.Version> version() {
            return this.version;
        }

        public String toString() {
            return this.uri + " " + this.method;
        }

        @Override
        public Optional<MimeBody> mimeBody() {
            return this.body.filter(MimeBody.class::isInstance);
        }
    }
}

