/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.methanol.internal.cache;

import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.Nullable;
import com.namelessmc.plugin.lib.methanol.Methanol;
import com.namelessmc.plugin.lib.methanol.internal.concurrent.CancellationPropagatingFuture;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;

final class ChainAdapter {
    private final Methanol.Interceptor.Chain<Flow.Publisher<List<ByteBuffer>>> chain;
    private final @Nullable Thread syncCallerThread;

    private ChainAdapter(Methanol.Interceptor.Chain<Flow.Publisher<List<ByteBuffer>>> chain, @Nullable Thread syncCallerThread) {
        this.chain = Objects.requireNonNull(chain);
        this.syncCallerThread = syncCallerThread;
    }

    CompletableFuture<HttpResponse<Flow.Publisher<List<ByteBuffer>>>> forward(HttpRequest request) {
        if (this.syncCallerThread == null || this.syncCallerThread != Thread.currentThread()) {
            return CancellationPropagatingFuture.of(this.chain.forwardAsync(request));
        }
        try {
            return CompletableFuture.completedFuture(this.chain.forward(request));
        }
        catch (Throwable t) {
            return CompletableFuture.failedFuture(t);
        }
    }

    public boolean isAsync() {
        return this.syncCallerThread == null;
    }

    public Methanol.Interceptor.Chain<Flow.Publisher<List<ByteBuffer>>> chain() {
        return this.chain;
    }

    static ChainAdapter async(Methanol.Interceptor.Chain<Flow.Publisher<List<ByteBuffer>>> chain) {
        return new ChainAdapter(chain, null);
    }

    static ChainAdapter syncOnCaller(Methanol.Interceptor.Chain<Flow.Publisher<List<ByteBuffer>>> chain) {
        return new ChainAdapter(chain, Thread.currentThread());
    }
}

