/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.methanol.internal.flow;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.Flow;

public final class Upstream {
    private static final Flow.Subscription UNSET_SUBSCRIPTION = new Flow.Subscription(){

        @Override
        public void request(long n) {
        }

        @Override
        public void cancel() {
        }
    };
    private static final Flow.Subscription CANCELLED_SUBSCRIPTION = new Flow.Subscription(){

        @Override
        public void request(long n) {
        }

        @Override
        public void cancel() {
        }
    };
    private static final VarHandle SUBSCRIPTION;
    private volatile Flow.Subscription subscription = UNSET_SUBSCRIPTION;

    public boolean isSet() {
        return this.subscription != null;
    }

    public boolean isCancelled() {
        return this.subscription == CANCELLED_SUBSCRIPTION;
    }

    public boolean setOrCancel(Flow.Subscription incoming) {
        if (!SUBSCRIPTION.compareAndSet(this, UNSET_SUBSCRIPTION, incoming)) {
            incoming.cancel();
            return false;
        }
        return true;
    }

    public void request(long n) {
        Flow.Subscription currentSubscription = this.subscription;
        if (currentSubscription != null) {
            currentSubscription.request(n);
        }
    }

    public void cancel() {
        Flow.Subscription cancelledSubscription = SUBSCRIPTION.getAndSet(this, CANCELLED_SUBSCRIPTION);
        if (cancelledSubscription != null) {
            cancelledSubscription.cancel();
        }
    }

    public void clear() {
        this.subscription = CANCELLED_SUBSCRIPTION;
    }

    public void cancel(boolean flowInterrupted) {
        if (flowInterrupted) {
            this.cancel();
        } else {
            this.clear();
        }
    }

    public Flow.Subscription get() {
        return this.subscription;
    }

    static {
        try {
            SUBSCRIPTION = MethodHandles.lookup().findVarHandle(Upstream.class, "subscription", Flow.Subscription.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

