/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.methanol;

import com.namelessmc.plugin.lib.methanol.internal.spi.BodyDecoderFactoryProviders;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;

public interface BodyDecoder<T>
extends HttpResponse.BodySubscriber<T> {
    public String encoding();

    public Optional<Executor> executor();

    public HttpResponse.BodySubscriber<T> downstream();

    @Override
    default public CompletionStage<T> getBody() {
        return this.downstream().getBody();
    }

    public static interface Factory {
        public String encoding();

        public <T> BodyDecoder<T> create(HttpResponse.BodySubscriber<T> var1);

        public <T> BodyDecoder<T> create(HttpResponse.BodySubscriber<T> var1, Executor var2);

        public static List<Factory> installedFactories() {
            return BodyDecoderFactoryProviders.factories();
        }

        public static Map<String, Factory> installedBindings() {
            return BodyDecoderFactoryProviders.bindings();
        }

        public static Optional<Factory> getFactory(String encoding) {
            return Optional.ofNullable(Factory.installedBindings().get(Objects.requireNonNull(encoding)));
        }
    }
}

