/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.methanol;

import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.Nullable;
import com.namelessmc.plugin.lib.methanol.AdapterCodec;
import com.namelessmc.plugin.lib.methanol.MediaType;
import com.namelessmc.plugin.lib.methanol.TypeRef;
import com.namelessmc.plugin.lib.methanol.internal.Utils;
import com.namelessmc.plugin.lib.methanol.internal.concurrent.Delayer;
import com.namelessmc.plugin.lib.methanol.internal.extensions.AsyncSubscriberAdapter;
import com.namelessmc.plugin.lib.methanol.internal.extensions.ByteChannelBodySubscriber;
import com.namelessmc.plugin.lib.methanol.internal.extensions.TimeoutBodySubscriber;
import java.io.Reader;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;

public class MoreBodySubscribers {
    private MoreBodySubscribers() {
    }

    public static <T, S extends Flow.Subscriber<? super List<ByteBuffer>>> HttpResponse.BodySubscriber<T> fromAsyncSubscriber(S downstream, Function<? super S, ? extends CompletionStage<T>> asyncFinisher) {
        return new AsyncSubscriberAdapter(downstream, asyncFinisher);
    }

    public static <T> HttpResponse.BodySubscriber<T> withReadTimeout(HttpResponse.BodySubscriber<T> downstream, Duration timeout) {
        return MoreBodySubscribers.withReadTimeout(downstream, timeout, Delayer.systemDelayer());
    }

    public static <T> HttpResponse.BodySubscriber<T> withReadTimeout(HttpResponse.BodySubscriber<T> downstream, Duration timeout, ScheduledExecutorService scheduler) {
        return MoreBodySubscribers.withReadTimeout(downstream, timeout, Delayer.of(scheduler));
    }

    static <T> HttpResponse.BodySubscriber<T> withReadTimeout(HttpResponse.BodySubscriber<T> downstream, Duration timeout, Delayer delayer) {
        return new TimeoutBodySubscriber<T>(downstream, timeout, delayer);
    }

    public static HttpResponse.BodySubscriber<ReadableByteChannel> ofByteChannel() {
        return new ByteChannelBodySubscriber();
    }

    public static HttpResponse.BodySubscriber<Reader> ofReader(Charset charset) {
        Objects.requireNonNull(charset);
        return HttpResponse.BodySubscribers.mapping(MoreBodySubscribers.ofByteChannel(), channel -> Channels.newReader(channel, charset));
    }

    public static <T> HttpResponse.BodySubscriber<T> ofObject(TypeRef<T> type, @Nullable MediaType mediaType) {
        return AdapterCodec.installed().subscriberOf(type, Utils.hintsOf(mediaType));
    }

    public static <T> HttpResponse.BodySubscriber<Supplier<T>> ofDeferredObject(TypeRef<T> type, @Nullable MediaType mediaType) {
        return AdapterCodec.installed().deferredSubscriberOf(type, Utils.hintsOf(mediaType));
    }
}

