/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.methanol.internal;

import com.google.errorprone.annotations.DoNotCall;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.EnsuresNonNull;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.NonNull;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.Nullable;

public class Validate {
    private Validate() {
    }

    public static void requireArgument(boolean argIsValid, String msg) {
        if (!argIsValid) {
            throw new IllegalArgumentException(msg);
        }
    }

    @FormatMethod
    public static void requireArgument(boolean argIsValid, @FormatString String msgFormat, Object ... args) {
        if (!argIsValid) {
            throw new IllegalArgumentException(String.format(msgFormat, args));
        }
    }

    public static void requireState(boolean stateIsValid, String msg) {
        if (!stateIsValid) {
            throw new IllegalStateException(msg);
        }
    }

    @FormatMethod
    public static void requireState(boolean stateIsValid, @FormatString String msgFormat, Object ... args) {
        if (!stateIsValid) {
            throw new IllegalStateException(String.format(msgFormat, args));
        }
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T castNonNull(@Nullable T ref) {
        assert (ref != null) : "Misuse of castNonNull: called with a null argument";
        return ref;
    }

    @DoNotCall(value="Always throws java.lang.UnsupportedOperationException")
    public static <T> T TODO() {
        throw new UnsupportedOperationException("not implemented");
    }
}

