/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.methanol.internal.extensions;

import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.MonotonicNonNull;
import com.namelessmc.plugin.lib.methanol.internal.concurrent.SerialExecutor;
import com.namelessmc.plugin.lib.methanol.internal.flow.FlowSupport;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;

public final class PublisherBodySubscriber
implements HttpResponse.BodySubscriber<Flow.Publisher<List<ByteBuffer>>> {
    private static final Object COMPLETION_AWAITING_STATE = new Object();
    private static final Object DONE_STATE = new Object();
    private static final VarHandle SUBSCRIPTION;
    private final CompletableFuture<Flow.Publisher<List<ByteBuffer>>> publisherFuture = new CompletableFuture();
    private final SerialExecutor serializer = new SerialExecutor(FlowSupport.SYNC_EXECUTOR);
    private Flow.Subscription subscription = FlowSupport.NOOP_SUBSCRIPTION;
    private @MonotonicNonNull Object state;

    @Override
    public CompletionStage<Flow.Publisher<List<ByteBuffer>>> getBody() {
        return this.publisherFuture;
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        Objects.requireNonNull(subscription);
        if (!this.publisherFuture.complete(subscriber -> this.subscribe(subscription, subscriber))) {
            subscription.cancel();
        }
    }

    private void subscribe(Flow.Subscription subscription, Flow.Subscriber<? super List<ByteBuffer>> subscriber) {
        Objects.requireNonNull(subscriber);
        if (!SUBSCRIPTION.compareAndSet(this, FlowSupport.NOOP_SUBSCRIPTION, subscription)) {
            FlowSupport.rejectMulticast(subscriber);
            return;
        }
        this.serializer.execute(() -> {
            Throwable onSubscribeException = null;
            try {
                subscriber.onSubscribe(subscription);
            }
            catch (Throwable t) {
                onSubscribeException = t;
            }
            if (this.state instanceof Throwable) {
                Throwable upstreamException = (Throwable)this.state;
                this.state = DONE_STATE;
                if (onSubscribeException != null) {
                    upstreamException.addSuppressed(onSubscribeException);
                }
                subscriber.onError(upstreamException);
            } else if (onSubscribeException != null && (this.state == COMPLETION_AWAITING_STATE || this.state == null)) {
                this.state = DONE_STATE;
                subscriber.onError(onSubscribeException);
            } else if (this.state == COMPLETION_AWAITING_STATE) {
                this.state = DONE_STATE;
                subscriber.onComplete();
            } else if (this.state == null) {
                this.state = subscriber;
            } else {
                throw new AssertionError((Object)("Unexpected state: " + this.state));
            }
        });
    }

    @Override
    public void onNext(List<ByteBuffer> item) {
        Objects.requireNonNull(item);
        this.serializer.execute(() -> {
            if (this.state instanceof Flow.Subscriber) {
                Flow.Subscriber subscriber = (Flow.Subscriber)this.state;
                try {
                    subscriber.onNext(item);
                }
                catch (Throwable t) {
                    this.state = DONE_STATE;
                    this.subscription.cancel();
                    subscriber.onError(t);
                }
            }
        });
    }

    @Override
    public void onError(Throwable throwable) {
        this.serializer.execute(() -> {
            if (this.state instanceof Flow.Subscriber) {
                Flow.Subscriber subscriber = (Flow.Subscriber)this.state;
                this.state = DONE_STATE;
                subscriber.onError(throwable);
            } else if (this.state == null) {
                this.state = throwable;
            } else {
                FlowSupport.onDroppedException(throwable);
            }
        });
    }

    @Override
    public void onComplete() {
        this.serializer.execute(() -> {
            if (this.state instanceof Flow.Subscriber) {
                Flow.Subscriber subscriber = (Flow.Subscriber)this.state;
                this.state = DONE_STATE;
                subscriber.onComplete();
            } else if (this.state == null) {
                this.state = COMPLETION_AWAITING_STATE;
            }
        });
    }

    public static HttpResponse.BodyHandler<Flow.Publisher<List<ByteBuffer>>> bodyHandler() {
        return responseInfo -> new PublisherBodySubscriber();
    }

    static {
        try {
            SUBSCRIPTION = MethodHandles.lookup().findVarHandle(PublisherBodySubscriber.class, "subscription", Flow.Subscription.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

