/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.methanol.internal.text;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.namelessmc.plugin.lib.methanol.internal.Validate;
import com.namelessmc.plugin.lib.methanol.internal.text.CharMatcher;
import com.namelessmc.plugin.lib.methanol.internal.text.HttpCharMatchers;
import java.nio.CharBuffer;

public final class HeaderValueTokenizer {
    private final CharBuffer buffer;

    public HeaderValueTokenizer(String value) {
        this.buffer = CharBuffer.wrap(value);
    }

    public String nextToken() {
        String token = this.nextMatching(HttpCharMatchers.TOKEN_MATCHER);
        Validate.requireState(!token.isEmpty(), "expected a token at %d", this.buffer.position());
        return token;
    }

    public String nextTokenOrQuotedString() {
        return this.consumeCharIfPresent('\"') ? this.finishQuotedString() : this.nextToken();
    }

    public void consumeCharsMatching(CharMatcher matcher) {
        while (this.buffer.hasRemaining() && matcher.matches(this.buffer.get(this.buffer.position()))) {
            this.buffer.get();
        }
    }

    @CanIgnoreReturnValue
    public boolean consumeCharIfPresent(char c) {
        if (this.buffer.hasRemaining() && this.buffer.get(this.buffer.position()) == c) {
            this.buffer.get();
            return true;
        }
        return false;
    }

    @CanIgnoreReturnValue
    public boolean consumeIfPresent(String value) {
        if (value.length() > this.buffer.remaining()) {
            return false;
        }
        for (int i = 0; i < value.length(); ++i) {
            if (this.buffer.get(this.buffer.position() + i) == value.charAt(i)) continue;
            return false;
        }
        this.buffer.position(this.buffer.position() + value.length());
        return true;
    }

    public String nextMatching(CharMatcher matcher) {
        this.buffer.mark();
        this.consumeCharsMatching(matcher);
        int tokenLimit = this.buffer.position();
        this.buffer.reset();
        int originalLimit = this.buffer.limit();
        String result = this.buffer.limit(tokenLimit).toString();
        this.buffer.position(tokenLimit).limit(originalLimit);
        return result;
    }

    public void requireCharacter(char c) {
        Validate.requireState(this.getCharacter() == c, "expected a %c at %d", Character.valueOf(c), this.buffer.position() - 1);
    }

    public char getCharacter() {
        Validate.requireState(this.buffer.hasRemaining(), "expected more input");
        return this.buffer.get();
    }

    public boolean hasRemaining() {
        return this.buffer.hasRemaining();
    }

    public boolean consumeDelimiter(char delimiter) {
        return this.consumeDelimiter(delimiter, true);
    }

    public boolean consumeDelimiter(char delimiter, boolean requireDelimiter) {
        if (this.hasRemaining()) {
            this.consumeCharsMatching(HttpCharMatchers.OWS_MATCHER);
            if (requireDelimiter) {
                this.requireCharacter(delimiter);
            } else {
                this.consumeCharIfPresent(delimiter);
            }
            do {
                this.consumeCharsMatching(HttpCharMatchers.OWS_MATCHER);
            } while (this.consumeCharIfPresent(delimiter));
        }
        return this.hasRemaining();
    }

    private String finishQuotedString() {
        StringBuilder unescaped = new StringBuilder();
        while (!this.consumeCharIfPresent('\"')) {
            char c = this.getCharacter();
            Validate.requireArgument(HttpCharMatchers.QUOTED_TEXT_MATCHER.matches(c) || c == '\\', "illegal char %#x in a quoted-string", c);
            if (c == '\\') {
                c = this.getCharacter();
                Validate.requireArgument(HttpCharMatchers.QUOTED_PAIR_MATCHER.matches(c), "illegal char %#x in a quoted-pair", c);
            }
            unescaped.append(c);
        }
        return unescaped.toString();
    }
}

