/*
 * Decompiled with CFR 0.152.
 */
package nl.rslot.ssx;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import nl.rslot.ssx.Main;
import nl.rslot.ssx.conditional.ConditionalItem;
import nl.rslot.ssx.lib.nbtapi.NBT;
import nl.rslot.ssx.lib.nbtapi.iface.ReadableNBT;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class HotbarItemManager {
    private final Main plugin;

    HotbarItemManager(Main plugin) {
        this.plugin = plugin;
    }

    void enable() {
        Bukkit.getPluginManager().registerEvents((Listener)new BukkitEventListener(), (Plugin)this.plugin);
    }

    private void debug(String message) {
        if (Main.ITEM_DEBUG) {
            Main.getPlugin().getLogger().info("[Item debug] " + message);
        }
    }

    private boolean shouldHaveItem(Player player, String configName) {
        FileConfiguration config = Main.getConfigurationManager().getItemConfiguration(configName);
        if (config == null) {
            this.debug("Item was for a config file that is now removed");
            return false;
        }
        if (config.getBoolean("give.permission")) {
            this.debug("Permissions are enabled, checking permission");
            String permission = "ssx.item." + configName;
            if (!player.hasPermission(permission)) {
                this.debug("Player does not have permission");
                return false;
            }
        }
        if (config.isList("worlds")) {
            this.debug("World whitelisting is enabled");
            if (!config.getStringList("worlds").contains(player.getWorld().getName())) {
                this.debug("Player is in a world that is not whitelisted (" + player.getWorld().getName() + ")");
                return false;
            }
        }
        return true;
    }

    private void giveItem(Player player, String configName, int currentSlot) {
        FileConfiguration config = Main.getConfigurationManager().getItemConfiguration(configName);
        if (!config.isConfigurationSection("item")) {
            Main.getPlugin().getLogger().warning("Item '" + configName + "' has no item section, it has been ignored.");
            return;
        }
        String cooldownId = player.getUniqueId() + configName;
        PlayerInventory inv = player.getInventory();
        try {
            ConditionalItem.getItem(player, config.getConfigurationSection("item"), cooldownId, arg_0 -> HotbarItemManager.lambda$giveItem$1(configName, (Configuration)config, currentSlot, inv, arg_0));
        }
        catch (InvalidConfigurationException e) {
            player.sendMessage(String.format("Invalid item config (in %s.yaml): %s", configName, e.getMessage()));
        }
    }

    public void updateSsxItems() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.updateSsxItems(player);
        }
    }

    public void updateSsxItems(Player player) {
        this.debug("Updating items for: " + player.getName());
        ItemStack[] contents = player.getInventory().getContents();
        Set<String> itemConfigNames = Main.getConfigurationManager().listItemConfigurations();
        HashSet<String> presentItems = new HashSet<String>();
        for (int slot = 0; slot < contents.length; ++slot) {
            ItemStack item = contents[slot];
            if (item == null) continue;
            ReadableNBT nbt = NBT.readNbt(item);
            if (!nbt.hasTag("SSXItemConfigName")) {
                if (!nbt.hasTag("SSXActions")) continue;
                this.debug("Removing item from old SSX version from slot " + slot);
                player.getInventory().setItem(slot, null);
                continue;
            }
            String configName = nbt.getString("SSXItemConfigName");
            if (!this.shouldHaveItem(player, configName)) {
                this.debug("Player is not allowed to keep item in slot " + slot + ", removing it");
                player.getInventory().setItem(slot, null);
                continue;
            }
            this.debug("Player is allowed to keep item in slot " + slot);
            this.debug("Update item " + slot + " in case the configuration has changed");
            this.giveItem(player, configName, slot);
            presentItems.add(configName);
        }
        for (String configName : itemConfigNames) {
            if (presentItems.contains(configName)) continue;
            this.debug("Player does not have item " + configName);
            if (!this.shouldHaveItem(player, configName)) {
                this.debug("Player should not have the item, not giving it.");
                continue;
            }
            this.debug("Player should have this item, giving it now");
            this.giveItem(player, configName, -1);
        }
    }

    private static /* synthetic */ void lambda$giveItem$1(String configName, Configuration config, int currentSlot, PlayerInventory inv, ItemStack item) {
        NBT.modify(item, nbt -> nbt.setString("SSXItemConfigName", configName));
        int configuredSlot = config.getInt("give.inv-slot", 0);
        if (configuredSlot < 0) {
            if (currentSlot < 0) {
                inv.addItem(new ItemStack[]{item});
            } else {
                inv.setItem(currentSlot, item);
            }
        } else if (currentSlot < 0 || currentSlot == configuredSlot) {
            inv.setItem(configuredSlot, item);
        } else {
            inv.setItem(currentSlot, null);
            inv.setItem(configuredSlot, item);
        }
    }

    private class BukkitEventListener
    implements Listener {
        private BukkitEventListener() {
        }

        @EventHandler(priority=EventPriority.HIGH)
        public void onJoin(PlayerJoinEvent event) {
            Player player = event.getPlayer();
            FileConfiguration config = Main.getConfigurationManager().getInventoryConfiguration();
            if (config.getBoolean("clear-inv", false) && !player.hasPermission("ssx.clearinvbypass")) {
                HotbarItemManager.this.debug("Clearing inventory for " + player.getName());
                PlayerInventory inv = player.getInventory();
                try {
                    int length = ((ItemStack[])inv.getClass().getMethod("getStorageContents", new Class[0]).invoke((Object)inv, new Object[0])).length;
                    inv.getClass().getMethod("setStorageContents", ItemStack[].class).invoke((Object)inv, new Object[]{new ItemStack[length]});
                }
                catch (NoSuchMethodException length) {
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            HotbarItemManager.this.updateSsxItems(player);
        }

        @EventHandler(priority=EventPriority.HIGH)
        public void onWorldChange(PlayerChangedWorldEvent event) {
            HotbarItemManager.this.updateSsxItems(event.getPlayer());
        }

        @EventHandler(priority=EventPriority.HIGH)
        public void onRespawn(PlayerRespawnEvent event) {
            HotbarItemManager.this.updateSsxItems(event.getPlayer());
        }

        @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
        public void onClear(PlayerCommandPreprocessEvent event) {
            if (event.getMessage().equals("/clear") && event.getPlayer().hasPermission("minecraft.command.clear")) {
                Bukkit.getScheduler().runTaskLater((Plugin)Main.getPlugin(), () -> HotbarItemManager.this.updateSsxItems(event.getPlayer()), 1L);
            }
        }

        @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
        public void onPickUpItem(PlayerPickupItemEvent event) {
            ItemStack pickedUpItem = event.getItem().getItemStack();
            ReadableNBT nbt = NBT.readNbt(pickedUpItem);
            if (!nbt.hasTag("SSXItemConfigName")) {
                return;
            }
            Player player = event.getPlayer();
            String itemConfigName = nbt.getString("SSXItemConfigName");
            for (ItemStack item2 : player.getInventory().getContents()) {
                ReadableNBT nbt2;
                if (item2 == null || item2.getType() == Material.AIR || !(nbt2 = NBT.readNbt(item2)).hasTag("SSXItemConfigName") || !nbt2.getString("SSXItemConfigName").equals(itemConfigName)) continue;
                Main.getPlugin().getLogger().info("Deleted duplicate item picked up by " + player.getName());
                event.setCancelled(true);
                event.getItem().remove();
                return;
            }
        }
    }
}

