/*
 * Decompiled with CFR 0.152.
 */
package nl.rslot.ssx;

import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import nl.rslot.ssx.ActionsOnJoinListener;
import nl.rslot.ssx.Commands;
import nl.rslot.ssx.Futures;
import nl.rslot.ssx.Heads;
import nl.rslot.ssx.HotbarItemManager;
import nl.rslot.ssx.ItemClickListener;
import nl.rslot.ssx.ItemMoveDropCancelListener;
import nl.rslot.ssx.ServerSelectorXCommand;
import nl.rslot.ssx.ServerSelectorXCommandCompleter;
import nl.rslot.ssx.Stats;
import nl.rslot.ssx.configuration.ConfigurationManager;
import nl.rslot.ssx.lib.derkutils.bukkit.NbtItemBuilder;
import nl.rslot.ssx.lib.derkutils.bukkit.PlaceholderUtil;
import nl.rslot.ssx.lib.jetbrains-annotations.NotNull;
import nl.rslot.ssx.lib.jetbrains-annotations.Nullable;
import nl.rslot.ssx.lib.kyori.adventure.platform.bukkit.BukkitAudiences;
import nl.rslot.ssx.lib.kyori.adventure.text.Component;
import nl.rslot.ssx.lib.kyori.adventure.text.minimessage.MiniMessage;
import nl.rslot.ssx.lib.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import nl.rslot.ssx.lib.nbtapi.utils.MinecraftVersion;
import nl.rslot.ssx.placeholders.PapiExpansionRegistrar;
import nl.rslot.ssx.placeholders.PlaceholderReceiver;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin {
    public static final JsonParser JSON_PARSER;
    static boolean ITEM_DEBUG;
    private static ConfigurationManager configurationManager;
    private static Main plugin;
    private static BukkitAudiences adventure;
    private final HotbarItemManager hotbarItemManager = new HotbarItemManager(this);
    private Heads heads;
    private static PlaceholderReceiver placeholderReceiver;
    private static final LegacyComponentSerializer LEGACY_COMPONENT_SERIALIZER;

    public HotbarItemManager getHotbarItemManager() {
        return this.hotbarItemManager;
    }

    @NotNull
    public static Main getPlugin() {
        return plugin;
    }

    public void onEnable() {
        plugin = this;
        MinecraftVersion.replaceLogger(this.getLogger());
        configurationManager = new ConfigurationManager();
        try {
            configurationManager.reload();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.heads = new Heads(this);
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
        PluginCommand command = Objects.requireNonNull(this.getCommand("serverselectorx"), "Command missing from plugin.yml");
        command.setExecutor((CommandExecutor)new ServerSelectorXCommand());
        command.setTabCompleter((TabCompleter)new ServerSelectorXCommandCompleter());
        Commands.registerCustomCommands();
        adventure = BukkitAudiences.create((Plugin)this);
        new Stats();
        new ItemMoveDropCancelListener();
        this.hotbarItemManager.enable();
        Bukkit.getPluginManager().registerEvents((Listener)new ItemClickListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new ActionsOnJoinListener(), (Plugin)this);
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            PapiExpansionRegistrar.register();
        }
        placeholderReceiver = new PlaceholderReceiver();
        placeholderReceiver.loadConfiguration();
    }

    public void onDisable() {
        if (adventure != null) {
            adventure.close();
            adventure = null;
        }
    }

    public static ConfigurationManager getConfigurationManager() {
        return configurationManager;
    }

    public static BukkitAudiences adventure() {
        return adventure;
    }

    public static PlaceholderReceiver placeholderReceiver() {
        return placeholderReceiver;
    }

    public static void getItemBuilderFromMaterialString(Player player, @Nullable String materialString, Consumer<NbtItemBuilder> builderConsumer) throws InvalidConfigurationException {
        if (materialString == null || materialString.isEmpty()) {
            return;
        }
        if (materialString.charAt(0) == '!') {
            materialString = PlaceholderUtil.parsePapiPlaceholders(player, materialString.substring(1));
        }
        if (materialString.startsWith("head:")) {
            String headValue = materialString.substring(5);
            if (headValue.equals("self") || headValue.equals("auto")) {
                if (Main.getConfigurationManager().getMiscConfiguration().getBoolean("mojang-api-head-auto", false)) {
                    headValue = "uuid:" + player.getUniqueId();
                } else {
                    builderConsumer.accept((NbtItemBuilder)((NbtItemBuilder)new NbtItemBuilder(Material.SKULL_ITEM).damage(3)).skullOwner(player.getName()));
                    return;
                }
            }
            CompletableFuture<@Nullable String> headTextureFuture = Main.plugin.heads.getHead(headValue);
            Futures.whenCompleteOnMainThread((Plugin)plugin, headTextureFuture, (headTexture, exception) -> {
                if (exception != null) {
                    exception.printStackTrace();
                    return;
                }
                if (headTexture != null) {
                    builderConsumer.accept(((NbtItemBuilder)new NbtItemBuilder(Material.SKULL_ITEM).damage(3)).skullTexture((String)headTexture));
                } else {
                    builderConsumer.accept((NbtItemBuilder)new NbtItemBuilder(Material.SKULL_ITEM).damage(3));
                }
            });
            return;
        }
        String[] materialsToTry = materialString.split("\\|");
        Material material = null;
        for (String materialString2 : materialsToTry) {
            try {
                material = Material.valueOf((String)materialString2);
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        if (material == null) {
            player.sendMessage("Invalid item name '" + materialString + "'");
            player.sendMessage("https://github.com/ServerSelectorX/ServerSelectorX/wiki/Item-names");
            return;
        }
        if (material != Material.AIR) {
            builderConsumer.accept(new NbtItemBuilder(material));
        }
    }

    public static String miniMessageToLegacy(String miniMessage) {
        return LEGACY_COMPONENT_SERIALIZER.serialize((Component)MiniMessage.miniMessage().deserialize(miniMessage));
    }

    static {
        MinecraftVersion.disableUpdateCheck();
        JSON_PARSER = new JsonParser();
        ITEM_DEBUG = false;
        LEGACY_COMPONENT_SERIALIZER = LegacyComponentSerializer.builder().character('\u00a7').hexColors().useUnusualXRepeatedCharacterHexFormat().build();
    }
}

